uniform vec2 u_seed;
uniform vec2 u_ratio; // vec2(1.0, 1.0);
uniform vec2 u_border; // = vec2(0.1, 0.2);
uniform vec3 u_color;
uniform vec2 u_control;

varying vec2 v_texCoord0;

const float windows = 100.0;

float rand(vec2 v)
{
    return fract(sin(dot(v.xy ,vec2(12.9898,78.233))) * 43758.5453);
}


void main(void)
{	
	vec2 coord = v_texCoord0 * windows * u_ratio;
	vec2 u = mod(coord, 1.0);
	vec2 iw = floor(coord);

	float b0 = smoothstep(0.9, 0.95, rand(u_seed + vec2(iw.y, floor(v_texCoord0.x * windows * .05) )));
	float fw = vec2(windows * fwidth(v_texCoord0));
	
	vec4 r = vec4(rand(iw + vec2(0.0, 0.0) + u_seed),
				  rand(iw + vec2(1.0, 0.0) + u_seed),
				  rand(iw + vec2(0.0, 1.0) + u_seed),
				  rand(iw + vec2(1.0, 1.0) + u_seed));
				  
	vec3 col = vec3(0.0);	
	// background
	col += vec3(clamp(pow(r.x, 8.0) + 0.5 * b0, 0.0, 1.0));
	col.z *= 0.9;
	
	// light tint
    float tint = smoothstep(0.89, 0.91, r.y);	
	vec3 tintCol = mix(vec3(0.0, 0.0, 0.1), vec3(0.0, 0.1, 0.0), r.z);
	col += tint * tintCol;	
	
	// furniture
	col -= 0.2 * vec3(1.0 - u.y);
	col -= 0.3 * smoothstep(0.1, 1.0, 1.0 - length(u - vec2(r.y, r.a-1.0)));

	
	// frames
	vec2 fv = smoothstep(u_border-fw, u_border, u) * (1.0 - smoothstep(1.0-u_border-fw, 1.0-u_border, u));	
	float f = fv.x * fv.y;	
	vec3 c = (f * col + u_color) * u_control.x * (1.0 - step(u_control.y, v_texCoord0.y));
	gl_FragColor = vec4(c, 1.0);	
}