uniform float u_pixel;
uniform float u_blend;
uniform float u_alpha;
uniform float u_ratio;

uniform sampler2D u_texture0;

varying vec2 v_texCoord0;

void main(void)
{
	vec2 uv = v_texCoord0;
	vec3 col = vec3(0.0);	
	vec2 mid = vec2(0.5, u_ratio);

	if (u_pixel > 0) {
		vec2 coord = (floor((uv - mid) / u_pixel)) * u_pixel + mid;	
		col += texture2D(u_texture0, coord).xyz;
	} else {
		col += texture2D(u_texture0, uv).xyz;
	}		

	if (u_blend > 0.0) {
		col += texture2D(u_texture0, uv).xyz*u_blend;
	}
	
	col *= pow(16.0 * uv.x * (1.0-uv.x) * uv.y * (1.0-uv.y), 0.5);
	gl_FragColor = vec4(col * u_alpha, 1.0);	
}