precision mediump float;

uniform sampler3D force;
uniform sampler2D velocity;
uniform sampler2D position;

uniform float dt;

varying vec2 texCoord0;

void main(void) {
	vec4 p = texture2d(position, texCoord0);
	vec4 a = texture3d(force, p.xyz);
	vec4 v = texture2d(velocity, texCoord0);
	
	vec3 vel = v.xyz + dt * a.xyz;
	float decay = a.w <= 0 ? dt : a.w;
	
    gl_FragColor = vec4(pos, v.w - decay);
}