uniform float u_time;
uniform vec3 u_camDirection;
uniform vec3 u_camPosition;

varying vec2 v_texCoord0;

const vec3 camera_up = vec3(0, 1, 0);

float hash( float n );
float noise( in vec3 x );
vec3 voronoi( in vec3 x );
vec3 intersect(vec3 ro, vec3 rd);

void main(void) {
	vec3 direction = normalize(u_camDirection);
	vec3 left = normalize(cross(camera_up, direction));
	vec3 up = cross(direction, left);
	
	vec3 rayDir = normalize(0.5 * direction + v_texCoord0.x * left + v_texCoord0.y * up);
	vec3 rayPos = u_camPosition + rayDir;
	
    // light
	vec3 color = intersect(rayPos, rayDir);
	gl_FragColor = vec4(color, 1.0);
}

vec3 voronoi( in vec3 x ) {
    vec3 p = floor( x );
    vec3 f = fract( x );

    float res = 8.0;
    float res2 = 8.0;
    float res3 = 8.0;
	
    for( int k=-1; k<=1; k++ )
    for( int j=-1; j<=1; j++ )
    for( int i=-1; i<=1; i++ )
    {
        vec3 b = vec3( i, j, k );
        vec3 r = b - f + noise(p+b);
        float d = dot( r, r );

		if (d < res) {
			res3 = res2; res2 = res; res = d; 
		} else if (d < res2) {
			res3 = res2; res2 = d;
		} else if (d < res3) {
			res3 = d;
		}
     }
	return vec3(sqrt(res),sqrt(res2),sqrt(res3));
}

vec3 intersect(vec3 ro, vec3 rd) {
	float size = 2.0 + sin(u_time*0.1);
	vec3 p = ro + 2.0 * size * rd;
	
	vec3 v = voronoi(p + vec3(0.1)*u_time);
	float x = smoothstep(0.0, 0.7, v.x*v.x*v.z);
	float y = smoothstep(0.3, 0.95, v.y*v.y);
	float z = smoothstep(0.4, 0.8, v.z*v.y);
	
	vec3 X = vec3(0.2, 0.4, 1.0) * x;
	vec3 Y = vec3(0.4, 1.0, 0.2) * y;
	vec3 Z = vec3(1.0, 0.2, 0.4) * z;

	vec3 color = X + Y + Z;	
	return color * color;
}

float noise( in vec3 x ) {
return noise1(x);
/*
    vec3 p = floor(x);
    vec3 f = fract(x);

    f = f*f*(3.0-2.0*f);
    float n = p.x + p.y*57.0 + 113.0*p.z;
    return mix(mix(mix( hash(n+  0.0), hash(n+  1.0),f.x),
                   mix( hash(n+ 57.0), hash(n+ 58.0),f.x),f.y),
               mix(mix( hash(n+113.0), hash(n+114.0),f.x),
                   mix( hash(n+170.0), hash(n+171.0),f.x),f.y),f.z);
*/              
}

float hash( float n ) {
    return fract(sin(n)*43758.5453);
}
