/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.av;

import com.jogamp.common.net.URIQueryProps;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.LFRingbuffer;
import com.jogamp.common.util.Ringbuffer;
import com.jogamp.opengl.util.TimeFrameI;
import com.jogamp.opengl.util.av.AudioSink;
import com.jogamp.opengl.util.av.GLMediaPlayer;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureIO;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.opengl.Debug;

public abstract class GLMediaPlayerImpl
implements GLMediaPlayer {
    private static final int STREAM_WORKER_DELAY = Debug.getIntProperty((String)"jogl.debug.GLMediaPlayer.StreamWorker.delay", (boolean)false, (int)0);
    protected static final String unknown = "unknown";
    protected volatile GLMediaPlayer.State state;
    private Object stateLock = new Object();
    protected int textureCount = 0;
    protected int textureTarget = 3553;
    protected int textureFormat = 6408;
    protected int textureInternalFormat = 6408;
    protected int textureType = 5121;
    protected int texUnit = 0;
    protected int[] texMinMagFilter = new int[]{9728, 9728};
    protected int[] texWrapST = new int[]{33071, 33071};
    protected URI streamLoc = null;
    protected String cameraPath = null;
    protected Map<String, String> cameraProps = null;
    protected volatile float playSpeed = 1.0f;
    protected float audioVolume = 1.0f;
    protected int vid = -1;
    protected int aid = -1;
    protected int width = 0;
    protected int height = 0;
    protected float fps = 0.0f;
    protected float frame_duration = 0.0f;
    protected int bps_stream = 0;
    protected int bps_video = 0;
    protected int bps_audio = 0;
    protected int videoFrames = 0;
    protected int audioFrames = 0;
    protected int duration = 0;
    protected String acodec = "unknown";
    protected String vcodec = "unknown";
    protected volatile int decodedFrameCount = 0;
    protected int presentedFrameCount = 0;
    protected int displayedFrameCount = 0;
    protected volatile int video_pts_last = 0;
    protected AudioSink audioSink = null;
    protected boolean audioSinkPlaySpeedSet = false;
    private long audio_scr_t0 = 0L;
    private boolean audioSCR_reset = true;
    private long video_scr_t0 = 0L;
    private int video_scr_pts = 0;
    private float video_dpts_cum = 0.0f;
    private int video_dpts_count = 0;
    private static final int VIDEO_DPTS_NUM = 20;
    private static final float VIDEO_DPTS_COEFF = 0.7943282f;
    private static final int VIDEO_DPTS_MAX = 5000;
    private boolean videoSCR_reset = false;
    protected TextureSequence.TextureFrame[] videoFramesOrig = null;
    protected Ringbuffer<TextureSequence.TextureFrame> videoFramesFree = null;
    protected Ringbuffer<TextureSequence.TextureFrame> videoFramesDecoded = null;
    protected volatile TextureSequence.TextureFrame lastFrame = null;
    protected boolean isInGLOrientation = false;
    private ArrayList<GLMediaPlayer.GLMediaEventListener> eventListeners = new ArrayList();
    protected TextureSequence.TextureFrame cachedFrame = null;
    protected long lastTimeMillis = 0L;
    static int StreamWorkerInstanceId = 0;
    private StreamWorker streamWorker = null;
    private Object eventListenersLock = new Object();

    protected GLMediaPlayerImpl() {
        this.state = GLMediaPlayer.State.Uninitialized;
    }

    @Override
    public final void setTextureUnit(int n) {
        this.texUnit = n;
    }

    @Override
    public final int getTextureUnit() {
        return this.texUnit;
    }

    @Override
    public final int getTextureTarget() {
        return this.textureTarget;
    }

    @Override
    public final int getTextureCount() {
        return this.textureCount;
    }

    protected final void setTextureTarget(int n) {
        this.textureTarget = n;
    }

    protected final void setTextureFormat(int n, int n2) {
        this.textureInternalFormat = n;
        this.textureFormat = n2;
    }

    protected final void setTextureType(int n) {
        this.textureType = n;
    }

    @Override
    public final void setTextureMinMagFilter(int[] nArray) {
        this.texMinMagFilter[0] = nArray[0];
        this.texMinMagFilter[1] = nArray[1];
    }

    @Override
    public final int[] getTextureMinMagFilter() {
        return this.texMinMagFilter;
    }

    @Override
    public final void setTextureWrapST(int[] nArray) {
        this.texWrapST[0] = nArray[0];
        this.texWrapST[1] = nArray[1];
    }

    @Override
    public final int[] getTextureWrapST() {
        return this.texWrapST;
    }

    private final void checkGLInit() {
        if (GLMediaPlayer.State.Uninitialized == this.state || GLMediaPlayer.State.Initialized == this.state) {
            throw new IllegalStateException("GL not initialized: " + this);
        }
    }

    @Override
    public String getRequiredExtensionsShaderStub() throws IllegalStateException {
        this.checkGLInit();
        if (36197 == this.textureTarget) {
            return "#extension GL_OES_EGL_image_external : enable\n";
        }
        return "";
    }

    @Override
    public String getTextureSampler2DType() throws IllegalStateException {
        this.checkGLInit();
        switch (this.textureTarget) {
            case 3553: 
            case 34037: {
                return "sampler2D";
            }
            case 36197: {
                return "samplerExternalOES";
            }
        }
        throw new GLException("Unsuported texture target: " + GLMediaPlayerImpl.toHexString(this.textureTarget));
    }

    @Override
    public String getTextureLookupFunctionName(String string) throws IllegalStateException {
        this.checkGLInit();
        return "texture2D";
    }

    @Override
    public String getTextureLookupFragmentShaderImpl() throws IllegalStateException {
        this.checkGLInit();
        return "";
    }

    @Override
    public final int getDecodedFrameCount() {
        return this.decodedFrameCount;
    }

    @Override
    public final int getPresentedFrameCount() {
        return this.presentedFrameCount;
    }

    @Override
    public final int getVideoPTS() {
        return this.video_pts_last;
    }

    @Override
    public final int getAudioPTS() {
        if (GLMediaPlayer.State.Uninitialized != this.state) {
            return this.getAudioPTSImpl();
        }
        return 0;
    }

    protected int getAudioPTSImpl() {
        if (null != this.audioSink) {
            return this.audioSink.getPTS();
        }
        return 0;
    }

    @Override
    public final GLMediaPlayer.State getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GLMediaPlayer.State play() {
        Object object = this.stateLock;
        synchronized (object) {
            GLMediaPlayer.State state = this.state;
            switch (this.state) {
                case Paused: {
                    if (!this.playImpl()) break;
                    this.resetAVPTS();
                    if (null != this.audioSink) {
                        this.audioSink.play();
                    }
                    this.streamWorker.doResume();
                    this.changeState(0, GLMediaPlayer.State.Playing);
                }
            }
            if (DEBUG) {
                System.err.println("Play: " + (Object)((Object)state) + " -> " + (Object)((Object)this.state) + ", " + this.toString());
            }
            return this.state;
        }
    }

    protected abstract boolean playImpl();

    @Override
    public final GLMediaPlayer.State pause(boolean bl) {
        return this.pauseImpl(bl, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final GLMediaPlayer.State pauseImpl(boolean bl, int n) {
        Object object = this.stateLock;
        synchronized (object) {
            GLMediaPlayer.State state = this.state;
            if (GLMediaPlayer.State.Playing == this.state) {
                n = this.addStateEventMask(n, GLMediaPlayer.State.Paused);
                this.state = GLMediaPlayer.State.Paused;
                this.streamWorker.doPause();
                if (bl) {
                    this.resetAVPTSAndFlush();
                } else if (null != this.audioSink) {
                    this.audioSink.pause();
                }
                this.attributesUpdated(n);
                if (!this.pauseImpl()) {
                    this.play();
                }
            }
            if (DEBUG) {
                System.err.println("Pause: " + (Object)((Object)state) + " -> " + (Object)((Object)this.state) + ", " + this.toString());
            }
            return this.state;
        }
    }

    protected abstract boolean pauseImpl();

    @Override
    public final GLMediaPlayer.State destroy(GL gL) {
        return this.destroyImpl(gL, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final GLMediaPlayer.State destroyImpl(GL gL, int n) {
        Object object = this.stateLock;
        synchronized (object) {
            this.streamWorker.doStop();
            this.streamWorker = null;
            this.destroyImpl(gL);
            this.removeAllTextureFrames(gL);
            this.textureCount = 0;
            this.changeState(n, GLMediaPlayer.State.Uninitialized);
            return this.state;
        }
    }

    protected abstract void destroyImpl(GL var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int seek(int n) {
        Object object = this.stateLock;
        synchronized (object) {
            int n2;
            GLMediaPlayer.State state = this.state;
            switch (this.state) {
                case Paused: 
                case Playing: {
                    GLMediaPlayer.State state2 = this.state;
                    this.state = GLMediaPlayer.State.Paused;
                    this.streamWorker.doPause();
                    n2 = this.seekImpl(n);
                    this.resetAVPTSAndFlush();
                    if (null != this.audioSink && GLMediaPlayer.State.Playing == state2) {
                        this.audioSink.play();
                    }
                    System.err.println("SEEK XXX: " + this.getPerfString());
                    this.streamWorker.doResume();
                    this.state = state2;
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
            if (DEBUG) {
                System.err.println("Seek(" + n + "): " + (Object)((Object)state) + " -> " + (Object)((Object)this.state) + ", " + this.toString());
            }
            return n2;
        }
    }

    protected abstract int seekImpl(int var1);

    @Override
    public final float getPlaySpeed() {
        return this.playSpeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean setPlaySpeed(float f) {
        Object object = this.stateLock;
        synchronized (object) {
            float f2 = this.playSpeed;
            boolean bl = false;
            if (GLMediaPlayer.State.Uninitialized != this.state && f > 0.01f) {
                if (Math.abs(1.0f - f) < 0.01f) {
                    f = 1.0f;
                }
                if (this.setPlaySpeedImpl(f)) {
                    this.resetAVPTS();
                    this.playSpeed = f;
                    bl = true;
                }
            }
            if (DEBUG) {
                System.err.println("setPlaySpeed(" + f + "): " + (Object)((Object)this.state) + ", " + f2 + " -> " + this.playSpeed + ", " + this.toString());
            }
            return bl;
        }
    }

    protected boolean setPlaySpeedImpl(float f) {
        if (null != this.audioSink) {
            this.audioSinkPlaySpeedSet = this.audioSink.setPlaySpeed(f);
        }
        return true;
    }

    @Override
    public final float getAudioVolume() {
        this.getAudioVolumeImpl();
        return this.audioVolume;
    }

    protected void getAudioVolumeImpl() {
        if (null != this.audioSink) {
            this.audioVolume = this.audioSink.getVolume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setAudioVolume(float f) {
        Object object = this.stateLock;
        synchronized (object) {
            float f2 = this.audioVolume;
            boolean bl = false;
            if (GLMediaPlayer.State.Uninitialized != this.state) {
                if (Math.abs(f) < 0.01f) {
                    f = 0.0f;
                } else if (Math.abs(1.0f - f) < 0.01f) {
                    f = 1.0f;
                }
                if (this.setAudioVolumeImpl(f)) {
                    this.audioVolume = f;
                    bl = true;
                }
            }
            if (DEBUG) {
                System.err.println("setAudioVolume(" + f + "): " + (Object)((Object)this.state) + ", " + f2 + " -> " + this.audioVolume + ", " + this.toString());
            }
            return bl;
        }
    }

    protected boolean setAudioVolumeImpl(float f) {
        if (null != this.audioSink) {
            return this.audioSink.setVolume(f);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void initStream(URI uRI, int n, int n2, int n3) throws IllegalStateException, IllegalArgumentException {
        Object object = this.stateLock;
        synchronized (object) {
            if (GLMediaPlayer.State.Uninitialized != this.state) {
                throw new IllegalStateException("Instance not in state unintialized: " + this);
            }
            if (null == uRI) {
                throw new IllegalArgumentException("streamLock is null");
            }
            if (-2 != n) {
                this.textureCount = this.validateTextureCount(n3);
                if (this.textureCount < 2) {
                    throw new InternalError("Validated texture count < 2: " + this.textureCount);
                }
            } else {
                this.textureCount = 0;
            }
            this.decodedFrameCount = 0;
            this.presentedFrameCount = 0;
            this.displayedFrameCount = 0;
            this.streamLoc = uRI;
            this.cameraPath = null;
            this.cameraProps = null;
            String string = uRI.getScheme();
            if (null != string && string.equals("camera")) {
                String string2 = uRI.getRawPath();
                if (null != string2 && string2.length() > 0) {
                    this.cameraPath = string2.substring(1);
                    URIQueryProps uRIQueryProps = URIQueryProps.create((URI)uRI, (char)';');
                    this.cameraProps = uRIQueryProps.getProperties();
                } else {
                    throw new IllegalArgumentException("Camera path is empty: " + uRI.toString());
                }
            }
            this.vid = n;
            this.aid = n2;
            if (this.streamLoc != null) {
                this.streamWorker = new StreamWorker();
            }
        }
    }

    protected abstract void initStreamImpl(int var1, int var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GLMediaPlayer.StreamException getStreamException() {
        Object object = this.stateLock;
        synchronized (object) {
            if (null != this.streamWorker) {
                return this.streamWorker.getStreamErr();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void initGL(GL gL) throws IllegalStateException, GLMediaPlayer.StreamException, GLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (GLMediaPlayer.State.Initialized != this.state) {
                throw new IllegalStateException("Stream not in state initialized: " + this);
            }
            GLMediaPlayer.StreamException streamException = this.streamWorker.getStreamErr();
            if (null != streamException) {
                this.streamWorker = null;
                this.destroy(null);
                throw streamException;
            }
            try {
                if (-2 != this.vid) {
                    this.removeAllTextureFrames(gL);
                    this.initGLImpl(gL);
                    if (DEBUG) {
                        System.err.println("initGLImpl.X " + this);
                    }
                    this.videoFramesOrig = this.createTexFrames(gL, this.textureCount);
                    this.videoFramesFree = new LFRingbuffer((Object[])this.videoFramesOrig);
                    this.videoFramesDecoded = new LFRingbuffer(TextureSequence.TextureFrame[].class, this.textureCount);
                    this.lastFrame = (TextureSequence.TextureFrame)this.videoFramesFree.getBlocking();
                    this.streamWorker.initGL(gL);
                } else {
                    this.removeAllTextureFrames(null);
                    this.initGLImpl(null);
                    this.setTextureFormat(-1, -1);
                    this.setTextureType(-1);
                    this.videoFramesOrig = null;
                    this.videoFramesFree = null;
                    this.videoFramesDecoded = null;
                    this.lastFrame = null;
                }
                this.changeState(0, GLMediaPlayer.State.Paused);
            }
            catch (Throwable throwable) {
                this.destroyImpl(gL, 32);
                throw new GLException("Error initializing GL resources", throwable);
            }
        }
    }

    protected abstract void initGLImpl(GL var1) throws IOException, GLException;

    protected int validateTextureCount(int n) {
        return n < 4 ? 4 : n;
    }

    protected TextureSequence.TextureFrame[] createTexFrames(GL gL, int n) {
        int[] nArray = new int[n];
        gL.glGenTextures(n, nArray, 0);
        int n2 = gL.glGetError();
        if (0 != n2) {
            throw new RuntimeException("TextureNames creation failed (num: " + n + "): err " + GLMediaPlayerImpl.toHexString(n2));
        }
        TextureSequence.TextureFrame[] textureFrameArray = new TextureSequence.TextureFrame[n];
        for (int i = 0; i < n; ++i) {
            textureFrameArray[i] = this.createTexImage(gL, nArray[i]);
        }
        return textureFrameArray;
    }

    protected abstract TextureSequence.TextureFrame createTexImage(GL var1, int var2);

    protected final Texture createTexImageImpl(GL gL, int n, int n2, int n3) {
        if (0 > n) {
            throw new RuntimeException("TextureName " + GLMediaPlayerImpl.toHexString(n) + " invalid.");
        }
        gL.glActiveTexture(33984 + this.getTextureUnit());
        gL.glBindTexture(this.textureTarget, n);
        int n4 = gL.glGetError();
        if (0 != n4) {
            throw new RuntimeException("Couldn't bind textureName " + GLMediaPlayerImpl.toHexString(n) + " to 2D target, err " + GLMediaPlayerImpl.toHexString(n4));
        }
        if (36197 != this.textureTarget) {
            gL.glTexImage2D(this.textureTarget, 0, this.textureInternalFormat, n2, n3, 0, this.textureFormat, this.textureType, null);
            n4 = gL.glGetError();
            if (0 != n4) {
                throw new RuntimeException("Couldn't create TexImage2D RGBA " + n2 + "x" + n3 + ", target " + GLMediaPlayerImpl.toHexString(this.textureTarget) + ", ifmt " + GLMediaPlayerImpl.toHexString(this.textureInternalFormat) + ", fmt " + GLMediaPlayerImpl.toHexString(this.textureFormat) + ", type " + GLMediaPlayerImpl.toHexString(this.textureType) + ", err " + GLMediaPlayerImpl.toHexString(n4));
            }
            if (DEBUG) {
                System.err.println("Created TexImage2D RGBA " + n2 + "x" + n3 + ", target " + GLMediaPlayerImpl.toHexString(this.textureTarget) + ", ifmt " + GLMediaPlayerImpl.toHexString(this.textureInternalFormat) + ", fmt " + GLMediaPlayerImpl.toHexString(this.textureFormat) + ", type " + GLMediaPlayerImpl.toHexString(this.textureType));
            }
        }
        gL.glTexParameteri(this.textureTarget, 10241, this.texMinMagFilter[0]);
        gL.glTexParameteri(this.textureTarget, 10240, this.texMinMagFilter[1]);
        gL.glTexParameteri(this.textureTarget, 10242, this.texWrapST[0]);
        gL.glTexParameteri(this.textureTarget, 10243, this.texWrapST[1]);
        return TextureIO.newTexture(n, this.textureTarget, n2, n3, this.width, this.height, !this.isInGLOrientation);
    }

    protected void destroyTexFrame(GL gL, TextureSequence.TextureFrame textureFrame) {
        textureFrame.getTexture().destroy(gL);
    }

    @Override
    public final TextureSequence.TextureFrame getLastTexture() throws IllegalStateException {
        if (GLMediaPlayer.State.Paused != this.state && GLMediaPlayer.State.Playing != this.state) {
            throw new IllegalStateException("Instance not paused or playing: " + this);
        }
        return this.lastFrame;
    }

    private final void removeAllTextureFrames(GL gL) {
        TextureSequence.TextureFrame[] textureFrameArray = this.videoFramesOrig;
        this.videoFramesOrig = null;
        this.videoFramesFree = null;
        this.videoFramesDecoded = null;
        this.lastFrame = null;
        if (null != textureFrameArray) {
            for (int i = 0; i < textureFrameArray.length; ++i) {
                TextureSequence.TextureFrame textureFrame = textureFrameArray[i];
                if (null != textureFrame) {
                    if (null != gL) {
                        this.destroyTexFrame(gL, textureFrame);
                    }
                    textureFrameArray[i] = null;
                }
                System.err.println(Thread.currentThread().getName() + "> Clear TexFrame[" + i + "]: " + textureFrame + " -> null");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final TextureSequence.TextureFrame getNextTexture(GL gL) throws IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (GLMediaPlayer.State.Paused != this.state && GLMediaPlayer.State.Playing != this.state) {
                throw new IllegalStateException("Instance not paused or playing: " + this);
            }
            if (GLMediaPlayer.State.Playing == this.state) {
                TextureSequence.TextureFrame textureFrame = null;
                boolean bl = false;
                try {
                    do {
                        int n;
                        int n2;
                        int n3;
                        int n4;
                        int n5;
                        int n6;
                        boolean bl2;
                        boolean bl3;
                        boolean bl4 = bl3 = null != this.cachedFrame;
                        if (bl) {
                            --this.presentedFrameCount;
                            bl = false;
                            bl2 = true;
                        } else {
                            bl2 = false;
                        }
                        if (bl3) {
                            textureFrame = this.cachedFrame;
                            this.cachedFrame = null;
                            --this.presentedFrameCount;
                        } else if (-2 != this.vid) {
                            textureFrame = (TextureSequence.TextureFrame)this.videoFramesDecoded.get();
                        }
                        long l = Platform.currentTimeMillis();
                        if (null != textureFrame) {
                            ++this.presentedFrameCount;
                            n6 = textureFrame.getPTS();
                            if (n6 == Integer.MAX_VALUE) {
                                this.pauseImpl(true, 16);
                            } else if (n6 != Integer.MIN_VALUE) {
                                int n7;
                                n5 = this.getAudioPTSImpl();
                                n4 = (int)((float)(l - this.audio_scr_t0) * this.playSpeed);
                                n3 = n5 != Integer.MIN_VALUE ? n5 - n4 : 0;
                                n2 = n6 - this.video_pts_last;
                                if (this.videoSCR_reset || (float)n2 > this.frame_duration * 10.0f) {
                                    this.videoSCR_reset = false;
                                    this.video_scr_t0 = l;
                                    this.video_scr_pts = n6;
                                }
                                if (-5000 > (n7 = n6 - (n = this.video_scr_pts + (int)((float)(l - this.video_scr_t0) * this.playSpeed))) || n7 > 5000) {
                                    if (DEBUG) {
                                        System.err.println("AV*: dT " + (l - this.lastTimeMillis) + ", " + this.getPerfStringImpl(n, n6, n7, n4, n5, n3, 0) + ", " + textureFrame + ", playCached " + bl3 + ", dropFrame " + bl);
                                    }
                                } else {
                                    int n8 = this.displayedFrameCount > 0 ? this.displayedFrameCount : 1;
                                    int n9 = (int)(l - this.video_scr_t0) / n8;
                                    int n10 = Math.min(n9, 22);
                                    ++this.video_dpts_count;
                                    this.video_dpts_cum = (float)n7 + 0.7943282f * this.video_dpts_cum;
                                    int n11 = this.video_dpts_count >= 20 ? this.getVideoDPTSAvg() : 0;
                                    int n12 = (int)((float)n11 / this.playSpeed + 0.5f);
                                    TextureSequence.TextureFrame textureFrame2 = textureFrame;
                                    if (n12 > n10) {
                                        this.cachedFrame = textureFrame;
                                        textureFrame = null;
                                    } else if (!bl2 && n12 < -n10 && this.videoFramesDecoded.size() > 0) {
                                        bl = true;
                                    }
                                    this.video_pts_last = n6;
                                    if (DEBUG) {
                                        System.err.println("AV_: dT " + (l - this.lastTimeMillis) + ", " + this.getPerfStringImpl(n, n6, n7, n4, n5, n3, n11) + ", avg dpy-fps " + n9 + " ms/f, maxD " + n10 + " ms, " + textureFrame2 + ", playCached " + bl3 + ", dropFrame " + bl);
                                    }
                                }
                            } else if (DEBUG) {
                                System.err.println("Invalid PTS: " + textureFrame);
                            }
                            if (null != textureFrame) {
                                TextureSequence.TextureFrame textureFrame3 = this.lastFrame;
                                this.lastFrame = textureFrame;
                                this.videoFramesFree.putBlocking((Object)textureFrame3);
                            }
                        } else if (DEBUG) {
                            n6 = this.lastFrame.getPTS();
                            n5 = this.getAudioPTSImpl();
                            n4 = (int)((float)(l - this.audio_scr_t0) * this.playSpeed);
                            n3 = n5 != Integer.MIN_VALUE ? n5 - n4 : 0;
                            n2 = this.video_scr_pts + (int)((float)(l - this.video_scr_t0) * this.playSpeed);
                            n = n6 - n2;
                            System.err.println("AV~: dT " + (l - this.lastTimeMillis) + ", " + this.getPerfStringImpl(n2, n6, n, n4, n5, n3, 0) + ", droppedFrame " + bl2);
                        }
                        this.lastTimeMillis = l;
                    } while (bl);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            ++this.displayedFrameCount;
            return this.lastFrame;
        }
    }

    protected void preNextTextureImpl(GL gL) {
    }

    protected void postNextTextureImpl(GL gL) {
    }

    protected abstract int getNextTextureImpl(GL var1, TextureSequence.TextureFrame var2);

    @Override
    public final AudioSink getAudioSink() {
        return this.audioSink;
    }

    protected void setFirstAudioPTS2SCR(int n) {
        if (this.audioSCR_reset) {
            this.audio_scr_t0 = Platform.currentTimeMillis() - (long)n;
            this.audioSCR_reset = false;
        }
    }

    private void flushAllVideoFrames() {
        if (null != this.videoFramesFree) {
            this.videoFramesFree.resetFull((Object[])this.videoFramesOrig);
            this.lastFrame = (TextureSequence.TextureFrame)this.videoFramesFree.get();
            if (null == this.lastFrame) {
                throw new InternalError("XXX");
            }
        }
        if (null != this.videoFramesDecoded) {
            this.videoFramesDecoded.clear();
        }
        this.cachedFrame = null;
    }

    private void resetAVPTSAndFlush() {
        this.video_dpts_cum = 0.0f;
        this.video_dpts_count = 0;
        this.resetAVPTS();
        this.flushAllVideoFrames();
        if (null != this.audioSink) {
            this.audioSink.flush();
        }
    }

    private void resetAVPTS() {
        this.presentedFrameCount = 0;
        this.displayedFrameCount = 0;
        this.decodedFrameCount = 0;
        this.audioSCR_reset = true;
        this.videoSCR_reset = true;
    }

    private final int getVideoDPTSAvg() {
        return (int)(this.video_dpts_cum * 0.20567179f + 0.5f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void newFrameAvailable(TextureSequence.TextureFrame textureFrame, long l) {
        ++this.decodedFrameCount;
        if (0 == textureFrame.getDuration()) {
            textureFrame.setDuration((int)this.frame_duration);
        }
        Object object = this.eventListenersLock;
        synchronized (object) {
            Iterator<GLMediaPlayer.GLMediaEventListener> iterator = this.eventListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().newFrameAvailable(this, textureFrame, l);
            }
        }
    }

    protected final int addStateEventMask(int n, GLMediaPlayer.State state) {
        if (this.state != state) {
            switch (state) {
                case Uninitialized: {
                    n |= 2;
                    break;
                }
                case Initialized: {
                    n |= 1;
                    break;
                }
                case Playing: {
                    n |= 4;
                    break;
                }
                case Paused: {
                    n |= 8;
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void attributesUpdated(int n) {
        if (0 != n) {
            long l = Platform.currentTimeMillis();
            Object object = this.eventListenersLock;
            synchronized (object) {
                Iterator<GLMediaPlayer.GLMediaEventListener> iterator = this.eventListeners.iterator();
                while (iterator.hasNext()) {
                    iterator.next().attributesChanged(this, n, l);
                }
            }
        }
    }

    protected final void changeState(int n, GLMediaPlayer.State state) {
        if (0 != (n = this.addStateEventMask(n, state))) {
            this.state = state;
            this.attributesUpdated(n);
        }
    }

    protected final void updateAttributes(int n, int n2, int n3, int n4, int n5, int n6, int n7, float f, int n8, int n9, int n10, String string, String string2) {
        int n11 = 0;
        if (this.state == GLMediaPlayer.State.Uninitialized) {
            n11 |= 1;
            this.state = GLMediaPlayer.State.Initialized;
        }
        if (-1 == n) {
            n = -2;
        }
        if (this.vid != n) {
            n11 |= 0x10000;
            this.vid = n;
        }
        if (-1 == n) {
            n = -2;
        }
        if (this.aid != n2) {
            n11 |= 0x20000;
            this.aid = n2;
        }
        if (this.width != n3 || this.height != n4) {
            n11 |= 0x40000;
            this.width = n3;
            this.height = n4;
        }
        if (this.fps != f) {
            n11 |= 0x80000;
            this.fps = f;
            this.frame_duration = 1000.0f / f;
        }
        if (this.bps_stream != n5 || this.bps_video != n6 || this.bps_audio != n7) {
            n11 |= 0x100000;
            this.bps_stream = n5;
            this.bps_video = n6;
            this.bps_audio = n7;
        }
        if (this.videoFrames != n8 || this.audioFrames != n9 || this.duration != n10) {
            n11 |= 0x200000;
            this.videoFrames = n8;
            this.audioFrames = n9;
            this.duration = n10;
        }
        if (null != string2 && string2.length() > 0 && !this.acodec.equals(string2)) {
            n11 |= 0x400000;
            this.acodec = string2;
        }
        if (null != string && string.length() > 0 && !this.vcodec.equals(string)) {
            n11 |= 0x400000;
            this.vcodec = string;
        }
        if (0 == n11) {
            return;
        }
        this.attributesUpdated(n11);
    }

    protected void setIsGLOriented(boolean bl) {
        if (this.isInGLOrientation != bl) {
            if (DEBUG) {
                System.err.println("XXX gl-orient " + this.isInGLOrientation + " -> " + bl);
            }
            this.isInGLOrientation = bl;
            for (int i = 0; i < this.videoFramesOrig.length; ++i) {
                this.videoFramesOrig[i].getTexture().setMustFlipVertically(!bl);
            }
            this.attributesUpdated(262144);
        }
    }

    @Override
    public final URI getURI() {
        return this.streamLoc;
    }

    @Override
    public final int getVID() {
        return this.vid;
    }

    @Override
    public final int getAID() {
        return this.aid;
    }

    @Override
    public final String getVideoCodec() {
        return this.vcodec;
    }

    @Override
    public final String getAudioCodec() {
        return this.acodec;
    }

    @Override
    public final int getVideoFrames() {
        return this.videoFrames;
    }

    @Override
    public final int getAudioFrames() {
        return this.audioFrames;
    }

    @Override
    public final int getDuration() {
        return this.duration;
    }

    @Override
    public final long getStreamBitrate() {
        return this.bps_stream;
    }

    @Override
    public final int getVideoBitrate() {
        return this.bps_video;
    }

    @Override
    public final int getAudioBitrate() {
        return this.bps_audio;
    }

    @Override
    public final float getFramerate() {
        return this.fps;
    }

    @Override
    public final boolean isGLOriented() {
        return this.isInGLOrientation;
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    @Override
    public final String toString() {
        float f = (float)this.getDuration() / 1000.0f;
        String string = null != this.streamLoc ? this.streamLoc.toString() : "<undefined stream>";
        int n = null != this.videoFramesFree ? this.videoFramesFree.size() : 0;
        int n2 = null != this.videoFramesDecoded ? this.videoFramesDecoded.size() : 0;
        int n3 = this.video_scr_pts + (int)((float)(Platform.currentTimeMillis() - this.video_scr_t0) * this.playSpeed);
        String string2 = null != this.cameraPath ? ", camera: " + this.cameraPath : "";
        return "GLMediaPlayer[" + (Object)((Object)this.state) + ", vSCR " + n3 + ", frames[p " + this.presentedFrameCount + ", d " + this.decodedFrameCount + ", t " + this.videoFrames + " (" + f + " s)], " + "speed " + this.playSpeed + ", " + this.bps_stream + " bps, " + "Texture[count " + this.textureCount + ", free " + n + ", dec " + n2 + ", tagt " + GLMediaPlayerImpl.toHexString(this.textureTarget) + ", ifmt " + GLMediaPlayerImpl.toHexString(this.textureInternalFormat) + ", fmt " + GLMediaPlayerImpl.toHexString(this.textureFormat) + ", type " + GLMediaPlayerImpl.toHexString(this.textureType) + "], " + "Video[id " + this.vid + ", <" + this.vcodec + ">, " + this.width + "x" + this.height + ", glOrient " + this.isInGLOrientation + ", " + this.fps + " fps, " + this.frame_duration + " fdur, " + this.bps_video + " bps], " + "Audio[id " + this.aid + ", <" + this.acodec + ">, " + this.bps_audio + " bps, " + this.audioFrames + " frames], uri " + string + string2 + "]";
    }

    @Override
    public final String getPerfString() {
        long l = Platform.currentTimeMillis();
        int n = this.video_scr_pts + (int)((float)(l - this.video_scr_t0) * this.playSpeed);
        int n2 = this.video_pts_last - n;
        int n3 = (int)((float)(l - this.audio_scr_t0) * this.playSpeed);
        int n4 = this.getAudioPTSImpl();
        int n5 = n4 - n3;
        return this.getPerfStringImpl(n, this.video_pts_last, n2, n3, n4, n5, this.getVideoDPTSAvg());
    }

    private final String getPerfStringImpl(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        float f = (float)this.getDuration() / 1000.0f;
        AudioSink audioSink = this.getAudioSink();
        String string = null != audioSink ? "AudioSink[frames [p " + audioSink.getEnqueuedFrameCount() + ", q " + audioSink.getQueuedFrameCount() + ", f " + audioSink.getFreeFrameCount() + ", c " + audioSink.getFrameCount() + "], time " + audioSink.getQueuedTime() + ", bytes " + audioSink.getQueuedByteCount() + "]" : "";
        int n8 = null != this.videoFramesFree ? this.videoFramesFree.size() : 0;
        int n9 = null != this.videoFramesDecoded ? this.videoFramesDecoded.size() : 0;
        return (Object)((Object)this.state) + ", frames[(p " + this.presentedFrameCount + ", d " + this.decodedFrameCount + ") / " + this.videoFrames + ", " + f + " s], " + "speed " + this.playSpeed + ", dAV " + (n3 - n6) + ", vSCR " + n + ", vpts " + n2 + ", dSCR[" + n3 + ", avrg " + n7 + "], " + "aSCR " + n4 + ", apts " + n5 + " ( " + n6 + " ), " + string + ", Texture[count " + this.textureCount + ", free " + n8 + ", dec " + n9 + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addEventListener(GLMediaPlayer.GLMediaEventListener gLMediaEventListener) {
        if (gLMediaEventListener == null) {
            return;
        }
        Object object = this.eventListenersLock;
        synchronized (object) {
            this.eventListeners.add(gLMediaEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeEventListener(GLMediaPlayer.GLMediaEventListener gLMediaEventListener) {
        if (gLMediaEventListener == null) {
            return;
        }
        Object object = this.eventListenersLock;
        synchronized (object) {
            this.eventListeners.remove(gLMediaEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GLMediaPlayer.GLMediaEventListener[] getEventListeners() {
        Object object = this.eventListenersLock;
        synchronized (object) {
            return this.eventListeners.toArray(new GLMediaPlayer.GLMediaEventListener[this.eventListeners.size()]);
        }
    }

    protected static final String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    protected static final String toHexString(int n) {
        return "0x" + Integer.toHexString(n);
    }

    protected static final int getPropIntVal(Map<String, String> map, String string) {
        String string2 = map.get(string);
        try {
            return Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            if (DEBUG) {
                System.err.println("Not a valid integer for <" + string + ">: <" + string2 + ">");
            }
            return 0;
        }
    }

    class StreamWorker
    extends Thread {
        private volatile boolean isRunning = false;
        private volatile boolean isActive = false;
        private volatile boolean isBlocked = false;
        private volatile boolean shallPause = true;
        private volatile boolean shallStop = false;
        private volatile GLMediaPlayer.StreamException streamErr = null;
        private volatile GLContext sharedGLCtx = null;
        private boolean sharedGLCtxCurrent = false;
        private GLDrawable dummyDrawable = null;

        StreamWorker() {
            this.setDaemon(true);
            this.start();
        }

        private void makeCurrent(GLContext gLContext) {
            if (0 >= gLContext.makeCurrent()) {
                throw new GLException("Couldn't make ctx current: " + gLContext);
            }
        }

        private void destroySharedGL() {
            if (null != this.sharedGLCtx) {
                if (this.sharedGLCtx.isCreated()) {
                    try {
                        this.sharedGLCtx.destroy();
                    }
                    catch (GLException gLException) {
                        gLException.printStackTrace();
                    }
                }
                this.sharedGLCtx = null;
            }
            if (null != this.dummyDrawable) {
                AbstractGraphicsDevice abstractGraphicsDevice = this.dummyDrawable.getNativeSurface().getGraphicsConfiguration().getScreen().getDevice();
                this.dummyDrawable.setRealized(false);
                this.dummyDrawable = null;
                abstractGraphicsDevice.close();
            }
        }

        public synchronized void initGL(GL gL) {
            GLContext gLContext = gL.getContext();
            boolean bl = gLContext.isCurrent();
            GLProfile gLProfile = gL.getGLProfile();
            GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLProfile);
            AbstractGraphicsDevice abstractGraphicsDevice = gLContext.getGLDrawable().getNativeSurface().getGraphicsConfiguration().getScreen().getDevice();
            this.dummyDrawable = gLDrawableFactory.createDummyDrawable(abstractGraphicsDevice, true, gLProfile);
            this.dummyDrawable.setRealized(true);
            this.sharedGLCtx = this.dummyDrawable.createContext(gLContext);
            this.makeCurrent(this.sharedGLCtx);
            if (bl) {
                this.makeCurrent(gLContext);
            } else {
                this.sharedGLCtx.release();
            }
        }

        public synchronized void doPause() {
            if (this.isActive) {
                this.shallPause = true;
                if (Thread.currentThread() != this) {
                    if (this.isBlocked && this.isActive) {
                        this.interrupt();
                    }
                    while (this.isActive) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                }
            }
        }

        public synchronized void doResume() {
            if (this.isRunning && !this.isActive) {
                this.shallPause = false;
                if (Thread.currentThread() != this) {
                    while (!this.isActive) {
                        this.notify();
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                }
            }
        }

        public synchronized void doStop() {
            if (this.isRunning) {
                this.shallStop = true;
                if (Thread.currentThread() != this) {
                    if (this.isBlocked && this.isRunning) {
                        this.interrupt();
                    }
                    while (this.isRunning) {
                        this.notify();
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                }
            }
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public GLMediaPlayer.StreamException getStreamErr() {
            return this.streamErr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            this.setName(this.getName() + "-StreamWorker_" + StreamWorkerInstanceId);
            ++StreamWorkerInstanceId;
            Object object = this;
            synchronized (object) {
                this.isRunning = true;
                try {
                    this.isBlocked = true;
                    GLMediaPlayerImpl.this.initStreamImpl(GLMediaPlayerImpl.this.vid, GLMediaPlayerImpl.this.aid);
                    this.isBlocked = false;
                }
                catch (Throwable throwable) {
                    this.streamErr = new GLMediaPlayer.StreamException(throwable.getClass().getSimpleName() + " while initializing: " + GLMediaPlayerImpl.this.toString(), throwable);
                    this.isBlocked = false;
                    this.isRunning = false;
                    GLMediaPlayerImpl.this.changeState(32, GLMediaPlayer.State.Uninitialized);
                    return;
                }
            }
            while (!this.shallStop) {
                Object object2;
                block46: {
                    if (this.shallPause) {
                        object = this;
                        synchronized (object) {
                            if (this.sharedGLCtxCurrent) {
                                GLMediaPlayerImpl.this.postNextTextureImpl(this.sharedGLCtx.getGL());
                                this.sharedGLCtx.release();
                            }
                            while (this.shallPause && !this.shallStop) {
                                this.isActive = false;
                                this.notify();
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    if (this.shallPause) continue;
                                    interruptedException.printStackTrace();
                                }
                            }
                            if (this.sharedGLCtxCurrent) {
                                this.makeCurrent(this.sharedGLCtx);
                                GLMediaPlayerImpl.this.preNextTextureImpl(this.sharedGLCtx.getGL());
                            }
                            this.isActive = true;
                            this.notify();
                        }
                    }
                    if (!this.sharedGLCtxCurrent && null != this.sharedGLCtx) {
                        object = this;
                        synchronized (object) {
                            if (null != this.sharedGLCtx) {
                                this.makeCurrent(this.sharedGLCtx);
                                GLMediaPlayerImpl.this.preNextTextureImpl(this.sharedGLCtx.getGL());
                                this.sharedGLCtxCurrent = true;
                            }
                            if (null == GLMediaPlayerImpl.this.videoFramesFree) {
                                throw new InternalError("XXX videoFramesFree is null");
                            }
                        }
                    }
                    if (this.shallStop) continue;
                    object = null;
                    try {
                        this.isBlocked = true;
                        if (null != GLMediaPlayerImpl.this.videoFramesFree) {
                            object = (TextureSequence.TextureFrame)GLMediaPlayerImpl.this.videoFramesFree.getBlocking();
                            ((TimeFrameI)object).setPTS(Integer.MIN_VALUE);
                            object2 = this.sharedGLCtx.getGL();
                        } else {
                            object2 = null;
                        }
                        this.isBlocked = false;
                        int n = GLMediaPlayerImpl.this.getNextTextureImpl((GL)object2, (TextureSequence.TextureFrame)object);
                        if (Integer.MIN_VALUE != n) {
                            if (null != object) {
                                if (STREAM_WORKER_DELAY > 0) {
                                    Thread.sleep(STREAM_WORKER_DELAY);
                                }
                                if (!GLMediaPlayerImpl.this.videoFramesDecoded.put(object)) {
                                    throw new InternalError("XXX: free " + GLMediaPlayerImpl.this.videoFramesFree + ", decoded " + GLMediaPlayerImpl.this.videoFramesDecoded + ", " + GLMediaPlayerImpl.this);
                                }
                                GLMediaPlayerImpl.this.newFrameAvailable((TextureSequence.TextureFrame)object, Platform.currentTimeMillis());
                                object = null;
                            } else if (Integer.MAX_VALUE == n) {
                                this.shallPause = true;
                                this.isActive = false;
                                GLMediaPlayerImpl.this.pauseImpl(true, 16);
                            }
                        }
                        if (null == object) break block46;
                    }
                    catch (InterruptedException interruptedException) {
                        block47: {
                            this.isBlocked = false;
                            if (!this.shallStop && !this.shallPause) {
                                this.streamErr = new GLMediaPlayer.StreamException("InterruptedException while decoding: " + GLMediaPlayerImpl.this.toString(), interruptedException);
                            }
                            if (null == object) break block47;
                            GLMediaPlayerImpl.this.videoFramesFree.put(object);
                        }
                        if (null == this.streamErr) continue;
                        if (GLMediaPlayer.DEBUG) {
                            object2 = null != this.streamErr.getCause() ? this.streamErr.getCause() : this.streamErr;
                            System.err.println("Caught StreamException: " + ((Throwable)object2).getMessage());
                            ((Throwable)object2).printStackTrace();
                        }
                        this.shallPause = true;
                        this.isActive = false;
                        GLMediaPlayerImpl.this.pauseImpl(true, 32);
                        continue;
                    }
                    catch (Throwable throwable) {
                        block48: {
                            this.streamErr = new GLMediaPlayer.StreamException(throwable.getClass().getSimpleName() + " while decoding: " + GLMediaPlayerImpl.this.toString(), throwable);
                            if (null == object) break block48;
                            {
                                catch (Throwable throwable2) {
                                    if (null != object) {
                                        GLMediaPlayerImpl.this.videoFramesFree.put(object);
                                    }
                                    if (null != this.streamErr) {
                                        if (GLMediaPlayer.DEBUG) {
                                            Throwable throwable3 = null != this.streamErr.getCause() ? this.streamErr.getCause() : this.streamErr;
                                            System.err.println("Caught StreamException: " + throwable3.getMessage());
                                            throwable3.printStackTrace();
                                        }
                                        this.shallPause = true;
                                        this.isActive = false;
                                        GLMediaPlayerImpl.this.pauseImpl(true, 32);
                                    }
                                    throw throwable2;
                                }
                            }
                            GLMediaPlayerImpl.this.videoFramesFree.put(object);
                        }
                        if (null == this.streamErr) continue;
                        if (GLMediaPlayer.DEBUG) {
                            object2 = null != this.streamErr.getCause() ? this.streamErr.getCause() : this.streamErr;
                            System.err.println("Caught StreamException: " + ((Throwable)object2).getMessage());
                            ((Throwable)object2).printStackTrace();
                        }
                        this.shallPause = true;
                        this.isActive = false;
                        GLMediaPlayerImpl.this.pauseImpl(true, 32);
                        continue;
                    }
                    GLMediaPlayerImpl.this.videoFramesFree.put(object);
                }
                if (null == this.streamErr) continue;
                if (GLMediaPlayer.DEBUG) {
                    object2 = null != this.streamErr.getCause() ? this.streamErr.getCause() : this.streamErr;
                    System.err.println("Caught StreamException: " + ((Throwable)object2).getMessage());
                    ((Throwable)object2).printStackTrace();
                }
                this.shallPause = true;
                this.isActive = false;
                GLMediaPlayerImpl.this.pauseImpl(true, 32);
            }
            object = this;
            synchronized (object) {
                if (this.sharedGLCtxCurrent) {
                    GLMediaPlayerImpl.this.postNextTextureImpl(this.sharedGLCtx.getGL());
                }
                this.destroySharedGL();
                this.isRunning = false;
                this.isActive = false;
                this.notify();
            }
        }
    }
}

