/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.macosx.cgl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.gluegen.runtime.opengl.GLProcAddressResolver;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Map;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.OffscreenLayerSurface;
import javax.media.nativewindow.ProxySurface;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GL3ES3;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import javax.media.opengl.GLUniformData;
import jogamp.nativewindow.macosx.OSXUtil;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLFBODrawableImpl;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.macosx.cgl.CGL;
import jogamp.opengl.macosx.cgl.CGLExt;
import jogamp.opengl.macosx.cgl.CGLExtImpl;
import jogamp.opengl.macosx.cgl.CGLExtProcAddressTable;
import jogamp.opengl.macosx.cgl.MacOSXCGLDrawable;
import jogamp.opengl.macosx.cgl.MacOSXCGLGraphicsConfiguration;

public class MacOSXCGLContext
extends GLContextImpl {
    static final boolean isTigerOrLater;
    static final boolean isLionOrLater;
    private static final String shaderBasename = "texture01_xxx";
    private boolean haveSetOpenGLMode = false;
    private MacOSXCGLDrawable.GLBackendType openGLMode = MacOSXCGLDrawable.GLBackendType.NSOPENGL;
    protected GLBackendImpl impl;
    private CGLExt _cglExt;
    private CGLExtProcAddressTable cglExtProcAddressTable;
    private long updateHandle = 0L;
    private int lastWidth;
    private int lastHeight;

    static boolean isGLProfileSupported(int n, int n2, int n3) {
        boolean bl;
        boolean bl2 = 0 != (2 & n);
        boolean bl3 = bl = 0 != (4 & n);
        if (3 == n2 && 1 <= n3 && n3 <= 2) {
            if (!isLionOrLater) {
                return false;
            }
            if (bl2) {
                return false;
            }
            return bl;
        }
        return n2 < 3;
    }

    static int GLProfile2CGLOGLProfileValue(int n, int n2, int n3) {
        boolean bl;
        if (!MacOSXCGLContext.isGLProfileSupported(n, n2, n3)) {
            throw new GLException("OpenGL profile not supported: " + MacOSXCGLContext.getGLVersion(n2, n3, n, "@GLProfile2CGLOGLProfileVersion"));
        }
        boolean bl2 = bl = 0 != (4 & n);
        if (n2 == 3 && n3 >= 1 && bl) {
            return 12800;
        }
        return 4096;
    }

    private static ShaderProgram createCALayerShader(GL3ES3 gL3ES3) {
        ShaderProgram shaderProgram = new ShaderProgram();
        ShaderCode shaderCode = ShaderCode.create(gL3ES3, 35633, MacOSXCGLContext.class, "../../shader", "../../shader/bin", shaderBasename, true);
        ShaderCode shaderCode2 = ShaderCode.create(gL3ES3, 35632, MacOSXCGLContext.class, "../../shader", "../../shader/bin", shaderBasename, true);
        shaderCode.defaultShaderCustomization((GL2ES2)gL3ES3, true, true);
        shaderCode2.defaultShaderCustomization((GL2ES2)gL3ES3, true, true);
        shaderProgram.add(shaderCode);
        shaderProgram.add(shaderCode2);
        if (!shaderProgram.link(gL3ES3, System.err)) {
            throw new GLException("Couldn't link program: " + shaderProgram);
        }
        shaderProgram.useProgram(gL3ES3, true);
        PMVMatrix pMVMatrix = new PMVMatrix();
        pMVMatrix.glMatrixMode(5889);
        pMVMatrix.glLoadIdentity();
        pMVMatrix.glMatrixMode(5888);
        pMVMatrix.glLoadIdentity();
        GLUniformData gLUniformData = new GLUniformData("mgl_PMVMatrix", 4, 4, pMVMatrix.glGetPMvMatrixf());
        gLUniformData.setLocation(gL3ES3, shaderProgram.program());
        gL3ES3.glUniform(gLUniformData);
        shaderProgram.useProgram(gL3ES3, false);
        return shaderProgram;
    }

    protected MacOSXCGLContext(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        super(gLDrawableImpl, gLContext);
        this.initOpenGLImpl(this.getOpenGLMode());
    }

    @Override
    protected void resetStates(boolean bl) {
        this.cglExtProcAddressTable = null;
        super.resetStates(bl);
    }

    @Override
    public Object getPlatformGLExtensions() {
        return this.getCGLExt();
    }

    protected boolean isNSContext() {
        return null != this.impl ? this.impl.isNSContext() : this.openGLMode == MacOSXCGLDrawable.GLBackendType.NSOPENGL;
    }

    public CGLExt getCGLExt() {
        if (this._cglExt == null) {
            this._cglExt = new CGLExtImpl(this);
        }
        return this._cglExt;
    }

    @Override
    public final ProcAddressTable getPlatformExtProcAddressTable() {
        return this.getCGLExtProcAddressTable();
    }

    public final CGLExtProcAddressTable getCGLExtProcAddressTable() {
        return this.cglExtProcAddressTable;
    }

    @Override
    protected Map<String, String> getFunctionNameMap() {
        return null;
    }

    @Override
    protected Map<String, String> getExtensionNameMap() {
        return null;
    }

    @Override
    protected long createContextARBImpl(long l, boolean bl, int n, int n2, int n3) {
        if (!MacOSXCGLContext.isGLProfileSupported(n, n2, n3)) {
            if (DEBUG) {
                System.err.println(MacOSXCGLContext.getThreadName() + ": createContextARBImpl: Not supported " + MacOSXCGLContext.getGLVersion(n2, n3, n, "@creation on OSX " + Platform.getOSVersionNumber()));
            }
            return 0L;
        }
        long l2 = this.impl.create(l, n, n2, n3);
        if (0L != l2) {
            if (!this.impl.makeCurrent(l2)) {
                if (DEBUG) {
                    System.err.println(MacOSXCGLContext.getThreadName() + ": createContextARB couldn't make current " + MacOSXCGLContext.getGLVersion(n2, n3, n, "@creation"));
                }
                this.impl.release(l2);
                this.impl.destroy(l2);
                l2 = 0L;
            } else if (DEBUG) {
                System.err.println(MacOSXCGLContext.getThreadName() + ": createContextARBImpl: OK " + MacOSXCGLContext.getGLVersion(n2, n3, n, "@creation") + ", share " + l + ", direct " + bl + " on OSX " + Platform.getOSVersionNumber());
            }
        } else if (DEBUG) {
            System.err.println(MacOSXCGLContext.getThreadName() + ": createContextARBImpl: NO " + MacOSXCGLContext.getGLVersion(n2, n3, n, "@creation on OSX " + Platform.getOSVersionNumber()));
        }
        return l2;
    }

    @Override
    protected void destroyContextARBImpl(long l) {
        this.impl.release(l);
        this.impl.destroy(l);
    }

    @Override
    public final boolean isGLReadDrawableAvailable() {
        return false;
    }

    protected long createImplPreset(GLContextImpl gLContextImpl) throws GLException {
        MacOSXCGLGraphicsConfiguration macOSXCGLGraphicsConfiguration;
        GLCapabilitiesImmutable gLCapabilitiesImmutable;
        GLProfile gLProfile;
        long l = 0L;
        if (gLContextImpl != null) {
            this.setOpenGLMode(((MacOSXCGLContext)gLContextImpl).getOpenGLMode());
            l = gLContextImpl.getHandle();
            if (l == 0L) {
                throw new GLException("GLContextShareSet returned a NULL OpenGL context");
            }
        }
        if ((gLProfile = (gLCapabilitiesImmutable = (GLCapabilitiesImmutable)(macOSXCGLGraphicsConfiguration = (MacOSXCGLGraphicsConfiguration)this.drawable.getNativeSurface().getGraphicsConfiguration()).getChosenCapabilities()).getGLProfile()).isGLES1() || gLProfile.isGLES2() || gLProfile.isGL4() || gLProfile.isGL3() && !isLionOrLater) {
            throw new GLException("OpenGL profile not supported on MacOSX " + Platform.getOSVersionNumber() + ": " + gLProfile);
        }
        if (DEBUG) {
            System.err.println("Share context is " + MacOSXCGLContext.toHexString(l) + " for " + this);
        }
        return l;
    }

    @Override
    protected boolean createImpl(GLContextImpl gLContextImpl) throws GLException {
        long l = this.createImplPreset(gLContextImpl);
        this.contextHandle = this.createContextARB(l, true);
        return 0L != this.contextHandle;
    }

    @Override
    protected void makeCurrentImpl() throws GLException {
        if (!this.impl.makeCurrent(this.contextHandle)) {
            throw new GLException("Error making Context current: " + this);
        }
        this.drawableUpdatedNotify();
    }

    @Override
    protected void releaseImpl() throws GLException {
        if (!this.impl.release(this.contextHandle)) {
            throw new GLException("Error releasing OpenGL Context: " + this);
        }
    }

    @Override
    protected void destroyImpl() throws GLException {
        this.releaseUpdateHandle();
        if (!this.impl.destroy(this.contextHandle)) {
            throw new GLException("Error destroying OpenGL Context: " + this);
        }
    }

    private final long getUpdateHandle() {
        if (0L == this.updateHandle) {
            NativeSurface nativeSurface;
            boolean bl;
            this.lastWidth = -1;
            this.lastHeight = -1;
            if (this.isCreated() && this.drawable.getChosenGLCapabilities().isOnscreen() && this.isNSContext() && !(bl = (nativeSurface = this.drawable.getNativeSurface()) instanceof ProxySurface ? ((ProxySurface)nativeSurface).containsUpstreamOptionBits(256) : false)) {
                this.updateHandle = CGL.updateContextRegister(this.contextHandle, this.drawable.getHandle());
                if (0L == this.updateHandle) {
                    throw new InternalError("XXX2");
                }
            }
        }
        return this.updateHandle;
    }

    private final void releaseUpdateHandle() {
        if (0L != this.updateHandle) {
            CGL.updateContextUnregister(this.updateHandle);
            this.updateHandle = 0L;
        }
    }

    @Override
    protected void drawableUpdatedNotify() throws GLException {
        if (this.drawable.getChosenGLCapabilities().isOnscreen()) {
            boolean bl;
            long l = this.getUpdateHandle();
            int n = this.drawable.getWidth();
            int n2 = this.drawable.getHeight();
            boolean bl2 = bl = 0L != l && CGL.updateContextNeedsUpdate(l) || n != this.lastWidth || n2 != this.lastHeight;
            if (bl) {
                this.lastWidth = n;
                this.lastHeight = n2;
                if (this.contextHandle == 0L) {
                    throw new GLException("Context not created");
                }
                CGL.updateContext(this.contextHandle);
            }
        }
    }

    @Override
    protected void associateDrawable(boolean bl) {
        if (bl) {
            super.associateDrawable(true);
            this.impl.associateDrawable(true);
            this.getUpdateHandle();
        } else {
            this.releaseUpdateHandle();
            this.impl.associateDrawable(false);
            super.associateDrawable(false);
        }
    }

    void detachPBuffer() {
        this.impl.detachPBuffer();
    }

    @Override
    protected void copyImpl(GLContext gLContext, int n) throws GLException {
        if (this.isNSContext() != ((MacOSXCGLContext)gLContext).isNSContext()) {
            throw new GLException("Source/Destination OpenGL Context tyoe mismatch: source " + gLContext + ", dest: " + this);
        }
        if (!this.impl.copyImpl(gLContext.getHandle(), n)) {
            throw new GLException("Error copying OpenGL Context: source " + gLContext + ", dest: " + this);
        }
    }

    protected void swapBuffers() {
        if (!this.impl.swapBuffers()) {
            throw new GLException("Error swapping buffers: " + this);
        }
    }

    @Override
    protected boolean setSwapIntervalImpl(int n) {
        return this.impl.setSwapInterval(n);
    }

    @Override
    public final ByteBuffer glAllocateMemoryNV(int n, float f, float f2, float f3) {
        throw new GLException("Not yet implemented");
    }

    @Override
    public final void glFreeMemoryNV(ByteBuffer byteBuffer) {
        throw new GLException("Not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void updateGLXProcAddressTable() {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        String string = "MacOSX-" + abstractGraphicsDevice.getUniqueID();
        if (DEBUG) {
            System.err.println(MacOSXCGLContext.getThreadName() + ": Initializing CGL extension address table: " + string);
        }
        ProcAddressTable procAddressTable = null;
        Object object = mappedContextTypeObjectLock;
        synchronized (object) {
            procAddressTable = (ProcAddressTable)mappedGLXProcAddress.get(string);
        }
        if (null != procAddressTable) {
            this.cglExtProcAddressTable = (CGLExtProcAddressTable)procAddressTable;
            if (DEBUG) {
                System.err.println(MacOSXCGLContext.getThreadName() + ": GLContext CGL ProcAddressTable reusing key(" + string + ") -> " + MacOSXCGLContext.toHexString(procAddressTable.hashCode()));
            }
        } else {
            this.cglExtProcAddressTable = new CGLExtProcAddressTable(new GLProcAddressResolver());
            this.resetProcAddressTable(this.getCGLExtProcAddressTable());
            object = mappedContextTypeObjectLock;
            synchronized (object) {
                mappedGLXProcAddress.put(string, this.getCGLExtProcAddressTable());
                if (DEBUG) {
                    System.err.println(MacOSXCGLContext.getThreadName() + ": GLContext CGL ProcAddressTable mapping key(" + string + ") -> " + MacOSXCGLContext.toHexString(((Object)((Object)this.getCGLExtProcAddressTable())).hashCode()));
                }
            }
        }
    }

    @Override
    protected final StringBuilder getPlatformExtensionsStringImpl() {
        return new StringBuilder();
    }

    public void setOpenGLMode(MacOSXCGLDrawable.GLBackendType gLBackendType) {
        if (gLBackendType == this.openGLMode) {
            return;
        }
        if (this.haveSetOpenGLMode) {
            throw new GLException("Can't switch between using NSOpenGLPixelBuffer and CGLPBufferObj more than once");
        }
        this.destroyImpl();
        ((MacOSXCGLDrawable)this.drawable).setOpenGLMode(gLBackendType);
        if (DEBUG) {
            System.err.println("MacOSXCGLContext: Switching context mode " + (Object)((Object)this.openGLMode) + " -> " + (Object)((Object)gLBackendType));
        }
        this.initOpenGLImpl(gLBackendType);
        this.openGLMode = gLBackendType;
        this.haveSetOpenGLMode = true;
    }

    public final MacOSXCGLDrawable.GLBackendType getOpenGLMode() {
        return this.openGLMode;
    }

    protected void initOpenGLImpl(MacOSXCGLDrawable.GLBackendType gLBackendType) {
        switch (gLBackendType) {
            case NSOPENGL: {
                this.impl = new NSOpenGLImpl();
                break;
            }
            case CGL: {
                this.impl = new CGLImpl();
                break;
            }
            default: {
                throw new InternalError("Illegal implementation mode " + (Object)((Object)gLBackendType));
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" [");
        super.append(stringBuilder);
        stringBuilder.append(", mode ");
        stringBuilder.append((Object)this.openGLMode);
        stringBuilder.append("] ");
        return stringBuilder.toString();
    }

    static {
        VersionNumber versionNumber = Platform.getOSVersionNumber();
        isTigerOrLater = versionNumber.getMajor() > 10 || versionNumber.getMajor() == 10 && versionNumber.getMinor() >= 4;
        isLionOrLater = versionNumber.getMajor() > 10 || versionNumber.getMajor() == 10 && versionNumber.getMinor() >= 7;
    }

    class CGLImpl
    implements GLBackendImpl {
        CGLImpl() {
        }

        @Override
        public boolean isNSContext() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long create(long l, int n, int n2, int n3) {
            long l2 = 0L;
            MacOSXCGLGraphicsConfiguration macOSXCGLGraphicsConfiguration = (MacOSXCGLGraphicsConfiguration)MacOSXCGLContext.this.drawable.getNativeSurface().getGraphicsConfiguration();
            GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)macOSXCGLGraphicsConfiguration.getChosenCapabilities();
            long l3 = MacOSXCGLGraphicsConfiguration.GLCapabilities2CGLPixelFormat(gLCapabilitiesImmutable, n, n2, n3);
            if (l3 == 0L) {
                throw new GLException("Unable to allocate pixel format with requested GLCapabilities");
            }
            try {
                int n4;
                PointerBuffer pointerBuffer = PointerBuffer.allocateDirect((int)1);
                if (GLContext.DEBUG) {
                    System.err.println("Share context for CGL-based pbuffer context is " + MacOSXCGLContext.toHexString(l));
                }
                if ((n4 = CGL.CGLCreateContext(l3, l, pointerBuffer)) != 0) {
                    throw new GLException("Error code " + n4 + " while creating context");
                }
                l2 = pointerBuffer.get(0);
                if (0L != l2) {
                    GLCapabilities gLCapabilities = MacOSXCGLGraphicsConfiguration.CGLPixelFormat2GLCapabilities(l3);
                    gLCapabilities = GLGraphicsConfigurationUtil.fixOpaqueGLCapabilities(gLCapabilities, gLCapabilitiesImmutable.isBackgroundOpaque());
                    gLCapabilities.setFBO(false);
                    gLCapabilities.setPBuffer(gLCapabilities.isPBuffer() && !gLCapabilitiesImmutable.isOnscreen());
                    gLCapabilities.setBitmap(false);
                    gLCapabilities.setOnscreen(!gLCapabilities.isPBuffer());
                    macOSXCGLGraphicsConfiguration.setChosenCapabilities(gLCapabilities);
                    if (GLContext.DEBUG) {
                        System.err.println("CGL create fixedCaps: " + gLCapabilities);
                    }
                    if (gLCapabilities.isPBuffer() && (n4 = CGL.CGLSetPBuffer(l2, MacOSXCGLContext.this.drawable.getHandle(), 0, 0, 0)) != 0) {
                        throw new GLException("Error code " + n4 + " while attaching context to pbuffer");
                    }
                }
            }
            finally {
                CGL.CGLDestroyPixelFormat(l3);
            }
            return l2;
        }

        @Override
        public boolean destroy(long l) {
            return CGL.CGLDestroyContext(l) == 0;
        }

        @Override
        public void associateDrawable(boolean bl) {
        }

        @Override
        public boolean copyImpl(long l, int n) {
            CGL.CGLCopyContext(l, MacOSXCGLContext.this.contextHandle, n);
            return true;
        }

        @Override
        public boolean makeCurrent(long l) {
            int n = CGL.CGLLockContext(l);
            if (0 == n) {
                n = CGL.CGLSetCurrentContext(l);
                if (0 == n) {
                    return true;
                }
                if (GLContext.DEBUG) {
                    System.err.println("CGL: Could not make context current: err 0x" + Integer.toHexString(n) + ": " + this);
                }
            } else if (GLContext.DEBUG) {
                System.err.println("CGL: Could not lock context: err 0x" + Integer.toHexString(n) + ": " + this);
            }
            return false;
        }

        @Override
        public boolean release(long l) {
            block5: {
                try {
                    if (MacOSXCGLContext.this.hasRendererQuirk(7) && null != MacOSXCGLContext.this.getGLProcAddressTable()) {
                        MacOSXCGLContext.this.gl.glFlush();
                    }
                }
                catch (GLException gLException) {
                    if (!GLContext.DEBUG) break block5;
                    System.err.println("MacOSXCGLContext.CGLImpl.release: INFO: glFlush() catched exception:");
                    gLException.printStackTrace();
                }
            }
            int n = CGL.CGLSetCurrentContext(0L);
            if (GLContext.DEBUG && 0 != n) {
                System.err.println("CGL: Could not release current context: err 0x" + Integer.toHexString(n) + ": " + this);
            }
            int n2 = CGL.CGLUnlockContext(l);
            if (GLContext.DEBUG && 0 != n2) {
                System.err.println("CGL: Could not unlock context: err 0x" + Integer.toHexString(n2) + ": " + this);
            }
            return 0 == n && 0 == n2;
        }

        @Override
        public boolean detachPBuffer() {
            return true;
        }

        @Override
        public boolean setSwapInterval(int n) {
            IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
            intBuffer.put(0, n);
            CGL.CGLSetParameter(MacOSXCGLContext.this.contextHandle, 222, intBuffer);
            return true;
        }

        @Override
        public boolean swapBuffers() {
            return 0 == CGL.CGLFlushDrawable(MacOSXCGLContext.this.contextHandle);
        }
    }

    class NSOpenGLImpl
    implements GLBackendImpl {
        private OffscreenLayerSurface backingLayerHost = null;
        private long pixelFormat = 0L;
        private int screenVSyncTimeout = 16666;
        private volatile int vsyncTimeout = 17666;
        private int lastWidth = 0;
        private int lastHeight = 0;
        private boolean needsSetContextPBuffer = false;
        private ShaderProgram gl3ShaderProgram = null;
        AttachGLLayerCmd attachGLLayerCmd = null;
        private int skipSync = 0;

        NSOpenGLImpl() {
        }

        @Override
        public boolean isNSContext() {
            return true;
        }

        private long getNSViewHandle(boolean[] blArray, boolean[] blArray2) {
            long l;
            if (MacOSXCGLContext.this.drawable instanceof GLFBODrawableImpl) {
                l = 0L;
                blArray[0] = false;
                blArray2[0] = true;
                if (GLContext.DEBUG) {
                    System.err.println("NS viewHandle.1: GLFBODrawableImpl drawable: isFBO " + blArray2 + ", isPBuffer " + blArray + ", " + MacOSXCGLContext.this.drawable.getClass().getName() + ",\n\t" + MacOSXCGLContext.this.drawable);
                }
            } else {
                long l2 = MacOSXCGLContext.this.drawable.getHandle();
                boolean bl = OSXUtil.isNSView(l2);
                boolean bl2 = OSXUtil.isNSWindow(l2);
                blArray[0] = CGL.isNSOpenGLPixelBuffer(l2);
                blArray2[0] = false;
                if (bl) {
                    l = l2;
                } else if (bl2) {
                    l = OSXUtil.GetNSView(l2);
                } else if (blArray[0]) {
                    l = 0L;
                } else {
                    throw new RuntimeException("Drawable's handle neither NSView, NSWindow nor PBuffer: drawableHandle " + MacOSXCGLContext.toHexString(l2) + ", isNSView " + bl + ", isNSWindow " + bl2 + ", isFBO " + blArray2[0] + ", isPBuffer " + blArray[0] + ", " + MacOSXCGLContext.this.drawable.getClass().getName() + ",\n\t" + MacOSXCGLContext.this.drawable);
                }
                if (GLContext.DEBUG) {
                    System.err.println("NS viewHandle.2: drawableHandle " + MacOSXCGLContext.toHexString(l2) + " -> nsViewHandle " + MacOSXCGLContext.toHexString(l) + ": isNSView " + bl + ", isNSWindow " + bl2 + ", isFBO " + blArray2[0] + ", isPBuffer " + blArray[0] + ", " + MacOSXCGLContext.this.drawable.getClass().getName() + ",\n\t" + MacOSXCGLContext.this.drawable);
                }
            }
            this.needsSetContextPBuffer = blArray[0];
            return l;
        }

        @Override
        public long create(long l, int n, int n2, int n3) {
            boolean bl;
            long l2 = 0L;
            NativeSurface nativeSurface = MacOSXCGLContext.this.drawable.getNativeSurface();
            MacOSXCGLGraphicsConfiguration macOSXCGLGraphicsConfiguration = (MacOSXCGLGraphicsConfiguration)nativeSurface.getGraphicsConfiguration();
            GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)macOSXCGLGraphicsConfiguration.getChosenCapabilities();
            Object object = new boolean[]{false};
            boolean[] blArray = new boolean[]{false};
            long l3 = this.getNSViewHandle((boolean[])object, blArray);
            boolean bl2 = object[0];
            boolean bl3 = blArray[0];
            object = NativeWindowFactory.getOffscreenLayerSurface(nativeSurface, true);
            boolean bl4 = bl = null != object;
            if (!bl && nativeSurface instanceof ProxySurface) {
                bl = ((ProxySurface)nativeSurface).containsUpstreamOptionBits(256);
            }
            GLCapabilitiesImmutable gLCapabilitiesImmutable2 = bl3 ? new GLCapabilities(gLCapabilitiesImmutable.getGLProfile()) : gLCapabilitiesImmutable;
            this.pixelFormat = MacOSXCGLGraphicsConfiguration.GLCapabilities2NSPixelFormat(gLCapabilitiesImmutable2, n, n2, n3);
            if (this.pixelFormat == 0L) {
                if (GLContext.DEBUG) {
                    System.err.println("Unable to allocate pixel format with requested GLCapabilities: " + gLCapabilitiesImmutable);
                }
                return 0L;
            }
            if (bl3) {
                gLCapabilitiesImmutable2 = gLCapabilitiesImmutable;
            } else {
                GLCapabilities gLCapabilities = MacOSXCGLGraphicsConfiguration.NSPixelFormat2GLCapabilities(gLCapabilitiesImmutable.getGLProfile(), this.pixelFormat);
                if (!gLCapabilities.isPBuffer() && bl2) {
                    throw new InternalError("handle is PBuffer, fixedCaps not: " + MacOSXCGLContext.this.drawable);
                }
                gLCapabilities.setPBuffer(bl2);
                gLCapabilities.setBitmap(false);
                gLCapabilities.setOnscreen(!bl3 && !bl2);
                gLCapabilitiesImmutable2 = GLGraphicsConfigurationUtil.fixOpaqueGLCapabilities(gLCapabilities, gLCapabilitiesImmutable.isBackgroundOpaque());
            }
            int n4 = OSXUtil.GetScreenRefreshRate(MacOSXCGLContext.this.drawable.getNativeSurface().getGraphicsConfiguration().getScreen().getIndex());
            if (0 < n4) {
                this.screenVSyncTimeout = 1000000 / n4;
            }
            if (GLContext.DEBUG) {
                System.err.println("NS create OSX>=lion " + isLionOrLater);
                System.err.println("NS create incompleteView: " + bl);
                System.err.println("NS create backingLayerHost: " + object);
                System.err.println("NS create share: " + l);
                System.err.println("NS create drawable type: " + MacOSXCGLContext.this.drawable.getClass().getName());
                System.err.println("NS create drawable handle: isPBuffer " + bl2 + ", isFBO " + bl3);
                System.err.println("NS create pixelFormat: " + MacOSXCGLContext.toHexString(this.pixelFormat));
                System.err.println("NS create chosenCaps: " + gLCapabilitiesImmutable);
                System.err.println("NS create fixedCaps: " + gLCapabilitiesImmutable2);
                System.err.println("NS create drawable native-handle: " + MacOSXCGLContext.toHexString(MacOSXCGLContext.this.drawable.getHandle()));
                System.err.println("NS create drawable NSView-handle: " + MacOSXCGLContext.toHexString(l3));
                System.err.println("NS create screen refresh-rate: " + n4 + " hz, " + this.screenVSyncTimeout + " micros");
            }
            macOSXCGLGraphicsConfiguration.setChosenCapabilities(gLCapabilitiesImmutable2);
            IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
            l2 = CGL.createContext(l, l3, bl, this.pixelFormat, gLCapabilitiesImmutable.isBackgroundOpaque(), intBuffer);
            if (0L == l2) {
                if (GLContext.DEBUG) {
                    System.err.println("NS create failed: viewNotReady: " + (1 == intBuffer.get(0)));
                }
                return 0L;
            }
            if (gLCapabilitiesImmutable.isOnscreen() && !gLCapabilitiesImmutable.isBackgroundOpaque()) {
                CGL.setContextOpacity(l2, 0);
            }
            return l2;
        }

        @Override
        public boolean destroy(long l) {
            if (0L != this.pixelFormat) {
                CGL.deletePixelFormat(this.pixelFormat);
                this.pixelFormat = 0L;
            }
            return CGL.deleteContext(l, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void associateDrawable(boolean bl) {
            this.backingLayerHost = NativeWindowFactory.getOffscreenLayerSurface(MacOSXCGLContext.this.drawable.getNativeSurface(), true);
            if (GLContext.DEBUG) {
                System.err.println("MaxOSXCGLContext.NSOpenGLImpl.associateDrawable: " + bl + ", ctx " + MacOSXCGLContext.toHexString(MacOSXCGLContext.this.contextHandle) + ", hasBackingLayerHost " + (null != this.backingLayerHost) + ", attachGLLayerCmd " + this.attachGLLayerCmd);
            }
            if (bl) {
                if (null != this.backingLayerHost) {
                    int n;
                    long l;
                    int n2;
                    GLCapabilitiesImmutable gLCapabilitiesImmutable = MacOSXCGLContext.this.drawable.getChosenGLCapabilities();
                    long l2 = MacOSXCGLContext.this.getHandle();
                    long l3 = MacOSXCGLContext.this.drawable.getHandle();
                    if (MacOSXCGLContext.this.drawable instanceof GLFBODrawableImpl) {
                        GLFBODrawableImpl gLFBODrawableImpl = (GLFBODrawableImpl)MacOSXCGLContext.this.drawable;
                        n2 = gLFBODrawableImpl.getTextureBuffer(1028).getName();
                        l = 0L;
                        gLFBODrawableImpl.setSwapBufferContext(new GLFBODrawableImpl.SwapBufferContext(){

                            @Override
                            public void swapBuffers(boolean bl) {
                                NSOpenGLImpl.this.swapBuffers();
                            }
                        });
                    } else if (CGL.isNSOpenGLPixelBuffer(l3)) {
                        n2 = 0;
                        l = l3;
                        if (0L != l3) {
                            CGL.setContextPBuffer(l2, l);
                            this.needsSetContextPBuffer = false;
                        }
                    } else {
                        throw new GLException("BackingLayerHost w/ unknown handle (!FBO, !PBuffer): " + MacOSXCGLContext.this.drawable);
                    }
                    this.lastWidth = MacOSXCGLContext.this.drawable.getWidth();
                    this.lastHeight = MacOSXCGLContext.this.drawable.getHeight();
                    if (0 >= this.lastWidth || 0 >= this.lastHeight || !MacOSXCGLContext.this.drawable.isRealized()) {
                        throw new GLException("Drawable not realized yet or invalid texture size, texSize " + this.lastWidth + "x" + this.lastHeight + ", " + MacOSXCGLContext.this.drawable);
                    }
                    if (MacOSXCGLContext.this.isGL3core()) {
                        if (null == this.gl3ShaderProgram) {
                            this.gl3ShaderProgram = MacOSXCGLContext.createCALayerShader(MacOSXCGLContext.this.gl.getGL3ES3());
                        }
                        n = this.gl3ShaderProgram.program();
                    } else {
                        n = 0;
                    }
                    this.attachGLLayerCmd = new AttachGLLayerCmd(this.backingLayerHost, l2, n, this.pixelFormat, l, n2, gLCapabilitiesImmutable.isBackgroundOpaque(), this.lastWidth, this.lastHeight);
                    if (GLContext.DEBUG) {
                        System.err.println("MaxOSXCGLContext.NSOpenGLImpl.associateDrawable(true): " + this.attachGLLayerCmd);
                    }
                    OSXUtil.RunOnMainThread(false, this.attachGLLayerCmd);
                } else {
                    this.lastWidth = MacOSXCGLContext.this.drawable.getWidth();
                    this.lastHeight = MacOSXCGLContext.this.drawable.getHeight();
                    boolean[] blArray = new boolean[]{false};
                    boolean[] blArray2 = new boolean[]{false};
                    CGL.setContextView(MacOSXCGLContext.this.contextHandle, this.getNSViewHandle(blArray, blArray2));
                }
            } else {
                if (null != this.backingLayerHost) {
                    AttachGLLayerCmd attachGLLayerCmd = this.attachGLLayerCmd;
                    this.attachGLLayerCmd = null;
                    if (null == attachGLLayerCmd) {
                        throw new GLException("Null attachGLLayerCmd: " + MacOSXCGLContext.this.drawable);
                    }
                    if (0L != attachGLLayerCmd.pbuffer) {
                        CGL.setContextPBuffer(MacOSXCGLContext.this.contextHandle, 0L);
                    }
                    AttachGLLayerCmd attachGLLayerCmd2 = attachGLLayerCmd;
                    synchronized (attachGLLayerCmd2) {
                        if (!attachGLLayerCmd.valid) {
                            attachGLLayerCmd.valid = true;
                        } else {
                            DetachGLLayerCmd detachGLLayerCmd = new DetachGLLayerCmd(attachGLLayerCmd);
                            if (GLContext.DEBUG) {
                                System.err.println("MaxOSXCGLContext.NSOpenGLImpl.associateDrawable(false): " + detachGLLayerCmd);
                            }
                            OSXUtil.RunOnMainThread(false, detachGLLayerCmd);
                            if (null != this.gl3ShaderProgram) {
                                this.gl3ShaderProgram.destroy(MacOSXCGLContext.this.gl.getGL3());
                                this.gl3ShaderProgram = null;
                            }
                        }
                    }
                }
                CGL.clearDrawable(MacOSXCGLContext.this.contextHandle);
                this.backingLayerHost = null;
            }
        }

        private final void validatePBufferConfig(long l) {
            long l2 = MacOSXCGLContext.this.drawable.getHandle();
            if (this.needsSetContextPBuffer && 0L != l2 && CGL.isNSOpenGLPixelBuffer(l2)) {
                this.needsSetContextPBuffer = false;
                CGL.setContextPBuffer(l, l2);
                if (GLContext.DEBUG) {
                    System.err.println("NS.validateDrawableConfig bind pbuffer " + MacOSXCGLContext.toHexString(l2) + " -> ctx " + MacOSXCGLContext.toHexString(l));
                }
            }
        }

        private final boolean validateDrawableSizeConfig(long l) {
            int n = MacOSXCGLContext.this.drawable.getWidth();
            int n2 = MacOSXCGLContext.this.drawable.getHeight();
            if (this.lastWidth != n || this.lastHeight != n2) {
                this.lastWidth = MacOSXCGLContext.this.drawable.getWidth();
                this.lastHeight = MacOSXCGLContext.this.drawable.getHeight();
                if (GLContext.DEBUG) {
                    System.err.println("NS.validateDrawableConfig size changed");
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean copyImpl(long l, int n) {
            CGL.copyContext(MacOSXCGLContext.this.contextHandle, l, n);
            return true;
        }

        @Override
        public boolean makeCurrent(long l) {
            long l2 = CGL.getCGLContext(l);
            if (0L == l2) {
                throw new InternalError("Null CGLContext for: " + this);
            }
            int n = CGL.CGLLockContext(l2);
            if (0 == n) {
                this.validatePBufferConfig(l);
                return CGL.makeCurrentContext(l);
            }
            if (GLContext.DEBUG) {
                System.err.println("NSGL: Could not lock context: err 0x" + Integer.toHexString(n) + ": " + this);
            }
            return false;
        }

        @Override
        public boolean release(long l) {
            block5: {
                try {
                    if (MacOSXCGLContext.this.hasRendererQuirk(7) && null != MacOSXCGLContext.this.getGLProcAddressTable()) {
                        MacOSXCGLContext.this.gl.glFlush();
                    }
                }
                catch (GLException gLException) {
                    if (!GLContext.DEBUG) break block5;
                    System.err.println("MacOSXCGLContext.NSOpenGLImpl.release: INFO: glFlush() catched exception:");
                    gLException.printStackTrace();
                }
            }
            boolean bl = CGL.clearCurrentContext(l);
            long l2 = CGL.getCGLContext(l);
            if (0L == l2) {
                throw new InternalError("Null CGLContext for: " + this);
            }
            int n = CGL.CGLUnlockContext(l2);
            if (GLContext.DEBUG && 0 != n) {
                System.err.println("CGL: Could not unlock context: err 0x" + Integer.toHexString(n) + ": " + this);
            }
            return bl && 0 == n;
        }

        @Override
        public boolean detachPBuffer() {
            this.needsSetContextPBuffer = true;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setSwapInterval(int n) {
            AttachGLLayerCmd attachGLLayerCmd = this.attachGLLayerCmd;
            if (null != attachGLLayerCmd) {
                AttachGLLayerCmd attachGLLayerCmd2 = attachGLLayerCmd;
                synchronized (attachGLLayerCmd2) {
                    if (attachGLLayerCmd.valid && 0L != attachGLLayerCmd.nsOpenGLLayer) {
                        this.setSwapIntervalImpl(attachGLLayerCmd.nsOpenGLLayer, n);
                        return true;
                    }
                }
            }
            this.setSwapIntervalImpl(0L, n);
            return true;
        }

        private void setSwapIntervalImpl(long l, int n) {
            if (0L != l) {
                CGL.setNSOpenGLLayerSwapInterval(l, n);
                this.vsyncTimeout = 0 < n ? n * this.screenVSyncTimeout + 1000 : 1 * this.screenVSyncTimeout + 1000;
                if (GLContext.DEBUG) {
                    System.err.println("NS setSwapInterval: " + n + " -> " + this.vsyncTimeout + " micros");
                }
            }
            if (GLContext.DEBUG) {
                System.err.println("CGL setSwapInterval: " + n);
            }
            CGL.setSwapInterval(MacOSXCGLContext.this.contextHandle, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean swapBuffers() {
            AttachGLLayerCmd attachGLLayerCmd = this.attachGLLayerCmd;
            if (null != attachGLLayerCmd) {
                AttachGLLayerCmd attachGLLayerCmd2 = attachGLLayerCmd;
                synchronized (attachGLLayerCmd2) {
                    if (attachGLLayerCmd.valid && 0L != attachGLLayerCmd.nsOpenGLLayer) {
                        boolean bl;
                        boolean bl2;
                        int n;
                        boolean bl3;
                        if (this.validateDrawableSizeConfig(MacOSXCGLContext.this.contextHandle)) {
                            this.skipSync = 10;
                        }
                        if (bl3 = MacOSXCGLContext.this.drawable instanceof GLFBODrawableImpl) {
                            n = ((GLFBODrawableImpl)MacOSXCGLContext.this.drawable).getTextureBuffer(1028).getName();
                            bl2 = 0 != n;
                        } else {
                            n = 0;
                            boolean bl4 = bl2 = 0L != MacOSXCGLContext.this.drawable.getHandle();
                        }
                        if (bl2) {
                            bl = CGL.flushBuffer(MacOSXCGLContext.this.contextHandle);
                            if (bl) {
                                if (0 == this.skipSync) {
                                    MacOSXCGLContext.this.gl.glFinish();
                                    CGL.waitUntilNSOpenGLLayerIsReady(attachGLLayerCmd.nsOpenGLLayer, this.vsyncTimeout);
                                } else {
                                    --this.skipSync;
                                }
                                if (bl3) {
                                    CGL.setNSOpenGLLayerNeedsDisplayFBO(attachGLLayerCmd.nsOpenGLLayer, n);
                                } else {
                                    CGL.setNSOpenGLLayerNeedsDisplayPBuffer(attachGLLayerCmd.nsOpenGLLayer, MacOSXCGLContext.this.drawable.getHandle());
                                }
                            }
                        } else {
                            bl = true;
                        }
                        return bl;
                    }
                }
            }
            return CGL.flushBuffer(MacOSXCGLContext.this.contextHandle);
        }

        class DetachGLLayerCmd
        implements Runnable {
            final AttachGLLayerCmd cmd;

            DetachGLLayerCmd(AttachGLLayerCmd attachGLLayerCmd) {
                this.cmd = attachGLLayerCmd;
            }

            public final String toString() {
                return "DetachGLLayerCmd[" + this.cmd.contentToString() + "]";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AttachGLLayerCmd attachGLLayerCmd = this.cmd;
                synchronized (attachGLLayerCmd) {
                    if (this.cmd.valid) {
                        try {
                            OffscreenLayerSurface offscreenLayerSurface = this.cmd.ols;
                            long l = offscreenLayerSurface.getAttachedSurfaceLayer();
                            if (0L != l) {
                                offscreenLayerSurface.detachSurfaceLayer();
                            }
                        }
                        catch (Throwable throwable) {
                            System.err.println("Catched Exception on thread " + MacOSXCGLContext.getThreadName());
                            throwable.printStackTrace();
                        }
                        CGL.releaseNSOpenGLLayer(this.cmd.nsOpenGLLayer);
                        if (GLContext.DEBUG) {
                            System.err.println("NSOpenGLLayer.Detach: OK, layer " + MacOSXCGLContext.toHexString(this.cmd.nsOpenGLLayer) + " - " + MacOSXCGLContext.getThreadName());
                        }
                        this.cmd.nsOpenGLLayer = 0L;
                        this.cmd.valid = false;
                    } else if (GLContext.DEBUG) {
                        System.err.println("NSOpenGLLayer.Detach: Skipped " + MacOSXCGLContext.toHexString(this.cmd.nsOpenGLLayer) + " - " + MacOSXCGLContext.getThreadName());
                    }
                }
            }
        }

        class AttachGLLayerCmd
        implements Runnable {
            final OffscreenLayerSurface ols;
            final long ctx;
            final int shaderProgram;
            final long pfmt;
            final long pbuffer;
            final int texID;
            final boolean isOpaque;
            final int width;
            final int height;
            long nsOpenGLLayer;
            boolean valid;

            AttachGLLayerCmd(OffscreenLayerSurface offscreenLayerSurface, long l, int n, long l2, long l3, int n2, boolean bl, int n3, int n4) {
                this.ols = offscreenLayerSurface;
                this.ctx = l;
                this.shaderProgram = n;
                this.pfmt = l2;
                this.pbuffer = l3;
                this.texID = n2;
                this.isOpaque = bl;
                this.width = n3;
                this.height = n4;
                this.valid = false;
                this.nsOpenGLLayer = 0L;
            }

            public final String contentToString() {
                return "valid " + this.valid + ", size " + this.width + "x" + this.height + ", ctx " + MacOSXCGLContext.toHexString(this.ctx) + ", opaque " + this.isOpaque + ", texID " + this.texID + ", pbuffer " + MacOSXCGLContext.toHexString(this.pbuffer) + ", nsOpenGLLayer " + MacOSXCGLContext.toHexString(this.nsOpenGLLayer);
            }

            public final String toString() {
                return "AttachGLLayerCmd[" + this.contentToString() + "]";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AttachGLLayerCmd attachGLLayerCmd = this;
                synchronized (attachGLLayerCmd) {
                    if (!this.valid) {
                        block15: {
                            try {
                                int n = NSOpenGLImpl.this.screenVSyncTimeout / 2000;
                                RecursiveLock recursiveLock = this.ols.getLock();
                                if (!recursiveLock.tryLock((long)n)) break block15;
                                try {
                                    if (!MacOSXCGLContext.this.lock.tryLock((long)n)) break block15;
                                    try {
                                        this.nsOpenGLLayer = CGL.createNSOpenGLLayer(this.ctx, this.shaderProgram, this.pfmt, this.pbuffer, this.texID, this.isOpaque, this.width, this.height);
                                        this.ols.attachSurfaceLayer(this.nsOpenGLLayer);
                                        int n2 = MacOSXCGLContext.this.getSwapInterval();
                                        int n3 = 0 <= n2 ? n2 : 1;
                                        NSOpenGLImpl.this.setSwapIntervalImpl(this.nsOpenGLLayer, n3);
                                        this.valid = true;
                                        if (GLContext.DEBUG) {
                                            System.err.println("NSOpenGLLayer.Attach: OK, layer " + MacOSXCGLContext.toHexString(this.nsOpenGLLayer) + " w/ pbuffer " + MacOSXCGLContext.toHexString(this.pbuffer) + ", texID " + this.texID + ", texSize " + NSOpenGLImpl.this.lastWidth + "x" + NSOpenGLImpl.this.lastHeight + ", drawableHandle " + MacOSXCGLContext.toHexString(MacOSXCGLContext.this.drawable.getHandle()) + " - " + MacOSXCGLContext.getThreadName());
                                        }
                                    }
                                    finally {
                                        MacOSXCGLContext.this.lock.unlock();
                                    }
                                }
                                finally {
                                    recursiveLock.unlock();
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                        if (!this.valid) {
                            if (GLContext.DEBUG) {
                                System.err.println("NSOpenGLLayer.Attach: Re-Queue, drawableHandle " + MacOSXCGLContext.toHexString(MacOSXCGLContext.this.drawable.getHandle()) + " - " + MacOSXCGLContext.getThreadName());
                            }
                            OSXUtil.RunLater(true, this, 1);
                        }
                    }
                }
            }
        }
    }

    protected static interface GLBackendImpl {
        public boolean isNSContext();

        public long create(long var1, int var3, int var4, int var5);

        public boolean destroy(long var1);

        public void associateDrawable(boolean var1);

        public boolean copyImpl(long var1, int var3);

        public boolean makeCurrent(long var1);

        public boolean release(long var1);

        public boolean detachPBuffer();

        public boolean setSwapInterval(int var1);

        public boolean swapBuffers();
    }
}

