/*
 * Decompiled with CFR 0.152.
 */
package tazmania.scenes.tree;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.inject.Inject;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import tazadum.engine.math.Interval;
import tazadum.engine.math.Matrix4f;
import tazadum.engine.math.Vector3f;
import tazadum.engine.math.Vector4f;
import tazadum.engine.math.random.Gaussian;
import tazadum.engine.memory.Buffers;
import tazadum.engine.parameter.Parameter;
import tazadum.engine.parameter.ParameterFactory;
import tazadum.engine.rendering.RenderEngine;
import tazadum.engine.rendering.camera.Camera;
import tazadum.engine.rendering.scenegraph.MeshNode;
import tazadum.engine.rendering.scenegraph.Node;
import tazadum.engine.rendering.scenegraph.Scene;
import tazadum.engine.rendering.shader.SimpleShader;
import tazmania.scenes.tree.Branch;

public class TreeScene
implements Scene {
    private static final int MAX_LINES = 1000;
    private static final int MAX_POINTS = 10000;
    private static final int MAX_ITER = 5;
    private static final float REGEN = 0.1f;
    private final FloatBuffer vertices;
    private final SimpleShader shader;
    private final RenderEngine renderEngine;
    private final Vector4f color = new Vector4f(1.0f, 0.0f, 0.0f, 1.0f);
    private final List<Branch> branches = new ArrayList<Branch>(1000);
    private float time = 0.0f;
    private float nextUpdate = 0.0f;
    private final Gaussian nBranches = new Gaussian(1.0f, 0.5f);
    private final Gaussian nBranchesLocation = new Gaussian(1.0f, 0.5f);
    private final Gaussian aLength = new Gaussian(1.0f, 0.5f);
    private final Gaussian branchAngle = new Gaussian(0.0f, 0.5f);
    private final Random random = new Random();
    private final Vector3f X = new Vector3f(1.0f, 0.0f, 0.0f);
    private final Vector3f Y = new Vector3f(0.0f, 1.0f, 0.0f);
    private final Vector3f Z = new Vector3f(0.0f, 0.0f, 1.0f);
    private int vertexCount;
    private final Parameter<Float> gravityParam;
    private final Parameter<Vector3f> branchParam;
    private final Parameter<Vector3f> angleParam;
    private float gravity = 0.0f;

    @Inject
    public TreeScene(RenderEngine renderEngine, ParameterFactory parameterFactory, SimpleShader simpleShader) {
        this.renderEngine = renderEngine;
        this.shader = simpleShader;
        this.vertices = Buffers.allocateFloat(30000);
        this.gravityParam = parameterFactory.constant1f(this, "tree-gravity");
        this.branchParam = parameterFactory.tween3f(this, "tree-branch");
        this.angleParam = parameterFactory.tween3f(this, "tree-angle");
    }

    @Override
    public void onInit(GL gL) {
    }

    @Override
    public void onDeinit(GL gL) {
    }

    @Override
    public void onPreCalc() {
    }

    @Override
    public void onStart(Node<MeshNode> node, Interval interval) {
    }

    @Override
    public void onUpdate(GL2 gL2, float f, float f2, float f3, float f4) {
        this.gravity = this.gravityParam.get(f2).floatValue();
        this.time += f3;
        if (this.branches.isEmpty() || this.time > this.nextUpdate) {
            this.nextUpdate = this.time + 0.1f;
            this.generate(f2);
            this.vertexCount = 0;
            this.vertices.rewind();
            for (Branch object2 : this.branches) {
                if (this.vertexCount >= 10000) break;
                this.vertices.put(object2.from().x);
                this.vertices.put(object2.from().y);
                this.vertices.put(object2.from().z);
                this.vertices.put(object2.to().x);
                this.vertices.put(object2.to().y);
                this.vertices.put(object2.to().z);
                this.vertexCount += 2;
            }
            this.vertices.rewind();
        }
        Camera camera = this.renderEngine.getCamera();
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.fromAngleAxis(f2, Vector3f.UNIT_Y);
        this.shader.enable(gL2);
        this.shader.bindVertices(gL2, this.vertices);
        this.shader.bindProjection(gL2, camera.getProjection());
        this.shader.bindView(gL2, camera.getView());
        this.shader.bindModel(gL2, matrix4f);
        this.shader.bindColor(gL2, this.color);
        gL2.glDrawArrays(1, 0, this.vertexCount);
    }

    @Override
    public void onStop(Node<MeshNode> node) {
    }

    private void generate(float f) {
        this.random.setSeed(4L);
        this.nBranches.seed(104L);
        this.nBranchesLocation.seed(154L);
        this.aLength.seed(204L);
        this.branchAngle.seed(304L);
        this.branches.clear();
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
        Branch branch = new Branch(vector3f, vector3f.add(new Vector3f(0.0f, 5.0f, 0.0f)));
        this.branches.add(branch);
        this.generate(branch, branch.direction(), this.X, 0);
    }

    private void generate(Branch branch, Vector3f vector3f, Vector3f vector3f2, int n) {
        if (n >= 5 || this.branches.size() >= 1000) {
            return;
        }
        ArrayList<Branch> arrayList = new ArrayList<Branch>();
        Vector3f vector3f3 = vector3f.cross(vector3f2).normalizeLocal();
        float f = ((float)n + 1.0f) / 6.0f;
        float f2 = branch.legth();
        Vector3f vector3f4 = this.branchParam.get(f);
        Vector3f vector3f5 = this.angleParam.get(f);
        int n2 = (int)(vector3f4.x * this.nBranches.nextPositive());
        for (int i = 0; i < n2 && this.branches.size() < 1000; ++i) {
            float f3 = f2 * Math.max(0.0f, Math.min(1.0f, vector3f4.y * this.nBranchesLocation.next()));
            Vector3f vector3f6 = branch.from().add(vector3f.mult(f3));
            float f4 = (float)((this.random.nextDouble() - (double)vector3f5.z) * Math.PI * (double)vector3f5.x);
            float f5 = (float)((this.random.nextDouble() - (double)vector3f5.z) * Math.PI * (double)vector3f5.y);
            Vector3f vector3f7 = new Vector3f(vector3f);
            Matrix4f matrix4f = new Matrix4f();
            matrix4f.fromAngleAxis(f4, vector3f2);
            matrix4f.rotateVect(vector3f7);
            matrix4f.fromAngleAxis(f5, vector3f3);
            matrix4f.rotateVect(vector3f7);
            vector3f7.addLocal(this.Y.mult(this.gravity * f));
            vector3f7.normalizeLocal();
            float f6 = Math.max(0.0f, Math.min(1.0f, vector3f4.z * this.aLength.nextPositive())) * f2;
            if (f6 <= 0.1f) continue;
            Branch branch2 = new Branch(vector3f6, vector3f6.add(vector3f7.multLocal(f6)));
            this.branches.add(branch2);
            arrayList.add(branch2);
        }
        for (Branch branch3 : arrayList) {
            this.generate(branch3, branch3.direction(), branch3.direction().cross(vector3f), n + 1);
        }
    }
}

