/*
 * Decompiled with CFR 0.152.
 */
package tazmania.scenes.building;

import com.jogamp.opengl.util.texture.Texture;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.inject.Inject;
import javax.media.opengl.GL;
import tazadum.engine.asset.Asset;
import tazadum.engine.asset.AssetManager;
import tazadum.engine.math.Box;
import tazadum.engine.math.Matrix4f;
import tazadum.engine.math.Quaternion;
import tazadum.engine.math.Rectangle;
import tazadum.engine.math.SimplexNoise;
import tazadum.engine.math.Vector2f;
import tazadum.engine.math.Vector3f;
import tazadum.engine.math.Vector4f;
import tazadum.engine.parameter.ParameterFactory;
import tazadum.engine.rendering.RenderEngine;
import tazadum.engine.rendering.font.Font;
import tazadum.engine.rendering.font.FontSystem;
import tazadum.engine.rendering.material.DefaultMaterial;
import tazadum.engine.rendering.material.DistanceFieldMaterial;
import tazadum.engine.rendering.material.Material;
import tazadum.engine.rendering.mesh.Mesh;
import tazadum.engine.rendering.mesh.MeshBuilder;
import tazadum.engine.rendering.mesh.TexturedMesh;
import tazadum.engine.rendering.scenegraph.DefaultMeshNode;
import tazadum.engine.rendering.scenegraph.MeshNode;
import tazadum.engine.rendering.scenegraph.Node;
import tazadum.engine.rendering.shader.DistanceFieldShader;
import tazadum.engine.rendering.shader.LightShader;
import tazadum.engine.rendering.shader.RoadShader;
import tazadum.engine.rendering.shader.SimpleShader;
import tazadum.engine.rendering.shader.TexturedShader;
import tazadum.engine.rendering.shader.WindowShader;
import tazmania.scenes.building.Building;
import tazmania.scenes.building.BuildingGenerator;
import tazmania.scenes.building.BuildingMaterial;
import tazmania.scenes.building.BuildingType;
import tazmania.scenes.building.Car;

public class CityBuilder {
    private static final float MAX_HEIGHT = 75.0f;
    private static final int CITY_MEGA_BLOCKS = 8;
    private static final int BUILDING_PER_BLOCK = 3;
    private final SimpleShader simpleShader;
    private final WindowShader windowShader;
    private final DistanceFieldShader distanceFieldShader;
    private final Node<MeshNode> cityRoot;
    private final Node<MeshNode> textRoot;
    private final Node<MeshNode> landscapeRoot;
    private final Node<MeshNode> roadRoot;
    private final List<DistanceFieldMaterial> materials = new ArrayList<DistanceFieldMaterial>();
    private final List<Building> buildings = new ArrayList<Building>();
    private final Random random;
    private final DefaultMaterial roadMaterial;
    private final DefaultMaterial carMaterial;
    private BuildingMaterial windowMaterial;
    final float tinyStreet = 3.0f;
    final float bigSteet = 8.0f;
    final float buildingX = 18.0f;
    final float buildingZ = 20.0f;
    final Vector2f buildingSize = new Vector2f(18.0f, 20.0f);
    final float megaSizeX = 63.0f;
    final float megaSizeZ = 69.0f;
    private final List<Rectangle> roads = new ArrayList<Rectangle>();
    private final List<Car> cars = new ArrayList<Car>();
    private final FontSystem fontSystem;
    private boolean initialized = false;
    private boolean textInitialized = false;
    private Node<MeshNode> todayNode;
    private Node<MeshNode> someoneNode;
    private Node<MeshNode> enoughNode;
    private Node<MeshNode> carryNode;
    private Node<MeshNode> bulletNode;
    private Node<MeshNode> bloodNode;

    @Inject
    public CityBuilder(RenderEngine renderEngine, AssetManager assetManager, WindowShader windowShader, LightShader lightShader, SimpleShader simpleShader, RoadShader roadShader, TexturedShader texturedShader, ParameterFactory parameterFactory, FontSystem fontSystem, DistanceFieldShader distanceFieldShader) {
        this.windowShader = windowShader;
        this.simpleShader = simpleShader;
        this.fontSystem = fontSystem;
        this.distanceFieldShader = distanceFieldShader;
        this.cityRoot = new Node<Object>(null);
        this.landscapeRoot = new Node<Object>(null);
        this.roadRoot = new Node<Object>(null);
        this.textRoot = new Node<Object>(null);
        this.roadMaterial = new DefaultMaterial(simpleShader);
        this.roadMaterial.setAmbient(new Vector4f(0.02f, 0.02f, 0.01f, 1.0f));
        this.random = new Random(1003L);
        Asset<Texture> asset = assetManager.loadTexture("resources/textures/car_lights.png");
        this.carMaterial = new DefaultMaterial(texturedShader);
        this.carMaterial.setTextureAsset(asset);
    }

    public List<DistanceFieldMaterial> getMaterials() {
        return this.materials;
    }

    public Node<MeshNode> getTextRoot() {
        return this.textRoot;
    }

    public Node<MeshNode> getCityRoot() {
        return this.cityRoot;
    }

    public Node<MeshNode> getLandscapeRoot() {
        return this.landscapeRoot;
    }

    public Node<MeshNode> getRoadRoot() {
        return this.roadRoot;
    }

    public BuildingMaterial getBuildingMaterial() {
        return this.windowMaterial;
    }

    public void update(float f) {
        for (Car car : this.cars) {
            car.update(f);
        }
    }

    public void create() {
        Object object;
        Node<DefaultMeshNode> node;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        MeshBuilder meshBuilder = new MeshBuilder();
        BuildingGenerator buildingGenerator = new BuildingGenerator(this.random);
        for (int i = 0; i <= 8; ++i) {
            float f;
            if (i < 8) {
                for (int j = 0; j < 8; ++j) {
                    f = i - 4;
                    float f2 = j - 4;
                    node = new Vector3f(f * 71.0f, 0.0f, f2 * 77.0f);
                    this.generateBlock(buildingGenerator, meshBuilder, f, f2, (Vector3f)((Object)node));
                }
            }
            float f3 = (float)(i - 4) * 71.0f - 8.0f - 1.5f;
            f = (float)(i - 4) * 77.0f - 8.0f - 1.5f;
            object = new Rectangle(-292.0f, f, 576.0f, 8.0f);
            node = new Rectangle(f3, -316.0f, 8.0f, 624.0f);
            this.generateRoad(meshBuilder, (Rectangle)object);
            this.generateRoad(meshBuilder, (Rectangle)((Object)node));
            this.roads.add((Rectangle)object);
            this.roads.add((Rectangle)((Object)node));
        }
        this.roadRoot.addChild(new DefaultMeshNode(meshBuilder.build(), this.roadMaterial));
        this.windowMaterial = new BuildingMaterial(this.windowShader);
        DefaultMaterial defaultMaterial = new DefaultMaterial(this.simpleShader);
        this.windowMaterial.setAmbient(new Vector4f(0.006125f, 0.006125f, 0.006125f, 1.0f));
        defaultMaterial.setAmbient(this.windowMaterial.getAmbient());
        for (Building building : this.buildings) {
            object = new Node<DefaultMeshNode>(new DefaultMeshNode(building.getWindow(), this.windowMaterial));
            node = new Node<DefaultMeshNode>(new DefaultMeshNode(building.getSolid(), defaultMaterial));
            node.addChild((DefaultMeshNode)object);
            this.cityRoot.addChild((MeshNode)((Object)node));
        }
        this.generateLandscape();
        this.generateCars();
    }

    private void generateCars() {
        for (Rectangle rectangle : this.roads) {
            Vector3f vector3f = new Vector3f();
            Vector3f vector3f2 = new Vector3f();
            float f = 1.0f;
            if (rectangle.width < rectangle.height) {
                vector3f.z = 1.0f;
                vector3f2.x = 1.0f;
            } else {
                vector3f.x = 1.0f;
                vector3f2.z = 1.0f;
                f *= -1.0f;
            }
            float f2 = Math.max(rectangle.width, rectangle.height);
            float f3 = Math.min(rectangle.width, rectangle.height);
            for (int i = 0; i < 20; ++i) {
                Vector3f vector3f3 = vector3f2.mult(f3 * 4.5f / 8.0f);
                Vector3f vector3f4 = vector3f2.mult(f3 * 6.5f / 8.0f);
                Vector3f vector3f5 = vector3f2.mult(f3 * 1.5f / 8.0f);
                Vector3f vector3f6 = vector3f2.mult(f3 * 3.5f / 8.0f);
                MeshBuilder meshBuilder = new MeshBuilder();
                this.buildCar(meshBuilder, vector3f3, vector3f4, vector3f, false);
                Node<MeshNode> node = new Node<MeshNode>(new DefaultMeshNode(meshBuilder.build(), this.carMaterial));
                MeshBuilder meshBuilder2 = new MeshBuilder();
                this.buildCar(meshBuilder2, vector3f5, vector3f6, vector3f, true);
                Node<MeshNode> node2 = new Node<MeshNode>(new DefaultMeshNode(meshBuilder2.build(), this.carMaterial));
                this.roadRoot.addChild((MeshNode)((Object)node));
                this.roadRoot.addChild((MeshNode)((Object)node2));
                this.cars.add(new Car(node, rectangle, vector3f.mult(this.random.nextFloat() * f2), vector3f.mult(f)));
                this.cars.add(new Car(node2, rectangle, vector3f.mult(this.random.nextFloat() * f2), vector3f.mult(-f)));
            }
        }
    }

    private void buildCar(MeshBuilder meshBuilder, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, boolean bl) {
        Vector2f vector2f = new Vector2f(0.0f, 0.0f);
        Vector2f vector2f2 = new Vector2f(0.0f, 0.5f);
        Vector2f vector2f3 = new Vector2f(1.0f, 0.5f);
        Vector2f vector2f4 = new Vector2f(1.0f, 0.0f);
        Vector2f vector2f5 = new Vector2f(0.0f, 0.5f);
        Vector2f vector2f6 = new Vector2f(0.0f, 1.0f);
        Vector2f vector2f7 = new Vector2f(1.0f, 1.0f);
        Vector2f vector2f8 = new Vector2f(1.0f, 0.5f);
        Vector3f vector3f4 = vector3f3.mult(2 * (bl ? -1 : 1));
        Vector3f vector3f5 = new Vector3f(vector3f.x, vector3f.y + 2.0f, vector3f.z);
        Vector3f vector3f6 = new Vector3f(vector3f2.x, vector3f2.y + 2.0f, vector3f2.z);
        Vector3f vector3f7 = vector3f.add(vector3f4);
        Vector3f vector3f8 = vector3f2.add(vector3f4);
        Vector3f vector3f9 = vector3f5.add(vector3f4);
        Vector3f vector3f10 = vector3f6.add(vector3f4);
        if (bl) {
            meshBuilder.quad(vector3f, vector3f5, vector3f6, vector3f2, vector2f5, vector2f6, vector2f7, vector2f8);
            meshBuilder.quad(vector3f8, vector3f10, vector3f9, vector3f7, vector2f, vector2f2, vector2f3, vector2f4);
        } else {
            meshBuilder.quad(vector3f2, vector3f6, vector3f5, vector3f, vector2f5, vector2f6, vector2f7, vector2f8);
            meshBuilder.quad(vector3f7, vector3f9, vector3f10, vector3f8, vector2f, vector2f2, vector2f3, vector2f4);
        }
    }

    private void generateBlock(BuildingGenerator buildingGenerator, MeshBuilder meshBuilder, float f, float f2, Vector3f vector3f) {
        float f3 = (float)(1.0 / Math.sqrt(288.0));
        for (int i = 0; i < 3; ++i) {
            float f4;
            float f5;
            float f6;
            for (int j = 0; j < 3; ++j) {
                f6 = f * 3.0f + (float)i;
                f5 = f2 * 3.0f + (float)j;
                f4 = (float)Math.sqrt(f6 * f6 + f5 * f5);
                float f7 = 1.1f - f4 * f3;
                float f8 = 75.0f * f7 * f7;
                float f9 = (float)((double)0.95f + this.random.nextGaussian() * (double)0.3f) * (f8 + 8.0f);
                BuildingType buildingType = this.randomBuildingType(f9);
                Vector3f vector3f2 = new Vector3f((float)i * 21.0f, 0.0f, (float)j * 23.0f).addLocal(vector3f);
                Building building = buildingGenerator.generate(vector3f2, this.buildingSize, f9, buildingType);
                this.buildings.add(building);
            }
            if (i <= 0) continue;
            float f10 = vector3f.x + (float)i * 21.0f - 3.0f;
            f6 = vector3f.z - 3.0f;
            this.generateRoad(meshBuilder, new Rectangle(f10, f6, 3.0f, 72.0f));
            f5 = vector3f.x - 3.0f;
            f4 = vector3f.z + (float)i * 23.0f - 3.0f;
            this.generateRoad(meshBuilder, new Rectangle(f5, f4, 66.0f, 3.0f));
        }
    }

    private BuildingType randomBuildingType(float f) {
        BuildingType[] buildingTypeArray = BuildingType.values();
        return buildingTypeArray[this.random.nextInt(buildingTypeArray.length)];
    }

    private void generateRoad(MeshBuilder meshBuilder, Rectangle rectangle) {
        Vector2f vector2f = new Vector2f(0.0f, 0.0f);
        Vector2f vector2f2 = new Vector2f(0.0f, 1.0f);
        Vector2f vector2f3 = new Vector2f(1.0f, 1.0f);
        Vector2f vector2f4 = new Vector2f(1.0f, 0.0f);
        Vector3f vector3f = new Vector3f(rectangle.x, 0.0f, rectangle.y);
        Vector3f vector3f2 = new Vector3f(rectangle.x, 0.0f, rectangle.y + rectangle.height);
        Vector3f vector3f3 = new Vector3f(rectangle.x + rectangle.width, 0.0f, rectangle.y + rectangle.height);
        Vector3f vector3f4 = new Vector3f(rectangle.x + rectangle.width, 0.0f, rectangle.y);
        meshBuilder.quad(vector3f4, vector3f3, vector3f2, vector3f, vector2f4, vector2f3, vector2f2, vector2f);
    }

    private float landscape(float f, float f2) {
        float f3 = 0.0f;
        f3 += 0.5f * (float)SimplexNoise.noise(f * 16.0f, 1.0f * f2);
        f3 += 0.25f * (float)SimplexNoise.noise(f * 32.0f, 2.0f * f2);
        return (f3 += 0.125f * (float)SimplexNoise.noise(f * 64.0f, 3.0f * f2)) + 1.0f;
    }

    private void generateLandscape() {
        MeshBuilder meshBuilder = new MeshBuilder();
        for (int i = 0; i < 2; ++i) {
            float f = 800.0f * (1.0f + (float)(i * i * i) * 0.75f);
            for (int j = 0; j < 128; ++j) {
                float f2 = (float)j / 128.0f;
                float f3 = (float)(j + 1) / 128.0f % 1.0f;
                float f4 = (float)Math.PI * 2 * f2;
                float f5 = (float)Math.PI * 2 * f3;
                float f6 = this.landscape(f2, i * 10) * (100.0f + (float)(i * 75));
                float f7 = this.landscape(f3, i * 10) * (100.0f + (float)(i * 75));
                if (i == 2) {
                    f6 += 250.0f;
                    f7 += 250.0f;
                }
                Vector3f vector3f = new Vector3f(f * (float)Math.cos(f4), 0.0f, f * (float)Math.sin(f4));
                Vector3f vector3f2 = new Vector3f(f * (float)Math.cos(f5), 0.0f, f * (float)Math.sin(f5));
                Vector3f vector3f3 = new Vector3f(vector3f.x, f6, vector3f.z);
                Vector3f vector3f4 = new Vector3f(vector3f2.x, f7, vector3f2.z);
                meshBuilder.quad(vector3f, vector3f3, vector3f4, vector3f2);
            }
        }
        Mesh mesh = meshBuilder.build();
        DefaultMaterial defaultMaterial = new DefaultMaterial(this.simpleShader);
        defaultMaterial.setAmbient(new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
        this.landscapeRoot.addChild(new DefaultMeshNode(mesh, defaultMaterial));
    }

    public void addTexts(GL gL, Font font) {
        if (this.textInitialized) {
            return;
        }
        this.textInitialized = true;
        String[] stringArray = new String[]{"KING", "PANDA DESIGN", "TAZADUM", "WHAZZAH", "GRUNKAN", "2013", "FAIRLIGHT"};
        ArrayList<TexturedMesh> arrayList = new ArrayList<TexturedMesh>();
        for (String string : stringArray) {
            arrayList.add(this.fontSystem.createMesh(font, string));
        }
        ArrayList arrayList2 = new ArrayList();
        arrayList2.add(new Vector4f(1.0f, 1.0f, 1.0f, 1.0f));
        arrayList2.add(new Vector4f(0.9f, 0.2f, 0.2f, 1.0f));
        arrayList2.add(new Vector4f(0.8f, 0.8f, 0.2f, 1.0f));
        arrayList2.add(new Vector4f(0.8f, 0.6f, 0.2f, 1.0f));
        Matrix4f matrix4f = new Matrix4f();
        Matrix4f matrix4f2 = new Matrix4f();
        float f = 0.2f;
        for (Building building : this.buildings) {
            Object object;
            Object object2;
            Object object3;
            Box box = building.getWindow().getBoundingBox();
            if (box.getHeight() < 30.0f) continue;
            Vector4f vector4f = new Vector4f((Vector4f)arrayList2.get(this.random.nextInt(arrayList2.size())));
            vector4f.x -= this.random.nextFloat() * 0.2f;
            vector4f.y -= this.random.nextFloat() * 0.2f;
            vector4f.z -= this.random.nextFloat() * 0.2f;
            TexturedMesh texturedMesh = (TexturedMesh)arrayList.get(this.random.nextInt(arrayList.size()));
            DistanceFieldMaterial distanceFieldMaterial = new DistanceFieldMaterial(this.distanceFieldShader, vector4f, Vector4f.ZERO);
            distanceFieldMaterial.setThreshold(this.random.nextFloat() * 0.3f + 0.3f);
            distanceFieldMaterial.setTextureAsset(font.getTexture());
            DefaultMeshNode defaultMeshNode = new DefaultMeshNode(texturedMesh, distanceFieldMaterial);
            this.materials.add(distanceFieldMaterial);
            Node<DefaultMeshNode> node = new Node<DefaultMeshNode>(defaultMeshNode);
            Quaternion quaternion = new Quaternion();
            if (building.getType() == BuildingType.Simple) {
                object3 = texturedMesh.getBoundingBox();
                if (((Box)object3).getHeight() / ((Box)object3).getWidth() > 0.4f) continue;
                matrix4f2.set(Matrix4f.IDENTITY);
                float f2 = 1.0f;
                object2 = new Vector3f(box.getFrom());
                ((Vector3f)object2).y += box.getHeight() + 1.0f;
                switch (this.random.nextInt(4)) {
                    case 0: {
                        f2 = 0.8f * (box.getWidth() / ((Box)object3).getWidth());
                        ((Vector3f)object2).x -= (f2 * ((Box)object3).getWidth() - box.getWidth()) / 2.0f;
                        ((Vector3f)object2).z -= 0.5f;
                        break;
                    }
                    case 1: {
                        f2 = 0.8f * (box.getWidth() / ((Box)object3).getWidth());
                        ((Vector3f)object2).x += (f2 * ((Box)object3).getWidth() - box.getWidth()) / 2.0f + box.getWidth();
                        ((Vector3f)object2).z += 0.5f + box.getDepth();
                        quaternion.fromAngleAxis(3.14f, Vector3f.UNIT_Y);
                        break;
                    }
                    case 2: {
                        f2 = 0.8f * (box.getDepth() / ((Box)object3).getWidth());
                        ((Vector3f)object2).x = (float)((double)((Vector3f)object2).x - 0.5);
                        ((Vector3f)object2).z += box.getDepth() + (f2 * ((Box)object3).getWidth() - box.getDepth()) / 2.0f;
                        quaternion.fromAngleAxis(1.57f, Vector3f.UNIT_Y);
                        break;
                    }
                    case 3: {
                        f2 = 0.8f * (box.getDepth() / ((Box)object3).getWidth());
                        ((Vector3f)object2).x = (float)((double)((Vector3f)object2).x + ((double)box.getWidth() + 0.5));
                        ((Vector3f)object2).z += -(f2 * ((Box)object3).getWidth() - box.getDepth()) / 2.0f;
                        quaternion.fromAngleAxis(-1.57f, Vector3f.UNIT_Y);
                    }
                }
                matrix4f2.setScale(f2, f2, f2);
                matrix4f.setTranslation((Vector3f)object2);
            } else {
                matrix4f2.set(Matrix4f.IDENTITY);
                float f3 = this.random.nextFloat() * 0.02f + 0.02f;
                matrix4f2.setScale(f3, f3, f3);
                object = new Vector3f(box.getFrom());
                ((Vector3f)object).y += this.random.nextFloat() * 14.0f + 2.0f;
                object2 = new Quaternion();
                quaternion.fromAngleAxis(1.57075f, Vector3f.UNIT_Z);
                switch (this.random.nextInt(4)) {
                    case 0: {
                        ((Vector3f)object).x -= f;
                        ((Vector3f)object).z += this.random.nextFloat() * box.getDepth();
                        break;
                    }
                    case 1: {
                        ((Vector3f)object).x += box.getWidth() + f;
                        ((Vector3f)object).z += this.random.nextFloat() * box.getDepth();
                        ((Quaternion)object2).fromAngleAxis(3.1415f, Vector3f.UNIT_X);
                        quaternion.multLocal((Quaternion)object2);
                        break;
                    }
                    case 2: {
                        ((Vector3f)object).x += this.random.nextFloat() * box.getWidth();
                        ((Vector3f)object).y += texturedMesh.getBoundingBox().getHeight() * f3;
                        ((Vector3f)object).z -= f;
                        ((Quaternion)object2).fromAngleAxis(1.57075f, Vector3f.UNIT_X);
                        quaternion.multLocal((Quaternion)object2);
                        ((Quaternion)object2).fromAngleAxis(3.1415f, Vector3f.UNIT_Z);
                        quaternion.multLocal((Quaternion)object2);
                        break;
                    }
                    case 3: {
                        ((Vector3f)object).x += this.random.nextFloat() * box.getWidth();
                        ((Vector3f)object).y += texturedMesh.getBoundingBox().getHeight() * f3;
                        ((Vector3f)object).z += box.getDepth() + f;
                        ((Quaternion)object2).fromAngleAxis(-1.57075f, Vector3f.UNIT_X);
                        quaternion.multLocal((Quaternion)object2);
                        ((Quaternion)object2).fromAngleAxis(3.1415f, Vector3f.UNIT_Z);
                        quaternion.multLocal((Quaternion)object2);
                    }
                }
                matrix4f.setTranslation((Vector3f)object);
            }
            object3 = node.getTransform();
            ((Matrix4f)object3).set(new Matrix4f());
            ((Matrix4f)object3).multLocal(matrix4f);
            ((Matrix4f)object3).multLocal(quaternion);
            ((Matrix4f)object3).multLocal(matrix4f2);
            this.textRoot.addChild((MeshNode)((Object)node));
            object = new DistanceFieldMaterial(this.distanceFieldShader, new Vector4f(1.0f, 1.0f, 1.0f, 0.5f), Vector4f.ZERO);
            ((DistanceFieldMaterial)object).setThreshold(0.5f);
            ((DistanceFieldMaterial)object).setTextureAsset(font.getTexture());
            object2 = new DistanceFieldMaterial(this.distanceFieldShader, new Vector4f(0.25f, 0.0f, 0.0f, 0.5f), Vector4f.ZERO);
            ((DistanceFieldMaterial)object2).setThreshold(0.5f);
            ((DistanceFieldMaterial)object2).setTextureAsset(font.getTexture());
            this.todayNode = new Node<DefaultMeshNode>(new DefaultMeshNode(this.fontSystem.createMesh(font, "Today"), (Material)object));
            this.someoneNode = new Node<DefaultMeshNode>(new DefaultMeshNode(this.fontSystem.createMesh(font, "Someone"), (Material)object));
            this.enoughNode = new Node<DefaultMeshNode>(new DefaultMeshNode(this.fontSystem.createMesh(font, "ENOUGH"), (Material)object));
            this.carryNode = new Node<DefaultMeshNode>(new DefaultMeshNode(this.fontSystem.createMesh(font, "carry"), (Material)object));
            this.bulletNode = new Node<DefaultMeshNode>(new DefaultMeshNode(this.fontSystem.createMesh(font, "Bullet"), (Material)object));
            this.bloodNode = new Node<DefaultMeshNode>(new DefaultMeshNode(this.fontSystem.createMesh(font, "BLOOD"), (Material)object2));
        }
    }

    public Node<MeshNode> getTodayNode() {
        return this.todayNode;
    }

    public Node<MeshNode> getSomeoneNode() {
        return this.someoneNode;
    }

    public Node<MeshNode> getEnoughNode() {
        return this.enoughNode;
    }

    public Node<MeshNode> getCarryNode() {
        return this.carryNode;
    }

    public Node<MeshNode> getBulletNode() {
        return this.bulletNode;
    }

    public Node<MeshNode> getBloodNode() {
        return this.bloodNode;
    }
}

