/*
 * Decompiled with CFR 0.152.
 */
package tazmania.scenes.building;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import tazadum.engine.math.Rectangle;
import tazadum.engine.math.Vector2f;
import tazadum.engine.math.Vector3f;
import tazmania.scenes.building.Building;
import tazmania.scenes.building.BuildingBuilder;
import tazmania.scenes.building.BuildingType;
import tazmania.scenes.building.RandomRect;

public class BuildingGenerator {
    private static final float UNIT = 0.005f;
    private final Random random;
    private final RandomRect rect;
    private final Vector2f unit;

    public BuildingGenerator(Random random) {
        this.random = random;
        this.unit = new Vector2f(0.005f, 0.005f);
        this.rect = new RandomRect(new Vector2f(1.0f, 1.0f), random.nextLong());
    }

    public Building generate(Vector3f vector3f, Vector2f vector2f, float f, BuildingType buildingType) {
        boolean bl = f >= 40.0f;
        switch (buildingType) {
            case Simple: {
                return this.generateSimple(vector3f, vector2f, f, bl);
            }
            case Block: {
                return this.generateBlock(vector3f, vector2f, f, bl);
            }
            case BlockStripe: {
                return this.generateBlockStripe(vector3f, vector2f, f, bl);
            }
            case Pyramid: {
                return this.generatePyramid(vector3f, vector2f, f, bl);
            }
        }
        throw new RuntimeException("Unknown building type: " + (Object)((Object)buildingType));
    }

    private Building generatePyramid(Vector3f vector3f, Vector2f vector2f, float f, boolean bl) {
        BuildingBuilder buildingBuilder = new BuildingBuilder(this.unit);
        Rectangle rectangle = new Rectangle(vector3f.x, vector3f.z, vector2f.x, vector2f.y);
        int n = 2 + this.random.nextInt(3);
        Rectangle rectangle2 = this.rect.bounds(rectangle).size(0.8f, 0.85f).aspect(0.0f, 0.0f).centered().get();
        float f2 = this.random.nextFloat() * 0.2f + 0.4f;
        this.hatBoxStripes(buildingBuilder, rectangle2, 0.0f, f2 * f, 2.0f, n, true);
        Rectangle rectangle3 = rectangle2;
        for (int i = 0; i < 5; ++i) {
            float f3 = f2 * f;
            Rectangle rectangle4 = new Rectangle(0.0f, 0.0f, rectangle3.width * 0.9f, rectangle3.height * 0.9f);
            rectangle4.x = rectangle3.x + (rectangle3.width - rectangle4.width) / 2.0f;
            rectangle4.y = rectangle3.y + (rectangle3.height - rectangle4.height) / 2.0f;
            if (rectangle4.width < (float)n || rectangle4.height < (float)n) continue;
            rectangle3 = rectangle4;
            float f4 = this.random.nextFloat() * Math.min(0.3f, 1.0f - f2) + 0.1f;
            if (f2 + f4 > 1.0f) {
                f4 = 1.0f - f2;
            }
            this.hatBoxStripes(buildingBuilder, rectangle3, f3, f4 * f, 2.0f, n, false);
            if (f2 >= 1.0f) break;
            f2 += f4;
            f2 = Math.min(1.0f, f2);
        }
        this.addRoof(buildingBuilder, rectangle3, f2 * f, bl);
        return buildingBuilder.build(BuildingType.Pyramid);
    }

    private Building generateBlockStripe(Vector3f vector3f, Vector2f vector2f, float f, boolean bl) {
        int n;
        BuildingBuilder buildingBuilder = new BuildingBuilder(this.unit);
        Rectangle rectangle = new Rectangle(vector3f.x, vector3f.z, vector2f.x, vector2f.y);
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        Rectangle rectangle2 = this.rect.bounds(rectangle).size(0.8f, 0.85f).aspect(0.2f, 0.4f).center().get();
        arrayList.add(rectangle2);
        int n2 = 2 + this.random.nextInt(3);
        this.hatBoxStripes(buildingBuilder, rectangle2, 0.0f, f, 2.0f, n2, true);
        int n3 = this.random.nextInt(3) + 2;
        float f2 = 1.0f;
        for (n = 0; n < n3 && f2 > 0.1f; ++n) {
            f2 *= this.random.nextFloat() * 0.2f + 0.4f;
            Rectangle rectangle3 = this.rect.bounds(rectangle).size(0.4f, 0.5f).aspect(0.2f, 0.4f).center().get();
            if (rectangle2.contains(rectangle3) || this.isParallel(arrayList, rectangle3)) {
                --n;
                continue;
            }
            if (rectangle3.width < (float)n2 || rectangle3.height < (float)n2) continue;
            arrayList.add(rectangle3);
            this.hatBox(buildingBuilder, rectangle3, f2 * f, 1.0f);
        }
        n = this.random.nextInt(3) + 1;
        float f3 = f;
        this.addRoofBoxes(buildingBuilder, rectangle2, n, f3, bl);
        return buildingBuilder.build(BuildingType.BlockStripe);
    }

    private Building generateBlock(Vector3f vector3f, Vector2f vector2f, float f, boolean bl) {
        int n;
        BuildingBuilder buildingBuilder = new BuildingBuilder(this.unit);
        Rectangle rectangle = new Rectangle(vector3f.x, vector3f.z, vector2f.x, vector2f.y);
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        Rectangle rectangle2 = this.rect.bounds(rectangle).size(0.7f, 0.85f).aspect(0.2f, 0.4f).center().get();
        arrayList.add(rectangle2);
        this.hatBox(buildingBuilder, rectangle2, f, 3.0f);
        int n2 = this.random.nextInt(3) + 2;
        float f2 = 1.0f;
        for (n = 0; n < n2 && f2 > 0.1f; ++n) {
            f2 *= this.random.nextFloat() * 0.2f + 0.6f;
            Rectangle rectangle3 = this.rect.bounds(rectangle).size(0.4f, 0.5f).aspect(0.2f, 0.4f).center().get();
            if (rectangle2.contains(rectangle3) || this.isParallel(arrayList, rectangle3)) {
                --n;
                continue;
            }
            arrayList.add(rectangle3);
            this.hatBox(buildingBuilder, rectangle3, f2 * f, 2.0f);
        }
        n = this.random.nextInt(3) + 1;
        float f3 = f + 3.0f;
        this.addRoofBoxes(buildingBuilder, rectangle2, n, f3, bl);
        return buildingBuilder.build(BuildingType.Block);
    }

    private Building generateSimple(Vector3f vector3f, Vector2f vector2f, float f, boolean bl) {
        BuildingBuilder buildingBuilder = new BuildingBuilder(this.unit);
        Rectangle rectangle = new Rectangle(vector3f.x, vector3f.z, vector2f.x, vector2f.y);
        Rectangle rectangle2 = this.rect.bounds(rectangle).size(0.7f, 0.85f).center().get();
        float f2 = 1.0f;
        buildingBuilder.shape(rectangle2).offset(0.0f).height(f2).solid();
        buildingBuilder.shape(rectangle2).offset(f2).height(f).textured();
        buildingBuilder.shape(rectangle2).offset(f2 + f).height(3.0f).solid().top();
        int n = (int)((float)this.random.nextInt(3) + 50.0f / f);
        float f3 = f2 + f + 3.0f;
        this.addRoofBoxes(buildingBuilder, rectangle2, n, f3, bl);
        return buildingBuilder.build(BuildingType.Simple);
    }

    private void hatBoxStripes(BuildingBuilder buildingBuilder, Rectangle rectangle, float f, float f2, float f3, float f4, boolean bl) {
        int n;
        float f5 = f4 + 1.0f;
        float f6 = rectangle.width % f5 + 1.0f;
        float f7 = rectangle.height % f5 + 1.0f;
        int n2 = (int)(rectangle.width / f5);
        int n3 = (int)(rectangle.height / f5);
        if (n2 <= 0 || n3 <= 0) {
            return;
        }
        if (n2 == 1 || n3 == 1) {
            this.hatBoxStripes(buildingBuilder, rectangle, f, f2, f3, f4 - 1.0f, bl);
            return;
        }
        f2 -= f3;
        if (bl) {
            buildingBuilder.shape(rectangle).offset(f).height(1.0f).solid();
            f += 1.0f;
            f2 -= 1.0f;
        }
        int n4 = 2 * n2 + 2;
        Vector2f[] vector2fArray = new Vector2f[n4];
        for (n = 0; n < 2; ++n) {
            float f8 = rectangle.y + (float)n * rectangle.height;
            float f9 = rectangle.x;
            int n5 = 0;
            vector2fArray[n5++] = new Vector2f(f9, f8);
            vector2fArray[n5++] = new Vector2f(f9 += f6 / 2.0f, f8);
            for (int i = 0; i < n2; ++i) {
                vector2fArray[n5++] = new Vector2f(f9 += f4, f8);
                if (i == n2 - 1) break;
                vector2fArray[n5++] = new Vector2f(f9 += 1.0f, f8);
            }
            vector2fArray[n5++] = new Vector2f(f9 += f6 / 2.0f, f8);
            buildingBuilder.shape(vector2fArray).offset(f).height(f2).interleaved(true, n == 0);
        }
        n = 2 * n3 + 2;
        Vector2f[] vector2fArray2 = new Vector2f[n];
        for (int i = 0; i < 2; ++i) {
            float f10 = rectangle.x + (float)i * rectangle.width;
            float f11 = rectangle.y;
            int n6 = 0;
            vector2fArray2[n6++] = new Vector2f(f10, f11);
            vector2fArray2[n6++] = new Vector2f(f10, f11 += f7 / 2.0f);
            for (int j = 0; j < n3; ++j) {
                vector2fArray2[n6++] = new Vector2f(f10, f11 += f4);
                if (j == n3 - 1) break;
                vector2fArray2[n6++] = new Vector2f(f10, f11 += 1.0f);
            }
            vector2fArray2[n6++] = new Vector2f(f10, f11 += f7 / 2.0f);
            buildingBuilder.shape(vector2fArray2).offset(f).height(f2).interleaved(true, i != 0);
        }
        buildingBuilder.shape(rectangle).offset(f + f2).height(f3).solid().top();
    }

    private void hatBox(BuildingBuilder buildingBuilder, Rectangle rectangle, float f, float f2) {
        buildingBuilder.shape(rectangle).offset(0.0f).height(f).textured();
        buildingBuilder.shape(rectangle).offset(f).height(f2).solid().top();
    }

    private void addRoof(BuildingBuilder buildingBuilder, Rectangle rectangle, float f, boolean bl) {
        float f2 = 3.0f * this.random.nextFloat() + 3.0f * this.random.nextFloat() + 3.0f * this.random.nextFloat() + 3.0f * this.random.nextFloat();
        buildingBuilder.shape(rectangle).offset(f).height(f2).extrudeCenter().solid();
        if (bl && this.random.nextBoolean()) {
            Vector2f vector2f = rectangle.center();
            Rectangle rectangle2 = new Rectangle(vector2f.x - 0.05f, vector2f.y - 0.05f, 0.1f, 0.1f);
            float f3 = this.random.nextFloat() * 5.0f + 5.0f;
            buildingBuilder.shape(rectangle2).offset(f + f2).height(f3).solid();
        }
    }

    private void addRoofBoxes(BuildingBuilder buildingBuilder, Rectangle rectangle, int n, float f, boolean bl) {
        Object object;
        Object object2 = null;
        float f2 = 0.0f;
        for (int i = 0; i < n; ++i) {
            object = this.rect.bounds(rectangle).size(0.1f, 0.25f).get();
            float f3 = Math.min(((Rectangle)object).width, ((Rectangle)object).height);
            if (f3 > f2) {
                f2 = f3;
                object2 = object;
            }
            buildingBuilder.shape((Rectangle)object).offset(f).height(f3).solid().top();
        }
        if (bl && this.random.nextInt(5) == 0) {
            Rectangle rectangle2 = object2 != null ? object2 : rectangle;
            object = rectangle2.center();
            Rectangle rectangle3 = new Rectangle(((Vector2f)object).x - 0.05f, ((Vector2f)object).y - 0.05f, 0.1f, 0.1f);
            float f4 = this.random.nextFloat() * 5.0f + 5.0f;
            buildingBuilder.shape(rectangle3).offset(f + f2).height(f4).solid();
        }
    }

    private boolean isParallel(List<Rectangle> list, Rectangle rectangle) {
        for (Rectangle rectangle2 : list) {
            if (rectangle.x == rectangle2.x || rectangle.x == rectangle2.x + rectangle2.width || rectangle.x + rectangle.width == rectangle2.x || rectangle.x + rectangle.width == rectangle2.x + rectangle2.width) {
                return true;
            }
            if (rectangle.y != rectangle2.y && rectangle.y != rectangle2.y + rectangle2.height && rectangle.y + rectangle.height != rectangle2.y && rectangle.y + rectangle.height != rectangle2.y + rectangle2.height) continue;
            return true;
        }
        return false;
    }
}

