/*
 * Decompiled with CFR 0.152.
 */
package tazmania.scenes.building;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import tazadum.engine.math.Box;
import tazadum.engine.math.Rectangle;
import tazadum.engine.math.Vector2f;
import tazadum.engine.math.Vector3f;
import tazadum.engine.memory.Buffers;
import tazadum.engine.rendering.mesh.Mesh;
import tazadum.engine.rendering.mesh.MeshImpl;

public class Builder {
    private final List<Vector3f> vertices = new ArrayList<Vector3f>();
    private final List<Integer> indices = new ArrayList<Integer>();
    private final List<Vector2f> coords = new ArrayList<Vector2f>();
    private final Box boundingBox = new Box();

    public void quad(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, Rectangle rectangle, boolean bl) {
        Vector2f vector2f = new Vector2f(rectangle.x, rectangle.y);
        Vector2f vector2f2 = new Vector2f(rectangle.x, rectangle.y + rectangle.height);
        Vector2f vector2f3 = new Vector2f(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        Vector2f vector2f4 = new Vector2f(rectangle.x + rectangle.width, rectangle.y);
        if (bl) {
            this.quad(vector3f, vector3f4, vector3f3, vector3f2, vector2f, vector2f4, vector2f3, vector2f2);
        } else {
            this.quad(vector3f, vector3f2, vector3f3, vector3f4, vector2f, vector2f2, vector2f3, vector2f4);
        }
    }

    public void quad(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, Vector2f vector2f, Vector2f vector2f2, Vector2f vector2f3, Vector2f vector2f4) {
        this.triangle(vector3f, vector3f2, vector3f4, vector2f, vector2f2, vector2f4);
        this.triangle(vector3f2, vector3f3, vector3f4, vector2f2, vector2f3, vector2f4);
    }

    public void quad(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, boolean bl) {
        if (bl) {
            this.triangle(vector3f, vector3f4, vector3f2);
            this.triangle(vector3f2, vector3f4, vector3f3);
        } else {
            this.triangle(vector3f, vector3f2, vector3f4);
            this.triangle(vector3f2, vector3f3, vector3f4);
        }
    }

    public void triangle(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector2f vector2f, Vector2f vector2f2, Vector2f vector2f3) {
        this.indices.add(this.vertex(vector3f, vector2f));
        this.indices.add(this.vertex(vector3f2, vector2f2));
        this.indices.add(this.vertex(vector3f3, vector2f3));
    }

    public void triangle(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        this.indices.add(this.vertex(vector3f));
        this.indices.add(this.vertex(vector3f2));
        this.indices.add(this.vertex(vector3f3));
    }

    public Mesh build() {
        FloatBuffer floatBuffer = Buffers.allocateFloat(3 * this.vertices.size());
        for (Vector3f iterator2 : this.vertices) {
            floatBuffer.put(iterator2.x);
            floatBuffer.put(iterator2.y);
            floatBuffer.put(iterator2.z);
        }
        floatBuffer.rewind();
        Object object = null;
        if (!this.coords.isEmpty()) {
            object = Buffers.allocateFloat(2 * this.coords.size());
            for (Vector2f vector2f : this.coords) {
                ((FloatBuffer)object).put(vector2f.x);
                ((FloatBuffer)object).put(vector2f.y);
            }
            ((FloatBuffer)object).rewind();
        }
        IntBuffer intBuffer = Buffers.allocateInt(this.indices.size());
        for (Integer n : this.indices) {
            intBuffer.put(n);
        }
        intBuffer.rewind();
        return new MeshImpl(floatBuffer, null, (FloatBuffer)object, intBuffer, this.boundingBox);
    }

    private int vertex(Vector3f vector3f, Vector2f vector2f) {
        this.boundingBox.extend(vector3f);
        this.vertices.add(vector3f);
        this.coords.add(vector2f);
        return this.vertices.size() - 1;
    }

    private int vertex(Vector3f vector3f) {
        this.boundingBox.extend(vector3f);
        this.vertices.add(vector3f);
        return this.vertices.size() - 1;
    }
}

