/*
 * Decompiled with CFR 0.152.
 */
package tazmania.scenes.auto;

import javax.inject.Inject;
import javax.media.opengl.GL2;
import tazadum.engine.math.Interval;
import tazadum.engine.math.Vector3f;
import tazadum.engine.parameter.Parameter;
import tazadum.engine.parameter.ParameterFactory;
import tazadum.engine.rendering.scenegraph.MeshNode;
import tazadum.engine.rendering.scenegraph.Node;
import tazmania.scenes.NightSkyScene;
import tazmania.scenes.auto.AutomationScene;

public class FadeOutAuto
extends AutomationScene {
    private static final float LENGTH = 1.5f;
    private final Parameter<Vector3f> postParameter;
    private final NightSkyScene nightSkyScene;
    private Interval interval;

    @Inject
    public FadeOutAuto(ParameterFactory parameterFactory, NightSkyScene nightSkyScene) {
        this.postParameter = parameterFactory.tween3f(this, "post-fx");
        this.nightSkyScene = nightSkyScene;
    }

    @Override
    public void onStart(Node<MeshNode> node, Interval interval) {
        this.interval = interval;
        this.nightSkyScene.setPostFx(this.postParameter.get(0.0f));
    }

    @Override
    public void onUpdate(GL2 gL2, float f, float f2, float f3, float f4) {
        if (this.interval == null) {
            return;
        }
        if (f + 1.5f >= this.interval.to()) {
            float f5 = this.interval.to() - 1.5f;
            this.nightSkyScene.setPostFx(this.postParameter.get(f - f5));
        } else {
            this.nightSkyScene.setPostFx(this.postParameter.get(0.0f));
        }
    }

    @Override
    public void onStop(Node<MeshNode> node) {
        this.nightSkyScene.setPostFx(this.postParameter.get(1.5f));
    }
}

