/*
 * Decompiled with CFR 0.152.
 */
package tazmania.scenes;

import javax.inject.Inject;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import tazadum.engine.asset.Asset;
import tazadum.engine.asset.AssetManager;
import tazadum.engine.math.Interval;
import tazadum.engine.math.Matrix4f;
import tazadum.engine.math.Quaternion;
import tazadum.engine.math.Vector2f;
import tazadum.engine.math.Vector3f;
import tazadum.engine.math.Vector4f;
import tazadum.engine.parameter.Parameter;
import tazadum.engine.parameter.ParameterFactory;
import tazadum.engine.rendering.RenderEngine;
import tazadum.engine.rendering.font.Font;
import tazadum.engine.rendering.font.FontSystem;
import tazadum.engine.rendering.material.DistanceFieldMaterial;
import tazadum.engine.rendering.mesh.TexturedMesh;
import tazadum.engine.rendering.scenegraph.DefaultMeshNode;
import tazadum.engine.rendering.scenegraph.MeshNode;
import tazadum.engine.rendering.scenegraph.Node;
import tazadum.engine.rendering.scenegraph.Scene;
import tazadum.engine.rendering.shader.DistanceFieldShader;
import tazadum.engine.ui.CameraControl;
import tazmania.scenes.building.BuildingMaterial;
import tazmania.scenes.building.CityBuilder;

public class TechnoScene
implements Scene {
    private final CityBuilder cityBuilder;
    private final CameraControl cameraControl;
    private final Matrix4f scaleMatrix;
    private final Quaternion quaternion = new Quaternion();
    private final Quaternion quaternion2 = new Quaternion();
    private final Asset<Font> font;
    private final FontSystem fontSystem;
    private final Parameter<Vector2f> windowParameter;
    private final DistanceFieldMaterial material;
    private Node<MeshNode> nodeA;
    private Node<MeshNode> nodeB;
    private Node<MeshNode> nodeC;
    private Node<MeshNode> nodeD;
    private Node<MeshNode> nodeE;
    private final Parameter<Vector4f> paramA;
    private final Parameter<Vector4f> paramB;
    private final Parameter<Vector4f> paramC;
    private final Parameter<Vector4f> paramD;
    private final Parameter<Vector4f> paramE;

    @Inject
    public TechnoScene(RenderEngine renderEngine, ParameterFactory parameterFactory, AssetManager assetManager, CityBuilder cityBuilder, CameraControl cameraControl, FontSystem fontSystem, DistanceFieldShader distanceFieldShader) {
        this.cityBuilder = cityBuilder;
        this.cameraControl = cameraControl;
        this.fontSystem = fontSystem;
        this.font = assetManager.loadFont("resources/font/font.fnt", "resources/font/font.png");
        this.scaleMatrix = new Matrix4f();
        this.scaleMatrix.setScale(0.25f, 0.25f, 0.25f);
        this.windowParameter = parameterFactory.tween2f(this, "techno-window-control");
        cameraControl.registerParameters(this, "techno");
        this.material = new DistanceFieldMaterial(distanceFieldShader);
        this.material.setTextureAsset(assetManager.loadTexture("resources/font/font.png"));
        this.material.setBackground(new Vector4f(0.0f, 0.0f, 0.0f, 0.0f));
        this.material.setForeground(new Vector4f(1.0f, 1.0f, 1.0f, 0.5f));
        this.material.setThreshold(0.5f);
        this.paramA = parameterFactory.tween4f(this, "techno-syn");
        this.paramB = parameterFactory.tween4f(this, "techno-kat");
        this.paramC = parameterFactory.tween4f(this, "techno-med");
        this.paramD = parameterFactory.tween4f(this, "techno-mu");
        this.paramE = parameterFactory.tween4f(this, "techno-sik");
    }

    @Override
    public void onInit(GL gL) {
        this.nodeA = this.nodeFrom(this.fontSystem.createMesh(this.font, "SYN"), this.material);
        this.nodeB = this.nodeFrom(this.fontSystem.createMesh(this.font, "KAT"), this.material);
        this.nodeC = this.nodeFrom(this.fontSystem.createMesh(this.font, "MED"), this.material);
        this.nodeD = this.nodeFrom(this.fontSystem.createMesh(this.font, "MU"), this.material);
        this.nodeE = this.nodeFrom(this.fontSystem.createMesh(this.font, "SIK"), this.material);
    }

    @Override
    public void onDeinit(GL gL) {
    }

    @Override
    public void onPreCalc() {
    }

    private Node<MeshNode> nodeFrom(TexturedMesh texturedMesh, DistanceFieldMaterial distanceFieldMaterial) {
        return new Node<MeshNode>(new DefaultMeshNode(texturedMesh, distanceFieldMaterial));
    }

    @Override
    public void onStart(Node<MeshNode> node, Interval interval) {
        node.addChild((MeshNode)((Object)this.cityBuilder.getCityRoot()));
        node.addChild((MeshNode)((Object)this.cityBuilder.getLandscapeRoot()));
        node.addChild((MeshNode)((Object)this.cityBuilder.getRoadRoot()));
        node.addChild((MeshNode)((Object)this.cityBuilder.getTextRoot()));
        node.addChild((MeshNode)((Object)this.nodeA));
        node.addChild((MeshNode)((Object)this.nodeB));
        node.addChild((MeshNode)((Object)this.nodeC));
        node.addChild((MeshNode)((Object)this.nodeD));
        node.addChild((MeshNode)((Object)this.nodeE));
        this.cameraControl.registerParameters(this, "techno", interval.from());
    }

    @Override
    public void onStop(Node<MeshNode> node) {
        node.removeChild(this.cityBuilder.getCityRoot());
        node.removeChild(this.cityBuilder.getLandscapeRoot());
        node.removeChild(this.cityBuilder.getRoadRoot());
        node.removeChild(this.cityBuilder.getTextRoot());
        node.removeChild(this.nodeA);
        node.removeChild(this.nodeB);
        node.removeChild(this.nodeC);
        node.removeChild(this.nodeD);
        node.removeChild(this.nodeE);
    }

    @Override
    public void onUpdate(GL2 gL2, float f, float f2, float f3, float f4) {
        Vector2f vector2f = this.windowParameter.get(f2);
        BuildingMaterial buildingMaterial = this.cityBuilder.getBuildingMaterial();
        buildingMaterial.setAlpha(vector2f.x);
        buildingMaterial.setHeight(vector2f.y);
        this.cameraControl.positionCamera(f2);
        this.cityBuilder.update(f2);
        this.position(this.nodeA, this.paramA.get(f2), 0.1f, 0.0f);
        this.position(this.nodeB, this.paramB.get(f2), 0.1f, 0.0f);
        this.position(this.nodeC, this.paramC.get(f2), 0.1f, 0.0f);
        this.position(this.nodeD, this.paramD.get(f2), 0.1f, 0.0f);
        this.position(this.nodeE, this.paramE.get(f2), 1.0f, 0.0f);
    }

    private void position(Node<MeshNode> node, Vector4f vector4f, float f, float f2) {
        this.quaternion.fromAngleNormalAxis(vector4f.w, Vector3f.UNIT_Y);
        this.quaternion2.fromAngleNormalAxis(f2, Vector3f.UNIT_X);
        this.scaleMatrix.set(Matrix4f.IDENTITY);
        this.scaleMatrix.setScale(f, f, f);
        node.getTransform().set(Matrix4f.IDENTITY);
        node.getTransform().setTranslation(vector4f.x, vector4f.y, vector4f.z);
        node.getTransform().multLocal(this.quaternion);
        node.getTransform().multLocal(this.quaternion2);
        node.getTransform().multLocal(this.scaleMatrix);
    }
}

