/*
 * Decompiled with CFR 0.152.
 */
package tazmania.scenes;

import com.jogamp.opengl.util.texture.Texture;
import javax.inject.Inject;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import tazadum.engine.asset.Asset;
import tazadum.engine.asset.AssetManager;
import tazadum.engine.math.Interval;
import tazadum.engine.math.Matrix4f;
import tazadum.engine.math.Vector2f;
import tazadum.engine.math.Vector3f;
import tazadum.engine.math.Vector4f;
import tazadum.engine.parameter.Parameter;
import tazadum.engine.parameter.ParameterFactory;
import tazadum.engine.rendering.RenderEngine;
import tazadum.engine.rendering.material.DefaultMaterial;
import tazadum.engine.rendering.material.DistanceFieldMaterial;
import tazadum.engine.rendering.mesh.Mesh;
import tazadum.engine.rendering.mesh.MeshBuilder;
import tazadum.engine.rendering.scenegraph.DefaultMeshNode;
import tazadum.engine.rendering.scenegraph.MeshNode;
import tazadum.engine.rendering.scenegraph.Node;
import tazadum.engine.rendering.scenegraph.Scene;
import tazadum.engine.rendering.shader.DistanceFieldShader;
import tazadum.engine.rendering.shader.SimpleShader;
import tazadum.engine.ui.CameraControl;
import tazmania.gfx.Band;
import tazmania.scenes.building.CityBuilder;

public class SuicideScene
implements Scene {
    private final Asset<Texture> decal;
    private final DistanceFieldMaterial material;
    private final Parameter<Vector3f> pathParameter;
    private final Parameter<Vector3f> upParameter;
    private final Parameter<Float> widthParameter;
    private final SimpleShader shader;
    private final CityBuilder cityBuilder;
    private Band band;
    private final Vector3f origo = new Vector3f(-14.861f, 89.971f, 4.123f);
    private DefaultMaterial blood;
    private Node<MeshNode> bloodRoot;
    private final CameraControl cameraControl;
    private final Parameter<Vector3f> textParameter;
    private final Matrix4f scaleMatrix;

    @Inject
    public SuicideScene(RenderEngine renderEngine, ParameterFactory parameterFactory, AssetManager assetManager, DistanceFieldShader distanceFieldShader, SimpleShader simpleShader, CityBuilder cityBuilder, CameraControl cameraControl) {
        this.shader = simpleShader;
        this.cityBuilder = cityBuilder;
        this.cameraControl = cameraControl;
        this.decal = assetManager.loadTexture("resources/textures/suicide.png");
        cameraControl.registerParameters(this, "blood");
        this.material = new DistanceFieldMaterial(distanceFieldShader, new Vector4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector4f(1.0f, 1.0f, 1.0f, 1.0f));
        this.material.setEmittance(0.75f);
        this.material.setTextureAsset(this.decal);
        this.pathParameter = parameterFactory.spline(this, "blood-path");
        this.upParameter = parameterFactory.tween3f(this, "blood-up");
        this.widthParameter = parameterFactory.tween1f(this, "blood-width");
        this.textParameter = parameterFactory.tween3f(this, "blood-text");
        this.scaleMatrix = new Matrix4f();
        this.scaleMatrix.setScale(0.25f, 0.25f, 0.25f);
    }

    @Override
    public void onInit(GL gL) {
        this.blood = new DefaultMaterial(this.shader);
        this.blood.setTwoSided(true);
        this.blood.setEmittance(1.0f);
        this.blood.setAmbient(new Vector4f(1.0f, 0.0f, 0.0f, 1.0f));
        Node<DefaultMeshNode> node = new Node<DefaultMeshNode>(new DefaultMeshNode(this.band, this.blood));
        Vector3f vector3f = new Vector3f(-1.0f, -1.0f, 0.0f);
        Vector3f vector3f2 = new Vector3f(-1.0f, 1.0f, 0.0f);
        Vector3f vector3f3 = new Vector3f(1.0f, 1.0f, 0.0f);
        Vector3f vector3f4 = new Vector3f(1.0f, -1.0f, 0.0f);
        Vector2f vector2f = new Vector2f(0.0f, 1.0f);
        Vector2f vector2f2 = new Vector2f(0.0f, 0.0f);
        Vector2f vector2f3 = new Vector2f(1.0f, 0.0f);
        Vector2f vector2f4 = new Vector2f(1.0f, 1.0f);
        MeshBuilder meshBuilder = new MeshBuilder();
        meshBuilder.quad(vector3f, vector3f2, vector3f3, vector3f4, vector2f, vector2f2, vector2f3, vector2f4);
        Mesh mesh = meshBuilder.build();
        Node<DefaultMeshNode> node2 = new Node<DefaultMeshNode>(new DefaultMeshNode(mesh, this.material));
        node2.getTransform().setScale(0.3f, 0.35f, 0.3f);
        this.bloodRoot = new Node<Object>(null);
        this.bloodRoot.getTransform().setTranslation(this.origo);
        this.bloodRoot.addChild((MeshNode)((Object)node));
        this.bloodRoot.addChild((MeshNode)((Object)node2));
    }

    @Override
    public void onDeinit(GL gL) {
    }

    @Override
    public void onPreCalc() {
        this.band = new Band(5.0f, 100, 1.0f);
    }

    @Override
    public void onStart(Node<MeshNode> node, Interval interval) {
        node.addChild((MeshNode)((Object)this.cityBuilder.getCityRoot()));
        node.addChild((MeshNode)((Object)this.cityBuilder.getLandscapeRoot()));
        node.addChild((MeshNode)((Object)this.cityBuilder.getRoadRoot()));
        node.addChild((MeshNode)((Object)this.cityBuilder.getTextRoot()));
        node.addChild((MeshNode)((Object)this.cityBuilder.getBloodNode()));
        node.addChild((MeshNode)((Object)this.bloodRoot));
        this.cameraControl.registerParameters(this, "blood", interval.from());
    }

    @Override
    public void onStop(Node<MeshNode> node) {
        node.removeChild(this.cityBuilder.getCityRoot());
        node.removeChild(this.cityBuilder.getLandscapeRoot());
        node.removeChild(this.cityBuilder.getRoadRoot());
        node.removeChild(this.cityBuilder.getTextRoot());
        node.removeChild(this.cityBuilder.getBloodNode());
        node.removeChild(this.bloodRoot);
    }

    @Override
    public void onUpdate(GL2 gL2, float f, float f2, float f3, float f4) {
        if (f2 >= 4.0f) {
            this.band.update(f2 - 4.0f, this.pathParameter, this.upParameter, this.widthParameter);
        } else {
            this.band.update(0.0f, this.pathParameter, this.upParameter, this.widthParameter);
        }
        Matrix4f matrix4f = this.cityBuilder.getBloodNode().getTransform();
        matrix4f.set(Matrix4f.IDENTITY);
        matrix4f.setTranslation(this.textParameter.get(f2));
        matrix4f.multLocal(this.scaleMatrix);
        this.cameraControl.positionCamera(f2);
        this.cityBuilder.update(f2);
    }
}

