/*
 * Decompiled with CFR 0.152.
 */
package tazmania.scenes;

import javax.inject.Inject;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import tazadum.engine.asset.Asset;
import tazadum.engine.asset.AssetManager;
import tazadum.engine.math.Interval;
import tazadum.engine.math.Vector2f;
import tazadum.engine.parameter.Parameter;
import tazadum.engine.parameter.ParameterFactory;
import tazadum.engine.rendering.RenderEngine;
import tazadum.engine.rendering.font.Font;
import tazadum.engine.rendering.scenegraph.MeshNode;
import tazadum.engine.rendering.scenegraph.Node;
import tazadum.engine.rendering.scenegraph.Scene;
import tazadum.engine.rendering.shader.DistanceFieldShader;
import tazadum.engine.time.TimeManager;
import tazadum.engine.ui.CameraControl;
import tazmania.Mp3Component;
import tazmania.scenes.building.BuildingMaterial;
import tazmania.scenes.building.CityBuilder;

public class IntroScene
implements Scene {
    private final CityBuilder cityBuilder;
    private final Asset<Font> font;
    private final Parameter<Vector2f> windowParameter;
    private final CameraControl cameraControl;
    private final Mp3Component mp3Component;
    private final TimeManager timeManager;

    @Inject
    public IntroScene(RenderEngine renderEngine, CameraControl cameraControl, CityBuilder cityBuilder, ParameterFactory parameterFactory, AssetManager assetManager, DistanceFieldShader distanceFieldShader, Mp3Component mp3Component, TimeManager timeManager) {
        this.cameraControl = cameraControl;
        this.cityBuilder = cityBuilder;
        this.mp3Component = mp3Component;
        this.timeManager = timeManager;
        this.font = assetManager.loadFont("resources/font/font.fnt", "resources/font/font.png");
        this.windowParameter = parameterFactory.tween2f(this, "intro-window-control");
        cameraControl.registerParameters(this, "intro");
    }

    @Override
    public void onPreCalc() {
        this.cityBuilder.create();
    }

    @Override
    public void onInit(GL gL) {
        this.cityBuilder.addTexts(gL, this.font.get());
    }

    @Override
    public void onDeinit(GL gL) {
    }

    @Override
    public void onStart(Node<MeshNode> node, Interval interval) {
        node.addChild((MeshNode)((Object)this.cityBuilder.getCityRoot()));
        node.addChild((MeshNode)((Object)this.cityBuilder.getLandscapeRoot()));
        this.cameraControl.registerParameters(this, "intro", interval.from());
        this.mp3Component.onSetTime(this.timeManager.getTime());
    }

    @Override
    public void onStop(Node<MeshNode> node) {
        node.removeChild(this.cityBuilder.getCityRoot());
        node.removeChild(this.cityBuilder.getLandscapeRoot());
    }

    @Override
    public void onUpdate(GL2 gL2, float f, float f2, float f3, float f4) {
        this.cameraControl.positionCamera(f2);
        Vector2f vector2f = this.windowParameter.get(f2);
        BuildingMaterial buildingMaterial = this.cityBuilder.getBuildingMaterial();
        buildingMaterial.setAlpha(vector2f.x);
        buildingMaterial.setHeight(vector2f.y);
    }
}

