/*
 * Decompiled with CFR 0.152.
 */
package tazmania.scenes;

import javax.inject.Inject;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import tazadum.engine.asset.Asset;
import tazadum.engine.asset.AssetManager;
import tazadum.engine.math.Interval;
import tazadum.engine.math.Matrix4f;
import tazadum.engine.math.Quaternion;
import tazadum.engine.math.Vector2f;
import tazadum.engine.math.Vector3f;
import tazadum.engine.math.Vector4f;
import tazadum.engine.parameter.Parameter;
import tazadum.engine.parameter.ParameterFactory;
import tazadum.engine.rendering.RenderEngine;
import tazadum.engine.rendering.font.Font;
import tazadum.engine.rendering.scenegraph.MeshNode;
import tazadum.engine.rendering.scenegraph.Node;
import tazadum.engine.rendering.scenegraph.Scene;
import tazadum.engine.ui.CameraControl;
import tazmania.scenes.building.BuildingMaterial;
import tazmania.scenes.building.CityBuilder;

public class CityScene
implements Scene {
    private final CameraControl cameraControl;
    private final CityBuilder cityBuilder;
    private final Parameter<Vector2f> windowParameter;
    private final Asset<Font> font;
    private final Parameter<Vector4f> today;
    private final Parameter<Vector4f> someone;
    private final Parameter<Vector4f> enough;
    private final Parameter<Vector4f> carry;
    private final Parameter<Vector4f> bullet;
    private final Quaternion quaternion = new Quaternion();
    private final Quaternion quaternion2 = new Quaternion();
    private final Matrix4f scaleMatrix = new Matrix4f();

    @Inject
    public CityScene(RenderEngine renderEngine, CameraControl cameraControl, CityBuilder cityBuilder, ParameterFactory parameterFactory, AssetManager assetManager) {
        this.cameraControl = cameraControl;
        this.cityBuilder = cityBuilder;
        this.font = assetManager.loadFont("resources/font/font.fnt", "resources/font/font.png");
        this.windowParameter = parameterFactory.tween2f(this, "city-window-control");
        cameraControl.registerParameters(this, "city");
        this.today = parameterFactory.tween4f(this, "city-today");
        this.someone = parameterFactory.tween4f(this, "city-someone");
        this.enough = parameterFactory.tween4f(this, "city-enought");
        this.carry = parameterFactory.tween4f(this, "city-carry");
        this.bullet = parameterFactory.tween4f(this, "city-bullet");
    }

    @Override
    public void onPreCalc() {
        this.cityBuilder.create();
    }

    @Override
    public void onInit(GL gL) {
        this.cityBuilder.addTexts(gL, this.font.get());
    }

    @Override
    public void onDeinit(GL gL) {
    }

    @Override
    public void onStart(Node<MeshNode> node, Interval interval) {
        node.addChild((MeshNode)((Object)this.cityBuilder.getCityRoot()));
        node.addChild((MeshNode)((Object)this.cityBuilder.getLandscapeRoot()));
        node.addChild((MeshNode)((Object)this.cityBuilder.getRoadRoot()));
        node.addChild((MeshNode)((Object)this.cityBuilder.getTextRoot()));
        node.addChild((MeshNode)((Object)this.cityBuilder.getTodayNode()));
        node.addChild((MeshNode)((Object)this.cityBuilder.getSomeoneNode()));
        node.addChild((MeshNode)((Object)this.cityBuilder.getEnoughNode()));
        node.addChild((MeshNode)((Object)this.cityBuilder.getCarryNode()));
        node.addChild((MeshNode)((Object)this.cityBuilder.getBulletNode()));
        this.cameraControl.registerParameters(this, "city", interval.from());
    }

    @Override
    public void onStop(Node<MeshNode> node) {
        node.removeChild(this.cityBuilder.getCityRoot());
        node.removeChild(this.cityBuilder.getLandscapeRoot());
        node.removeChild(this.cityBuilder.getRoadRoot());
        node.removeChild(this.cityBuilder.getTextRoot());
        node.removeChild(this.cityBuilder.getTodayNode());
        node.removeChild(this.cityBuilder.getSomeoneNode());
        node.removeChild(this.cityBuilder.getEnoughNode());
        node.removeChild(this.cityBuilder.getCarryNode());
        node.removeChild(this.cityBuilder.getBulletNode());
    }

    @Override
    public void onUpdate(GL2 gL2, float f, float f2, float f3, float f4) {
        this.cameraControl.positionCamera(f2);
        this.cityBuilder.update(f2);
        this.position(this.cityBuilder.getTodayNode(), this.today.get(f2), 1.0f, 0.0f);
        this.position(this.cityBuilder.getSomeoneNode(), this.someone.get(f2), f2 < 15.0f ? 0.5f : 0.05f, 0.0f);
        this.position(this.cityBuilder.getEnoughNode(), this.enough.get(f2), 0.1f, 0.0f);
        this.position(this.cityBuilder.getCarryNode(), this.carry.get(f2), 0.1f, 0.0f);
        this.position(this.cityBuilder.getBulletNode(), this.bullet.get(f2), 0.25f, 1.57075f);
        Vector2f vector2f = this.windowParameter.get(f2);
        BuildingMaterial buildingMaterial = this.cityBuilder.getBuildingMaterial();
        buildingMaterial.setAlpha(vector2f.x);
        buildingMaterial.setHeight(vector2f.y);
    }

    private void position(Node<MeshNode> node, Vector4f vector4f, float f, float f2) {
        this.quaternion.fromAngleNormalAxis(vector4f.w, Vector3f.UNIT_Y);
        this.quaternion2.fromAngleNormalAxis(f2, Vector3f.UNIT_X);
        this.scaleMatrix.set(Matrix4f.IDENTITY);
        this.scaleMatrix.setScale(f, f, f);
        node.getTransform().set(Matrix4f.IDENTITY);
        node.getTransform().setTranslation(vector4f.x, vector4f.y, vector4f.z);
        node.getTransform().multLocal(this.quaternion);
        node.getTransform().multLocal(this.quaternion2);
        node.getTransform().multLocal(this.scaleMatrix);
    }
}

