/*
 * Decompiled with CFR 0.152.
 */
package tazmania.scenes;

import javax.inject.Inject;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import tazadum.engine.asset.AssetManager;
import tazadum.engine.math.Interval;
import tazadum.engine.math.Matrix4f;
import tazadum.engine.math.Vector2f;
import tazadum.engine.math.Vector3f;
import tazadum.engine.math.Vector4f;
import tazadum.engine.parameter.Parameter;
import tazadum.engine.parameter.ParameterFactory;
import tazadum.engine.rendering.RenderEngine;
import tazadum.engine.rendering.material.DefaultMaterial;
import tazadum.engine.rendering.scenegraph.DefaultMeshNode;
import tazadum.engine.rendering.scenegraph.MeshNode;
import tazadum.engine.rendering.scenegraph.Node;
import tazadum.engine.rendering.scenegraph.Scene;
import tazadum.engine.rendering.shader.SimpleShader;
import tazadum.engine.time.TimeManager;
import tazadum.engine.ui.CameraControl;
import tazmania.Mp3Component;
import tazmania.gfx.Band;
import tazmania.scenes.building.BuildingMaterial;
import tazmania.scenes.building.CityBuilder;

public class BloodLinesScene
implements Scene {
    private static final int BANDS = 10;
    private static final int SEGMENTS = 200;
    private final SimpleShader shader;
    private final CityBuilder cityBuilder;
    private Node<MeshNode> root;
    private final CameraControl cameraControl;
    private final Matrix4f scaleMatrix;
    private Band[] bands;
    private DefaultMaterial bandMaterial;
    private final Parameter<Vector3f> pathParameter;
    private final Parameter<Vector3f> orientationParameter;
    private final Parameter<Vector3f> upParameter;
    private final Parameter<Float> distanceParameter;
    private final Parameter<Vector2f> windowParameter;
    private final Mp3Component mp3Component;
    private final TimeManager timeManager;

    @Inject
    public BloodLinesScene(RenderEngine renderEngine, ParameterFactory parameterFactory, AssetManager assetManager, SimpleShader simpleShader, CityBuilder cityBuilder, CameraControl cameraControl, Mp3Component mp3Component, TimeManager timeManager) {
        this.shader = simpleShader;
        this.cityBuilder = cityBuilder;
        this.cameraControl = cameraControl;
        this.mp3Component = mp3Component;
        this.timeManager = timeManager;
        cameraControl.registerParameters(this, "line");
        this.pathParameter = parameterFactory.spline(this, "line-path");
        this.distanceParameter = parameterFactory.tween1f(this, "line-distance");
        this.orientationParameter = parameterFactory.tween3f(this, "line-orientation");
        this.upParameter = parameterFactory.tween3f(this, "line-up");
        this.windowParameter = parameterFactory.tween2f(this, "line-window-control");
        this.scaleMatrix = new Matrix4f();
        this.scaleMatrix.setScale(0.25f, 0.25f, 0.25f);
    }

    @Override
    public void onInit(GL gL) {
    }

    @Override
    public void onDeinit(GL gL) {
    }

    @Override
    public void onPreCalc() {
        this.bandMaterial = new DefaultMaterial(this.shader);
        this.bandMaterial.setTwoSided(true);
        this.bandMaterial.setEmittance(1.0f);
        this.bandMaterial.setAmbient(new Vector4f(1.0f, 0.0f, 0.0f, 1.0f));
        this.root = new Node<Object>(null);
        this.bands = new Band[10];
        for (int i = 0; i < 10; ++i) {
            this.bands[i] = new Band(5.0f, 200, 2.0f);
            this.root.addChild((MeshNode)((Object)new Node<DefaultMeshNode>(new DefaultMeshNode(this.bands[i], this.bandMaterial))));
        }
    }

    @Override
    public void onStart(Node<MeshNode> node, Interval interval) {
        node.addChild((MeshNode)((Object)this.cityBuilder.getCityRoot()));
        node.addChild((MeshNode)((Object)this.cityBuilder.getLandscapeRoot()));
        node.addChild((MeshNode)((Object)this.cityBuilder.getRoadRoot()));
        node.addChild((MeshNode)((Object)this.cityBuilder.getTextRoot()));
        node.addChild((MeshNode)((Object)this.root));
        this.cameraControl.registerParameters(this, "line", interval.from());
    }

    @Override
    public void onStop(Node<MeshNode> node) {
        node.removeChild(this.cityBuilder.getCityRoot());
        node.removeChild(this.cityBuilder.getLandscapeRoot());
        node.removeChild(this.cityBuilder.getRoadRoot());
        node.removeChild(this.cityBuilder.getTextRoot());
        node.removeChild(this.root);
    }

    @Override
    public void onUpdate(GL2 gL2, float f, float f2, float f3, float f4) {
        Vector3f vector3f = new Vector3f();
        for (int i = 0; i < 200; ++i) {
            float f5 = f2 - 5.0f * (float)i / 200.0f;
            Vector3f vector3f2 = this.orientationParameter.get(f5).normalizeLocal();
            Vector3f vector3f3 = this.upParameter.get(f5).normalizeLocal();
            float f6 = this.distanceParameter.get(f5).floatValue();
            for (int j = 0; j < 10; ++j) {
                float f7 = (float)j / 10.0f;
                Vector3f vector3f4 = this.pathParameter.get(f5 + (float)Math.sin(f7 + 0.01f * (float)i));
                float f8 = (float)(Math.cos(5.283f * f7) * (double)f6);
                float f9 = (float)(Math.sin(6.283f * f7) * (double)f6);
                vector3f.x = vector3f4.x + f8 * vector3f2.x + f9 * vector3f3.x;
                vector3f.y = vector3f4.y + f8 * vector3f2.y + f9 * vector3f3.y;
                vector3f.z = vector3f4.z + f8 * vector3f2.z + f9 * vector3f3.z;
                this.bands[j].update(i, vector3f, vector3f2, 3.0f);
            }
        }
        this.cameraControl.positionCamera(f2);
        this.cityBuilder.update(f2);
        Vector2f vector2f = this.windowParameter.get(f2);
        BuildingMaterial buildingMaterial = this.cityBuilder.getBuildingMaterial();
        buildingMaterial.setAlpha(vector2f.x);
        buildingMaterial.setHeight(vector2f.y);
    }
}

