/*
 * Decompiled with CFR 0.152.
 */
package tazmania;

import javax.inject.Inject;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import tazadum.engine.rendering.RenderEngine;
import tazadum.engine.rendering.effect.FullscreenQuad;
import tazadum.engine.rendering.effect.PostEffect;
import tazmania.shader.PostFxShader;

public class PostFrameEffect
implements PostEffect {
    private final RenderEngine renderEngine;
    private final PostFxShader shader;
    private final FullscreenQuad quad;
    private int texture;
    private float pixelation;
    private float alpha;
    private float blend;

    @Inject
    public PostFrameEffect(RenderEngine renderEngine, PostFxShader postFxShader) {
        this.renderEngine = renderEngine;
        this.shader = postFxShader;
        this.quad = new FullscreenQuad(1.0f);
    }

    @Override
    public void onRender(GL2 gL2, float f, float f2) {
        this.shader.enable(gL2);
        this.shader.bindPixelation(gL2, this.pixelation);
        this.shader.bindAlpha(gL2, this.alpha);
        this.shader.bindBlend(gL2, this.blend);
        this.shader.bindRatio(gL2, this.renderEngine.getRatio());
        this.shader.bindVertices(gL2, this.quad.getVertexBuffer());
        this.shader.bindTexCoords0(gL2, this.quad.getTextureBuffer());
        this.shader.bindTexture0(gL2, this.texture);
        this.quad.draw((GL)gL2);
    }

    @Override
    public boolean requireFBO() {
        return true;
    }

    @Override
    public void setTexture(int n, int n2) {
        this.texture = n2;
    }

    public void setPixelation(float f) {
        this.pixelation = f;
    }

    public void setAlpha(float f) {
        this.alpha = f;
    }

    public void setBlend(float f) {
        this.blend = f;
    }
}

