/*
 * Decompiled with CFR 0.152.
 */
package tazmania;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.SampleBuffer;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.FactoryRegistry;
import tazadum.engine.integration.ExternalComponent;
import tazadum.engine.resource.ResourceManager;
import tazadum.engine.time.TimeManager;

public class Mp3Component
implements ExternalComponent,
Runnable {
    private final ResourceManager resourceManager;
    private AudioDevice audio;
    private Decoder decoder;
    private List<short[]> frames;
    private List<Float> times;
    private volatile boolean play = false;
    private final AtomicInteger frame = new AtomicInteger(0);
    private final Thread thread;
    private final TimeManager timeManager;

    @Inject
    public Mp3Component(ResourceManager resourceManager, TimeManager timeManager) {
        this.resourceManager = resourceManager;
        this.timeManager = timeManager;
        try {
            this.audio = FactoryRegistry.systemRegistry().createAudioDevice();
            this.decoder = new Decoder();
            this.audio.open(this.decoder);
        }
        catch (JavaLayerException javaLayerException) {
            throw new RuntimeException(javaLayerException);
        }
        this.thread = new Thread((Runnable)this, "MusicThread");
    }

    @Override
    public void onPrecalc() {
        this.frames = new ArrayList<short[]>();
        this.times = new ArrayList<Float>();
        this.decodeMusic(this.resourceManager.load("resources/tazmania01.mp3"));
        this.thread.start();
    }

    @Override
    public void onPlay() {
        this.play = true;
    }

    @Override
    public void onPause() {
        this.play = false;
    }

    @Override
    public void onSetTime(float f) {
        if (this.times == null) {
            return;
        }
        int n = (int)(f / 0.026122449f);
        this.frame.set(n);
        if (n < 0 || n >= this.times.size()) {
            return;
        }
        this.timeManager.setTime(this.times.get(n).floatValue());
    }

    protected void decodeMusic(byte[] byArray) {
        Bitstream bitstream = new Bitstream(new ByteArrayInputStream(byArray));
        try {
            int n = 0;
            while (true) {
                Header header;
                if ((header = bitstream.readFrame()) == null) {
                    return;
                }
                SampleBuffer sampleBuffer = (SampleBuffer)this.decoder.decodeFrame(header, bitstream);
                this.frames.add(Arrays.copyOf(sampleBuffer.getBuffer(), sampleBuffer.getBufferLength()));
                this.times.add(Float.valueOf((float)(n += sampleBuffer.getBufferLength()) / 88200.0f));
                bitstream.closeFrame();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception decoding audio frame", exception);
        }
    }

    @Override
    public void run() {
        while (true) {
            if (this.play) {
                try {
                    int n = this.frame.getAndIncrement();
                    if (n >= 0 && n < this.frames.size()) {
                        short[] sArray = this.frames.get(n);
                        this.audio.write(sArray, 0, sArray.length);
                    }
                }
                catch (JavaLayerException javaLayerException) {
                    throw new RuntimeException(javaLayerException);
                }
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

