/*
 * Decompiled with CFR 0.152.
 */
package tazadum.matrix;

import java.util.Comparator;
import tazadum.matrix.Vector3;

public class Vectors {
    public static Comparator<Vector3> SORT_BY_Z = new Comparator<Vector3>(){

        @Override
        public int compare(Vector3 vector3, Vector3 vector32) {
            return Float.compare(vector3.z, vector32.z);
        }
    };

    private Vectors() {
    }

    public static Vector3 mul(Vector3 vector3, float f) {
        return new Vector3(vector3.x * f, vector3.y * f, vector3.z * f);
    }

    public static float dot(Vector3 vector3, Vector3 vector32) {
        return vector3.x * vector32.x + vector3.y * vector32.y + vector3.z * vector32.z;
    }

    public static Vector3 cross(Vector3 vector3, Vector3 vector32) {
        return new Vector3(vector3.y * vector32.z - vector3.z * vector32.y, vector3.z * vector32.x - vector3.x * vector32.z, vector3.x * vector32.y - vector3.y * vector32.z);
    }

    public static Vector3 sub(Vector3 vector3, Vector3 vector32) {
        return new Vector3(vector3.x - vector32.x, vector3.y - vector32.y, vector3.z - vector32.z);
    }

    public static Vector3 mid(Vector3 vector3, Vector3 vector32) {
        float f = (vector3.x + vector32.x) * 0.5f;
        float f2 = (vector3.y + vector32.y) * 0.5f;
        float f3 = (vector3.z + vector32.z) * 0.5f;
        return new Vector3(f, f2, f3);
    }

    public Vector3 normalize(Vector3 vector3) {
        float f = vector3.length();
        if (Float.isNaN(f)) {
            return new Vector3();
        }
        float f2 = 1.0f / f;
        return new Vector3(vector3.x * f2, vector3.y * f2, vector3.z * f2);
    }

    public static float distance(Vector3 vector3, Vector3 vector32) {
        float f = vector3.x - vector32.x;
        float f2 = vector3.y - vector32.y;
        float f3 = vector3.z - vector32.z;
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }
}

