/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.util.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import tazadum.engine.util.event.Event;
import tazadum.engine.util.event.EventBus;
import tazadum.engine.util.event.EventHandler;
import tazadum.engine.util.event.HandlerRegistration;
import tazadum.engine.util.event.UmbrellaException;

public class SimpleEventBus
implements EventBus {
    private int firingDepth = 0;
    private List<Command> deferredDeltas;
    private final Map<Event.Type<?>, Map<Object, List<?>>> map = new HashMap();

    @Override
    public <H> HandlerRegistration addHandler(Event.Type<H> type, H h) {
        return this.doAdd(type, null, h);
    }

    @Override
    public void fireEvent(Event<?> event) {
        this.doFire(event, null);
    }

    @Deprecated
    protected <H> void doRemove(Event.Type<H> type, Object object, H h) {
        if (this.firingDepth > 0) {
            this.enqueueRemove(type, object, h);
        } else {
            this.doRemoveNow(type, object, h);
        }
    }

    @Deprecated
    protected <H> H getHandler(Event.Type<H> type, int n) {
        assert (n < this.getHandlerCount(type)) : "handlers for " + type.getClass() + " have size: " + this.getHandlerCount(type) + " so do not have a handler at index: " + n;
        List<H> list = this.getHandlerList(type, null);
        return list.get(n);
    }

    @Deprecated
    protected int getHandlerCount(Event.Type<?> type) {
        return this.getHandlerList(type, null).size();
    }

    @Deprecated
    protected boolean isEventHandled(Event.Type<?> type) {
        return this.map.containsKey(type);
    }

    private void defer(Command command) {
        if (this.deferredDeltas == null) {
            this.deferredDeltas = new ArrayList<Command>();
        }
        this.deferredDeltas.add(command);
    }

    private <H> HandlerRegistration doAdd(final Event.Type<H> type, final Object object, final H h) {
        if (type == null) {
            throw new NullPointerException("Cannot add a handler with a null TYPE");
        }
        if (h == null) {
            throw new NullPointerException("Cannot add a null handler");
        }
        if (this.firingDepth > 0) {
            this.enqueueAdd(type, object, h);
        } else {
            this.doAddNow(type, object, h);
        }
        return new HandlerRegistration(){

            @Override
            public void removeHandler() {
                SimpleEventBus.this.doRemove(type, object, h);
            }
        };
    }

    private <H> void doAddNow(Event.Type<H> type, Object object, H h) {
        List<H> list = this.ensureHandlerList(type, object);
        list.add(h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <H extends EventHandler> void doFire(Event<H> event, Object object) {
        if (event == null) {
            throw new NullPointerException("Cannot fire null event");
        }
        try {
            ++this.firingDepth;
            List<H> list = this.getDispatchList(event.getAssociatedType(), object);
            HashSet<Throwable> hashSet = null;
            ListIterator<H> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                EventHandler eventHandler = (EventHandler)listIterator.next();
                try {
                    event.dispatch(eventHandler);
                }
                catch (Throwable throwable) {
                    if (hashSet == null) {
                        hashSet = new HashSet<Throwable>();
                    }
                    hashSet.add(throwable);
                }
            }
            if (hashSet != null) {
                throw new UmbrellaException(hashSet);
            }
        }
        finally {
            --this.firingDepth;
            if (this.firingDepth == 0) {
                this.handleQueuedAddsAndRemoves();
            }
        }
    }

    private <H> void doRemoveNow(Event.Type<H> type, Object object, H h) {
        List<H> list = this.getHandlerList(type, object);
        boolean bl = list.remove(h);
        assert (bl) : "redundant remove call";
        if (bl && list.isEmpty()) {
            this.prune(type, object);
        }
    }

    private <H> void enqueueAdd(final Event.Type<H> type, final Object object, final H h) {
        this.defer(new Command(){

            @Override
            public void execute() {
                SimpleEventBus.this.doAddNow(type, object, h);
            }
        });
    }

    private <H> void enqueueRemove(final Event.Type<H> type, final Object object, final H h) {
        this.defer(new Command(){

            @Override
            public void execute() {
                SimpleEventBus.this.doRemoveNow(type, object, h);
            }
        });
    }

    private <H> List<H> ensureHandlerList(Event.Type<H> type, Object object) {
        List<?> list;
        Map<Object, List<?>> map = this.map.get(type);
        if (map == null) {
            map = new HashMap();
            this.map.put(type, map);
        }
        if ((list = map.get(object)) == null) {
            list = new ArrayList();
            map.put(object, list);
        }
        return list;
    }

    private <H> List<H> getDispatchList(Event.Type<H> type, Object object) {
        List<H> list = this.getHandlerList(type, object);
        if (object == null) {
            return list;
        }
        List<H> list2 = this.getHandlerList(type, null);
        ArrayList<H> arrayList = new ArrayList<H>(list);
        arrayList.addAll(list2);
        return arrayList;
    }

    private <H> List<H> getHandlerList(Event.Type<H> type, Object object) {
        Map<Object, List<?>> map = this.map.get(type);
        if (map == null) {
            return Collections.emptyList();
        }
        List<?> list = map.get(object);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQueuedAddsAndRemoves() {
        if (this.deferredDeltas != null) {
            try {
                for (Command command : this.deferredDeltas) {
                    command.execute();
                }
            }
            finally {
                this.deferredDeltas = null;
            }
        }
    }

    private void prune(Event.Type<?> type, Object object) {
        Map<Object, List<?>> map = this.map.get(type);
        List<?> list = map.remove(object);
        assert (list != null) : "Can't prune what wasn't there";
        assert (list.isEmpty()) : "Pruned unempty list!";
        if (map.isEmpty()) {
            this.map.remove(type);
        }
    }

    private static interface Command {
        public void execute();
    }
}

