/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.util;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class TGA {
    public static BufferedImage read(File file) throws IOException {
        int n;
        int n2;
        boolean bl;
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        byte[] byArray = new byte[18];
        int n3 = (int)file.length() - byArray.length;
        if (n3 < 0) {
            throw new IllegalStateException("file not big enough to contain header: " + file.getAbsolutePath());
        }
        byte[] byArray2 = new byte[n3];
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        randomAccessFile.read(byArray);
        randomAccessFile.read(byArray2);
        randomAccessFile.close();
        if ((byArray[0] | byArray[1]) != 0) {
            throw new IllegalStateException(file.getAbsolutePath());
        }
        if (byArray[2] != 2) {
            throw new IllegalStateException(file.getAbsolutePath());
        }
        int n4 = 0;
        int n5 = 0;
        n4 |= (byArray[12] & 0xFF) << 0;
        n4 |= (byArray[13] & 0xFF) << 8;
        n5 |= (byArray[14] & 0xFF) << 0;
        n5 |= (byArray[15] & 0xFF) << 8;
        boolean bl2 = bl = byArray[16] > 24;
        if (!bl && byArray[16] != 24) {
            throw new IllegalStateException(file.getAbsolutePath());
        }
        if (bl && byArray[16] != 32) {
            throw new IllegalStateException(file.getAbsolutePath());
        }
        if ((byArray[17] & 0xF) != (bl ? 8 : 0)) {
            throw new IllegalStateException(file.getAbsolutePath());
        }
        BufferedImage bufferedImage = new BufferedImage(n4, n5, bl ? 2 : 1);
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        if (nArray.length != n4 * n5) {
            throw new IllegalStateException(file.getAbsolutePath());
        }
        if (byArray2.length < nArray.length * (bl ? 4 : 3)) {
            throw new IllegalStateException(file.getAbsolutePath());
        }
        if (bl) {
            n2 = 0;
            n = (nArray.length - 1) * 4;
            while (n2 < nArray.length) {
                int n6 = n2;
                nArray[n6] = nArray[n6] | (byArray2[n + 0] & 0xFF) << 0;
                int n7 = n2;
                nArray[n7] = nArray[n7] | (byArray2[n + 1] & 0xFF) << 8;
                int n8 = n2;
                nArray[n8] = nArray[n8] | (byArray2[n + 2] & 0xFF) << 16;
                int n9 = n2++;
                nArray[n9] = nArray[n9] | (byArray2[n + 3] & 0xFF) << 24;
                n -= 4;
            }
        } else {
            n2 = 0;
            n = (nArray.length - 1) * 3;
            while (n2 < nArray.length) {
                int n10 = n2;
                nArray[n10] = nArray[n10] | (byArray2[n + 0] & 0xFF) << 0;
                int n11 = n2;
                nArray[n11] = nArray[n11] | (byArray2[n + 1] & 0xFF) << 8;
                int n12 = n2++;
                nArray[n12] = nArray[n12] | (byArray2[n + 2] & 0xFF) << 16;
                n -= 3;
            }
        }
        if (byArray[17] >> 4 != 1) {
            if (byArray[17] >> 4 == 0) {
                for (n2 = 0; n2 < n5; ++n2) {
                    n = n4 / 2;
                    for (int i = 0; i < n; ++i) {
                        int n13 = n2 * n4 + i;
                        int n14 = n2 * n4 + (n4 - 1 - i);
                        int n15 = nArray[n13];
                        nArray[n13] = nArray[n14];
                        nArray[n14] = n15;
                    }
                }
            } else {
                throw new UnsupportedOperationException(file.getAbsolutePath());
            }
        }
        return bufferedImage;
    }

    public static void write(BufferedImage bufferedImage, File file) throws IOException {
        int n;
        byte[] byArray;
        Object[] objectArray;
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        boolean bl = bufferedImage.getColorModel().hasAlpha();
        if (dataBuffer instanceof DataBufferByte) {
            objectArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
            if (objectArray.length != bufferedImage.getWidth() * bufferedImage.getHeight() * (bl ? 4 : 3)) {
                throw new IllegalStateException();
            }
            byArray = new byte[objectArray.length];
            n = 0;
            int n2 = objectArray.length - 1;
            while (n < byArray.length) {
                byArray[n] = objectArray[n2];
                ++n;
                --n2;
            }
        } else if (dataBuffer instanceof DataBufferInt) {
            objectArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            if (objectArray.length != bufferedImage.getWidth() * bufferedImage.getHeight()) {
                throw new IllegalStateException();
            }
            byArray = new byte[objectArray.length * (bl ? 4 : 3)];
            if (bl) {
                n = 0;
                int n3 = objectArray.length - 1;
                while (n < byArray.length) {
                    byArray[n + 0] = (byte)(objectArray[n3] >> 0 & 0xFF);
                    byArray[n + 1] = (byte)(objectArray[n3] >> 8 & 0xFF);
                    byArray[n + 2] = (byte)(objectArray[n3] >> 16 & 0xFF);
                    byArray[n + 3] = (byte)(objectArray[n3] >> 24 & 0xFF);
                    n += 4;
                    --n3;
                }
            } else {
                n = 0;
                int n4 = objectArray.length - 1;
                while (n < byArray.length) {
                    byArray[n + 0] = (byte)(objectArray[n4] >> 0 & 0xFF);
                    byArray[n + 1] = (byte)(objectArray[n4] >> 8 & 0xFF);
                    byArray[n + 2] = (byte)(objectArray[n4] >> 16 & 0xFF);
                    n += 3;
                    --n4;
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
        objectArray = new byte[18];
        objectArray[2] = 2;
        objectArray[12] = (byte)(bufferedImage.getWidth() >> 0 & 0xFF);
        objectArray[13] = (byte)(bufferedImage.getWidth() >> 8 & 0xFF);
        objectArray[14] = (byte)(bufferedImage.getHeight() >> 0 & 0xFF);
        objectArray[15] = (byte)(bufferedImage.getHeight() >> 8 & 0xFF);
        objectArray[16] = (byte)(bl ? 32 : 24);
        objectArray[17] = (byte)((bl ? 8 : 0) | 0x10);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        randomAccessFile.write((byte[])objectArray);
        randomAccessFile.write(byArray);
        randomAccessFile.setLength(randomAccessFile.getFilePointer());
        randomAccessFile.close();
    }
}

