/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.ui.tween;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Iterator;
import tazadum.engine.math.Vector2f;
import tazadum.engine.math.tween.PointType;
import tazadum.engine.math.tween.TweenPoint;
import tazadum.engine.ui.UIColor;
import tazadum.engine.ui.parameter.Grid;

public class TweenViewDrawer {
    private final boolean strictlyOneDimensional = true;
    private final int token;
    private final Grid grid;
    private final Color baseColor;
    private final Color darkColor;
    private final Color darkerColor;

    public TweenViewDrawer(int n, Grid grid, Color color) {
        this.token = n;
        this.grid = grid;
        this.baseColor = color;
        this.darkColor = color.darker();
        this.darkerColor = this.darkColor.darker();
    }

    public void draw(Graphics graphics, Collection<TweenPoint> collection) {
        this.drawSegments(graphics, collection);
        this.drawPointTokens(graphics, collection);
    }

    private void drawSegments(Graphics graphics, Collection<TweenPoint> collection) {
        Iterator<TweenPoint> iterator = collection.iterator();
        PointType pointType = null;
        Vector2f vector2f = null;
        TweenPoint tweenPoint = null;
        graphics.setColor(this.darkColor);
        while (iterator.hasNext()) {
            float f;
            float f2;
            float f3;
            TweenPoint tweenPoint2 = iterator.next();
            Vector2f vector2f2 = this.grid.gridToScreen(tweenPoint2.getPoint());
            if (pointType == null) {
                tweenPoint = tweenPoint2;
                pointType = tweenPoint2.getType();
                vector2f = vector2f2;
                continue;
            }
            if (tweenPoint2.getType() == PointType.Curve && pointType != PointType.Curve) {
                f3 = vector2f2.x - vector2f.x;
                f2 = vector2f2.y - vector2f.y;
                f = (float)Math.sqrt(f3 * f3 + f2 * f2);
                this.drawCurveSegment(graphics, tweenPoint, tweenPoint2, f);
            } else {
                switch (pointType) {
                    case Step: {
                        graphics.drawLine((int)vector2f.x, (int)vector2f.y, (int)vector2f2.x, (int)vector2f.y);
                        graphics.drawLine((int)vector2f2.x, (int)vector2f.y, (int)vector2f2.x, (int)vector2f2.y);
                        break;
                    }
                    case Interpolation: {
                        graphics.drawLine((int)vector2f.x, (int)vector2f.y, (int)vector2f2.x, (int)vector2f2.y);
                        break;
                    }
                    case Curve: {
                        f3 = vector2f2.x - vector2f.x;
                        f2 = vector2f2.y - vector2f.y;
                        f = (float)Math.sqrt(f3 * f3 + f2 * f2);
                        this.drawCurveSegment(graphics, tweenPoint, tweenPoint2, f);
                    }
                }
            }
            pointType = tweenPoint2.getType();
            vector2f = vector2f2;
            tweenPoint = tweenPoint2;
        }
    }

    private void drawCurveSegment(Graphics graphics, TweenPoint tweenPoint, TweenPoint tweenPoint2, float f) {
        Vector2f vector2f = new Vector2f(tweenPoint2.getLeft());
        if (tweenPoint2.getType() != PointType.Curve) {
            vector2f.x = -0.1f;
            vector2f.y = 0.0f;
        }
        vector2f.addLocal(tweenPoint2.getPoint());
        Vector2f vector2f2 = new Vector2f(tweenPoint.getRight());
        if (tweenPoint.getType() != PointType.Curve) {
            vector2f2.x = 0.1f;
            vector2f2.y = 0.0f;
        }
        vector2f2.addLocal(tweenPoint.getPoint());
        Vector2f vector2f3 = null;
        int n = (int)Math.max(5.0f, f / 10.0f);
        for (int i = 0; i < n; ++i) {
            float f2 = (float)i / (float)n;
            Vector2f vector2f4 = this.segment(f2, tweenPoint.getPoint(), vector2f2, vector2f, tweenPoint2.getPoint());
            vector2f4.x = f2 * (tweenPoint2.getPoint().x - tweenPoint.getPoint().x) + tweenPoint.getPoint().x;
            Vector2f vector2f5 = this.grid.gridToScreen(vector2f4);
            if (vector2f3 != null) {
                graphics.drawLine((int)vector2f3.x, (int)vector2f3.y, (int)vector2f5.x, (int)vector2f5.y);
            }
            vector2f3 = vector2f5;
        }
    }

    private void drawPointTokens(Graphics graphics, Collection<TweenPoint> collection) {
        for (TweenPoint tweenPoint : collection) {
            Vector2f vector2f = this.grid.gridToScreen(tweenPoint.getPoint());
            int n = (int)vector2f.x;
            int n2 = (int)vector2f.y;
            graphics.setColor(this.baseColor);
            switch (tweenPoint.getType()) {
                case Step: {
                    graphics.drawRect(n - this.token, n2 - this.token, 2 * this.token, 2 * this.token);
                    break;
                }
                case Interpolation: {
                    graphics.drawLine(n - this.token, n2 - this.token, n + this.token, n2 - this.token);
                    graphics.drawLine(n - this.token, n2 - this.token, n, n2 + this.token);
                    graphics.drawLine(n + this.token, n2 - this.token, n, n2 + this.token);
                    break;
                }
                case Curve: {
                    this.drawCurvetoken(graphics, tweenPoint, vector2f);
                }
            }
        }
    }

    public void drawLengths(Graphics graphics, int n, int n2, TweenPoint tweenPoint, Collection<TweenPoint> collection) {
        int n3;
        int n4;
        Rectangle2D rectangle2D;
        String string;
        Object object;
        if (tweenPoint == null) {
            return;
        }
        Object object2 = null;
        TweenPoint tweenPoint2 = null;
        Iterator<TweenPoint> iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (tweenPoint == object) {
                if (!iterator.hasNext()) break;
                tweenPoint2 = iterator.next();
                break;
            }
            object2 = object;
        }
        object = graphics.getFontMetrics();
        if (object2 != null) {
            string = String.format("%.3f", Float.valueOf(tweenPoint.getPoint().x - ((TweenPoint)object2).getPoint().x));
            rectangle2D = ((FontMetrics)object).getStringBounds(string, graphics);
            n4 = (int)((double)n - rectangle2D.getWidth() - 4.0);
            n3 = (int)((double)n2 - rectangle2D.getHeight());
            graphics.drawString(string, n4, n3);
        }
        if (tweenPoint2 != null) {
            string = String.format("%.3f", Float.valueOf(tweenPoint2.getPoint().x - tweenPoint.getPoint().x));
            rectangle2D = ((FontMetrics)object).getStringBounds(string, graphics);
            n4 = n + 4;
            n3 = (int)((double)n2 - rectangle2D.getHeight());
            graphics.drawString(string, n4, n3);
        }
    }

    public void drawIndicator(Graphics graphics, int n, int n2, PointType pointType) {
        graphics.setColor(UIColor.Indicator.color);
        switch (pointType) {
            case Step: {
                graphics.drawRect(n - this.token, n2 - this.token, 2 * this.token, 2 * this.token);
                break;
            }
            case Interpolation: {
                graphics.drawLine(n - this.token, n2 - this.token, n + this.token, n2 - this.token);
                graphics.drawLine(n - this.token, n2 - this.token, n, n2 + this.token);
                graphics.drawLine(n + this.token, n2 - this.token, n, n2 + this.token);
                break;
            }
            case Curve: {
                graphics.drawOval(n - this.token, n2 - this.token, 2 * this.token, 2 * this.token);
            }
        }
    }

    private void drawCurvetoken(Graphics graphics, TweenPoint tweenPoint, Vector2f vector2f) {
        Vector2f vector2f2 = this.grid.gridToScreen(new Vector2f(tweenPoint.getPoint()).addLocal(tweenPoint.getLeft()));
        Vector2f vector2f3 = this.grid.gridToScreen(new Vector2f(tweenPoint.getPoint()).addLocal(tweenPoint.getRight()));
        int n = (int)vector2f2.x;
        int n2 = (int)vector2f2.y;
        int n3 = (int)vector2f3.x;
        int n4 = (int)vector2f3.y;
        int n5 = (int)vector2f.x;
        int n6 = (int)vector2f.y;
        graphics.setColor(this.darkerColor);
        graphics.drawLine(n, n2, n5, n6);
        graphics.drawLine(n5, n6, n3, n4);
        graphics.setColor(this.baseColor);
        graphics.drawOval(n5 - this.token, n6 - this.token, 2 * this.token, 2 * this.token);
        graphics.setColor(this.darkColor);
        graphics.drawOval(n - this.token, n2 - this.token, 2 * this.token, 2 * this.token);
        graphics.drawOval(n3 - this.token, n4 - this.token, 2 * this.token, 2 * this.token);
    }

    private Vector2f segment(float f, Vector2f vector2f, Vector2f vector2f2, Vector2f vector2f3, Vector2f vector2f4) {
        float f2 = 1.0f - f;
        float f3 = f * f;
        float f4 = f2 * f2;
        float f5 = 3.0f * f4 * f;
        float f6 = 3.0f * f2 * f3;
        float f7 = f4 * f2;
        float f8 = f3 * f;
        Vector2f vector2f5 = new Vector2f();
        vector2f5.x = f7 * vector2f.x + f5 * vector2f2.x + f6 * vector2f3.x + f8 * vector2f4.x;
        vector2f5.y = f7 * vector2f.y + f5 * vector2f2.y + f6 * vector2f3.y + f8 * vector2f4.y;
        return vector2f5;
    }
}

