/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.ui.parameter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tazadum.engine.math.Vector3f;
import tazadum.engine.math.easein.EaseIn;
import tazadum.engine.parameter.Parameter;
import tazadum.engine.parameter.TweenVector3Parameter;
import tazadum.engine.ui.ValueChangeListener;
import tazadum.engine.ui.component.FloatTextField;
import tazadum.engine.ui.component.TwoPartPanel;
import tazadum.engine.ui.component.VectorTextField;

public class TweenVectorParameterUI
extends JPanel {
    private final TweenVector3Parameter parameter;
    private final VectorTextField fromField;
    private final VectorTextField toField;
    private final FloatTextField startField;
    private final FloatTextField durationField;

    public TweenVectorParameterUI(Parameter<?> parameter) {
        this.setLayout(new BorderLayout(5, 5));
        this.parameter = (TweenVector3Parameter)parameter;
        this.fromField = new VectorTextField(this.parameter.getFrom());
        this.toField = new VectorTextField(this.parameter.getTo());
        this.startField = new FloatTextField(this.parameter.getStart());
        this.durationField = new FloatTextField(this.parameter.getDuration());
        this.startField.setColumns(5);
        this.durationField.setColumns(5);
        final JList<EaseIn> jList = new JList<EaseIn>(EaseIn.values());
        final JList<EaseIn.Mode> jList2 = new JList<EaseIn.Mode>(EaseIn.Mode.values());
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jList.setSelectedValue(this.parameter.getEaseIn(), true);
        jList2.setSelectedValue((Object)this.parameter.getMode(), true);
        jPanel.add(jList);
        jPanel.add(jList2);
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        jPanel2.add(new TwoPartPanel(new Label("Start:"), this.startField));
        jPanel2.add(new TwoPartPanel(new Label("Length:"), this.durationField));
        this.add((Component)this.fromField, "West");
        this.add((Component)this.toField, "East");
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel2, "South");
        this.fromField.addValueChangeListener(new ValueChangeListener<Vector3f>(){

            @Override
            public void onValueChanged(Vector3f vector3f) {
                TweenVectorParameterUI.this.parameter.setFrom(vector3f);
            }
        });
        this.toField.addValueChangeListener(new ValueChangeListener<Vector3f>(){

            @Override
            public void onValueChanged(Vector3f vector3f) {
                TweenVectorParameterUI.this.parameter.setTo(vector3f);
            }
        });
        this.durationField.addValueChangeListener(new ValueChangeListener<Float>(){

            @Override
            public void onValueChanged(Float f) {
                TweenVectorParameterUI.this.parameter.setDuration(f.floatValue());
            }
        });
        this.startField.addValueChangeListener(new ValueChangeListener<Float>(){

            @Override
            public void onValueChanged(Float f) {
                TweenVectorParameterUI.this.parameter.setStart(f.floatValue());
            }
        });
        jList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TweenVectorParameterUI.this.parameter.setEaseIn((EaseIn)jList.getSelectedValue());
            }
        });
        jList2.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TweenVectorParameterUI.this.parameter.setMode((EaseIn.Mode)((Object)jList2.getSelectedValue()));
            }
        });
    }
}

