/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.ui.parameter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import tazadum.engine.math.CoordinateMapper;
import tazadum.engine.math.Vector2f;
import tazadum.engine.math.Vector3f;
import tazadum.engine.math.curve.Curve;
import tazadum.engine.parameter.SplineVector3Parameter;
import tazadum.engine.ui.parameter.Grid;

public class SplineEditorPanel
extends JPanel {
    private static final Color COLOR_NODE = Color.BLUE;
    private static final Color COLOR_CONTROL = Color.YELLOW;
    private static final Color COLOR_SPLINE = Color.RED;
    private static final Color COLOR_LABEL = Color.WHITE;
    private static final float ZOOM_AMOUNT = 0.1f;
    private final Grid grid;
    private final SplineVector3Parameter parameter;
    private final CoordinateMapper mapper;
    private final String label;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Editor");
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add((Component)new SplineEditorPanel("X/Y", new SplineVector3Parameter(), new CoordinateMapper(CoordinateMapper.Axis.X, CoordinateMapper.Axis.Y, CoordinateMapper.Axis.Z)), "Center");
        jFrame.setSize(300, 300);
        jFrame.setVisible(true);
    }

    public SplineEditorPanel(String string, SplineVector3Parameter splineVector3Parameter, final CoordinateMapper coordinateMapper) {
        this.label = string;
        this.parameter = splineVector3Parameter;
        this.mapper = coordinateMapper;
        this.grid = new Grid();
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                SplineEditorPanel.this.grid.zoom((float)mouseWheelEvent.getWheelRotation() * 0.1f);
                SplineEditorPanel.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){
            private Point start;
            private Vector3f active = null;

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                this.start = mouseEvent.getPoint();
                this.active = null;
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiersEx() & 0x80) == 0) {
                    if (this.active == null) {
                        this.active = SplineEditorPanel.this.findPoint(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                        if (this.active == null) {
                            return;
                        }
                    }
                    Vector3f vector3f = SplineEditorPanel.this.grid.screenToGrid(new Vector3f(mouseEvent.getPoint().x, mouseEvent.getPoint().y, 0.0f));
                    coordinateMapper.map(this.active);
                    this.active.x = vector3f.x;
                    this.active.y = vector3f.y;
                    coordinateMapper.map(this.active);
                    SplineEditorPanel.this.redraw();
                } else {
                    int n = this.start.x - mouseEvent.getPoint().x;
                    int n2 = this.start.y - mouseEvent.getPoint().y;
                    if (n == 0 && n2 == 0) {
                        return;
                    }
                    SplineEditorPanel.this.grid.pan(n, n2);
                    this.start = mouseEvent.getPoint();
                    SplineEditorPanel.this.repaint();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiersEx() & 0x80) == 0) {
                    SplineEditorPanel.this.addPoint(mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    protected Vector3f findPoint(int n, int n2) {
        Curve curve = this.parameter.getCurve();
        for (Vector3f vector3f : curve.nodes()) {
            Vector3f vector3f2 = this.mapper.map(new Vector3f(vector3f));
            Vector2f vector2f = this.grid.gridToScreen(new Vector2f(vector3f2.x, vector3f2.y));
            float f = (float)n - vector2f.x;
            float f2 = (float)n2 - vector2f.y;
            if (!(f * f + f2 * f2 < 100.0f)) continue;
            return vector3f;
        }
        return null;
    }

    @Override
    public void paint(Graphics graphics) {
        Vector3f vector3f;
        int n;
        this.grid.draw(graphics);
        Curve curve = this.parameter.getCurve();
        List<Vector3f> list = curve.nodes();
        graphics.setColor(COLOR_SPLINE);
        Vector3f vector3f2 = null;
        for (n = 0; n < list.size(); ++n) {
            for (int i = 0; i < 16 && (vector3f = curve.get((float)n + (float)i / 16.0f)) != null; ++i) {
                Vector3f vector3f3 = this.grid.gridToScreen(this.mapper.map(new Vector3f(vector3f)));
                if (vector3f2 != null) {
                    graphics.drawLine((int)vector3f2.x, (int)vector3f2.y, (int)vector3f3.x, (int)vector3f3.y);
                }
                vector3f2 = vector3f3;
            }
        }
        n = 0;
        for (Vector3f vector3f4 : list) {
            switch (n % 3) {
                case 0: {
                    graphics.setColor(COLOR_NODE);
                    break;
                }
                case 1: 
                case 2: {
                    graphics.setColor(COLOR_CONTROL);
                }
            }
            ++n;
            vector3f = this.grid.gridToScreen(this.mapper.map(new Vector3f(vector3f4)));
            int n2 = (int)vector3f.x - 2;
            int n3 = (int)vector3f.y - 2;
            graphics.drawRect(n2, n3, 4, 4);
        }
        graphics.setColor(COLOR_LABEL);
        graphics.drawString(this.label, 2, 12);
    }

    private void addPoint(int n, int n2) {
        Vector3f vector3f = this.grid.screenToGrid(new Vector3f(n, n2, 0.0f));
        Curve curve = this.parameter.getCurve();
        curve.add(this.mapper.map(vector3f));
        this.redraw();
    }

    private void redraw() {
        if (this.getParent() != null) {
            this.getParent().repaint();
            return;
        }
        this.repaint();
    }
}

