/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.ui.impl;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import tazadum.engine.ui.api.ChangeListener;
import tazadum.engine.ui.api.HasChangeListeners;

public class ChangeListenerContainer<T>
implements HasChangeListeners<T> {
    private final Set<ChangeListener<T>> listeners = new CopyOnWriteArraySet<ChangeListener<T>>();

    @Override
    public void addChangeListener(ChangeListener<T> changeListener) {
        this.listeners.add(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener<T> changeListener) {
        this.listeners.remove(changeListener);
    }

    public void invokeListeners(HasChangeListeners<T> hasChangeListeners, T t) {
        for (ChangeListener<T> changeListener : this.listeners) {
            changeListener.onValueChange(hasChangeListeners, t);
        }
    }
}

