/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.ui.component;

import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import tazadum.engine.ui.HasValueChangeListener;
import tazadum.engine.ui.ValueChangeListener;

public class FloatTextField
extends JTextField
implements HasValueChangeListener<Float> {
    protected static final float SMALL_INCREMENT = 0.01f;
    protected static final float MEDIUM_INCREMENT = 0.1f;
    protected static final float LARGE_INCREMENT = 1.0f;
    private final Set<ValueChangeListener<Float>> listeners = new HashSet<ValueChangeListener<Float>>();

    public FloatTextField(float f) {
        super(20);
        this.setText(this.format(f));
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                float f = 0.1f;
                if ((mouseWheelEvent.getModifiersEx() & 0x80) != 0) {
                    f = 0.01f;
                }
                if ((mouseWheelEvent.getModifiersEx() & 0x200) != 0) {
                    f = 1.0f;
                }
                FloatTextField.this.setText(FloatTextField.this.format(FloatTextField.this.getValue() - (float)mouseWheelEvent.getWheelRotation() * f));
            }
        });
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                FloatTextField.this.invokeListeners(FloatTextField.this.getValue());
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                FloatTextField.this.invokeListeners(FloatTextField.this.getValue());
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
    }

    @Override
    public void addValueChangeListener(ValueChangeListener<Float> valueChangeListener) {
        this.listeners.add(valueChangeListener);
    }

    public float getValue() {
        try {
            return Float.parseFloat(this.getText().replace(',', '.'));
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    private String format(float f) {
        return String.format("%.4f", Float.valueOf(f));
    }

    private void invokeListeners(float f) {
        for (ValueChangeListener<Float> valueChangeListener : this.listeners) {
            valueChangeListener.onValueChanged(Float.valueOf(f));
        }
    }
}

