/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class VerticalFlowLayout
implements LayoutManager,
Serializable {
    public static final int TOP = 0;
    public static final int CENTER = 1;
    public static final int BOTTOM = 2;
    public static final int LEADING = 3;
    public static final int TRAILING = 4;
    int align;
    int newAlign;
    int hgap;
    int vgap;
    private static final long serialVersionUID = -7262534875583282631L;

    public VerticalFlowLayout() {
        this(1, 5, 5);
    }

    public VerticalFlowLayout(int n) {
        this(n, 5, 5);
    }

    public VerticalFlowLayout(int n, int n2, int n3) {
        this.hgap = n2;
        this.vgap = n3;
        this.setAlignment(n);
    }

    public int getAlignment() {
        return this.newAlign;
    }

    public void setAlignment(int n) {
        this.newAlign = n;
        switch (n) {
            case 3: {
                this.align = 0;
                break;
            }
            case 4: {
                this.align = 2;
                break;
            }
            default: {
                this.align = n;
            }
        }
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            int n = container.getComponentCount();
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension2 = component.getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                if (bl) {
                    bl = false;
                } else {
                    dimension.height += this.hgap;
                }
                dimension.height += dimension2.height;
            }
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right + this.hgap * 2;
            dimension.height += insets.top + insets.bottom + this.vgap * 2;
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension2 = component.getMinimumSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                if (i > 0) {
                    dimension.height += this.hgap;
                }
                dimension.height += dimension2.height;
            }
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right + this.hgap * 2;
            dimension.height += insets.top + insets.bottom + this.vgap * 2;
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveComponents(Container container, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Object object = container.getTreeLock();
        synchronized (object) {
            switch (this.newAlign) {
                case 0: {
                    n2 += bl ? 0 : n4;
                    break;
                }
                case 1: {
                    n2 += n4 / 2;
                    break;
                }
                case 2: {
                    n2 += bl ? n4 : 0;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    n2 += n4;
                }
            }
            for (int i = n5; i < n6; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                if (bl) {
                    component.setLocation(n + (n3 - component.getWidth()) / 2, n2);
                } else {
                    component.setLocation(n + (n3 - component.getWidth()) / 2, container.getHeight() - n2 - component.getHeight());
                }
                n2 += component.getHeight() + this.vgap;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = container.getHeight() - (insets.top + insets.bottom + this.vgap * 2);
            int n2 = container.getComponentCount();
            int n3 = insets.left + this.hgap;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            boolean bl = container.getComponentOrientation().isLeftToRight();
            for (int i = 0; i < n2; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension = component.getPreferredSize();
                component.setSize(dimension.width, dimension.height);
                if (n4 == 0 || n4 + dimension.height <= n) {
                    if (n4 > 0) {
                        n4 += this.vgap;
                    }
                    n4 += dimension.height;
                    n5 = Math.max(n5, dimension.width);
                    continue;
                }
                this.moveComponents(container, n3, insets.top + this.vgap, n5, n - n4, n6, i, bl);
                n4 = dimension.height;
                n3 += this.hgap + n5;
                n5 = dimension.width;
                n6 = i;
            }
            this.moveComponents(container, n3, insets.top + this.vgap, n5, n - n4, n6, n2, bl);
        }
    }

    public String toString() {
        String string = "";
        switch (this.align) {
            case 0: {
                string = ",align=left";
                break;
            }
            case 1: {
                string = ",align=center";
                break;
            }
            case 2: {
                string = ",align=right";
                break;
            }
            case 3: {
                string = ",align=leading";
                break;
            }
            case 4: {
                string = ",align=trailing";
            }
        }
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + string + "]";
    }
}

