/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import tazadum.engine.ui.api.ChangeListener;
import tazadum.engine.ui.api.HasChangeListeners;
import tazadum.engine.ui.impl.ChangeListenerContainer;

public class DisclosurePanel
extends JPanel
implements HasChangeListeners<Boolean> {
    JToggleButton disclosureToggle = new JToggleButton();
    Component abridgedComponent;
    Component disclosedComponent;
    ChangeListenerContainer<Boolean> container = new ChangeListenerContainer();

    public DisclosurePanel(String string, Component component) {
        this(string, component, null);
    }

    public DisclosurePanel(String string, Component component, String string2) {
        this(new JButton(string), component);
        JButton jButton = (JButton)this.abridgedComponent;
        jButton.setContentAreaFilled(false);
        jButton.setFocusPainted(false);
        jButton.setRequestFocusEnabled(false);
        jButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jButton.setHorizontalAlignment(2);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisclosurePanel.this.disclosureToggle.doClick();
            }
        });
    }

    public DisclosurePanel(Component component, Component component2) {
        this(component, component2, null);
    }

    public DisclosurePanel(Component component, Component component2, String string) {
        this.disclosureToggle.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.disclosureToggle.setContentAreaFilled(false);
        this.disclosureToggle.setFocusPainted(false);
        this.disclosureToggle.setRequestFocusEnabled(false);
        this.disclosureToggle.setIcon(UIManager.getIcon("Tree.collapsedIcon"));
        this.disclosureToggle.setSelectedIcon(UIManager.getIcon("Tree.expandedIcon"));
        this.abridgedComponent = component;
        this.disclosedComponent = component2;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.disclosureToggle, "North");
        this.add((Component)jPanel, "West");
        this.add(component, "Center");
        if (string != null) {
            this.setBorder(new TitledBorder(string));
        }
        this.disclosureToggle.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (DisclosurePanel.this.disclosureToggle.isSelected()) {
                    DisclosurePanel.this.remove(DisclosurePanel.this.abridgedComponent);
                    DisclosurePanel.this.add(DisclosurePanel.this.disclosedComponent, "Center");
                    DisclosurePanel.this.revalidate();
                } else {
                    DisclosurePanel.this.remove(DisclosurePanel.this.disclosedComponent);
                    DisclosurePanel.this.add(DisclosurePanel.this.abridgedComponent, "Center");
                    DisclosurePanel.this.revalidate();
                }
                DisclosurePanel.this.container.invokeListeners(DisclosurePanel.this, DisclosurePanel.this.isOpen());
            }
        });
    }

    public boolean isOpen() {
        return this.disclosureToggle.isSelected();
    }

    public Component getAbridgedComponent() {
        return this.abridgedComponent;
    }

    public Component getDisclosedComponent() {
        return this.disclosedComponent;
    }

    public void setAbridgedComponent(Component component) {
        if (!this.disclosureToggle.isSelected()) {
            this.remove(this.abridgedComponent);
            this.add(component, "Center");
            this.revalidate();
        }
        this.abridgedComponent = component;
    }

    public void setDisclosedComponent(Component component) {
        if (this.disclosureToggle.isSelected()) {
            this.remove(this.disclosedComponent);
            this.add(component, "Center");
            this.revalidate();
        }
        this.disclosedComponent = component;
    }

    @Override
    public void addChangeListener(ChangeListener<Boolean> changeListener) {
        this.container.addChangeListener(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener<Boolean> changeListener) {
        this.container.removeChangeListener(changeListener);
    }
}

