/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SpringLayout;
import tazadum.engine.ui.event.PlayPauseActionEvent;
import tazadum.engine.ui.event.PlayPauseEvent;
import tazadum.engine.ui.event.ReloadActionEvent;
import tazadum.engine.ui.event.SaveActionEvent;
import tazadum.engine.util.event.EventBus;

public class DebugFrame
implements PlayPauseEvent.Handler {
    private final EventBus eventBus;
    private boolean inPauseState = false;
    private JFrame frame;
    private JToolBar toolBar;
    private JPanel timelinePanel;
    private JPanel contentPanel;
    private JButton itemSave;
    private JButton itemReload;
    private JSeparator separator;
    private JButton itemPlayPause;
    private JTabbedPane eastTabbedPane;
    private JScrollPane propertyTab;
    private JPanel propertyPanel;

    @Inject
    public DebugFrame(EventBus eventBus) {
        this.eventBus = eventBus;
        this.eventBus.addHandler(PlayPauseEvent.TYPE, this);
        this.initialize();
    }

    public void setTitle(String string) {
        this.frame.setTitle(string);
    }

    @Override
    public void onPlayPause(final PlayPauseEvent playPauseEvent) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (playPauseEvent.getAction()) {
                    case Toggle: {
                        break;
                    }
                    case Pause: {
                        DebugFrame.this.inPauseState = true;
                        DebugFrame.this.itemPlayPause.setIcon(new ImageIcon(DebugFrame.class.getResource("/icons/play.png")));
                        break;
                    }
                    case Play: {
                        DebugFrame.this.inPauseState = false;
                        DebugFrame.this.itemPlayPause.setIcon(new ImageIcon(DebugFrame.class.getResource("/icons/pause.png")));
                    }
                }
            }
        });
    }

    private void initialize() {
        this.frame = new JFrame("");
        this.frame.setBounds(0, 0, 320, 240);
        this.frame.setDefaultCloseOperation(2);
        this.frame.getContentPane().setLayout(new BorderLayout());
        SpringLayout springLayout = new SpringLayout();
        JPanel jPanel = new JPanel(springLayout);
        this.frame.getContentPane().add((Component)jPanel, "Center");
        this.toolBar = new JToolBar();
        this.frame.getContentPane().add((Component)this.toolBar, "North");
        this.itemSave = new JButton("");
        this.itemSave.setMnemonic('S');
        this.itemSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DebugFrame.this.eventBus != null) {
                    DebugFrame.this.eventBus.fireEvent(new SaveActionEvent());
                }
            }
        });
        this.itemSave.setIcon(new ImageIcon(DebugFrame.class.getResource("/icons/save.png")));
        this.toolBar.add(this.itemSave);
        this.itemReload = new JButton("");
        this.itemReload.setMnemonic('R');
        this.itemReload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DebugFrame.this.eventBus != null) {
                    DebugFrame.this.eventBus.fireEvent(new ReloadActionEvent());
                }
            }
        });
        this.itemReload.setIcon(new ImageIcon(DebugFrame.class.getResource("/icons/refresh.png")));
        this.toolBar.add(this.itemReload);
        this.separator = new JSeparator(1);
        this.toolBar.add(this.separator);
        this.itemPlayPause = new JButton("");
        this.itemPlayPause.setMnemonic('P');
        this.itemPlayPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DebugFrame.this.eventBus != null) {
                    PlayPauseEvent.Action action = DebugFrame.this.inPauseState ? PlayPauseEvent.Action.Play : PlayPauseEvent.Action.Pause;
                    DebugFrame.this.eventBus.fireEvent(new PlayPauseActionEvent(action));
                }
            }
        });
        this.itemPlayPause.setIcon(new ImageIcon(DebugFrame.class.getResource("/icons/pause.png")));
        this.toolBar.add(this.itemPlayPause);
        this.timelinePanel = new JPanel();
        this.timelinePanel.setLayout(new BorderLayout());
        jPanel.add(this.timelinePanel);
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout());
        this.contentPanel.setMinimumSize(this.contentPanel.getSize());
        jPanel.add(this.contentPanel);
        this.eastTabbedPane = new JTabbedPane(1);
        jPanel.add(this.eastTabbedPane);
        this.propertyPanel = new JPanel(new BorderLayout());
        this.propertyTab = new JScrollPane(this.propertyPanel);
        this.eastTabbedPane.addTab("Properties", null, this.propertyTab, null);
        JPanel jPanel2 = jPanel;
        springLayout.putConstraint("West", (Component)this.toolBar, 5, "West", (Component)jPanel2);
        springLayout.putConstraint("North", (Component)this.toolBar, 5, "North", (Component)jPanel2);
        springLayout.putConstraint("East", (Component)jPanel2, 5, "East", (Component)this.toolBar);
        springLayout.putConstraint("West", (Component)this.contentPanel, 5, "West", (Component)jPanel2);
        springLayout.putConstraint("North", (Component)this.contentPanel, 5, "North", (Component)jPanel2);
        springLayout.putConstraint("West", (Component)this.timelinePanel, 5, "West", (Component)jPanel2);
        springLayout.putConstraint("North", (Component)this.timelinePanel, 5, "South", (Component)this.contentPanel);
        springLayout.putConstraint("East", (Component)this.timelinePanel, -5, "East", (Component)jPanel2);
        springLayout.putConstraint("South", (Component)jPanel2, 5, "South", (Component)this.timelinePanel);
        springLayout.putConstraint("West", (Component)this.eastTabbedPane, 5, "East", (Component)this.contentPanel);
        springLayout.putConstraint("North", (Component)this.eastTabbedPane, 5, "North", (Component)jPanel2);
        springLayout.putConstraint("East", (Component)jPanel2, 5, "East", (Component)this.eastTabbedPane);
        springLayout.putConstraint("South", (Component)this.eastTabbedPane, 0, "South", (Component)this.contentPanel);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public JPanel getPropertyPanel() {
        return this.propertyPanel;
    }

    public JPanel getTimelinePanel() {
        return this.timelinePanel;
    }

    public JPanel getContentPanel() {
        return this.contentPanel;
    }
}

