/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.resource.wavefront;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import tazadum.engine.math.Box;
import tazadum.engine.math.Interval;
import tazadum.engine.math.Vector3f;
import tazadum.engine.memory.Buffers;
import tazadum.engine.resource.wavefront.WavefrontObject;

public class WavefrontObjectBuilder {
    private String objectName;
    private String material;
    private final List<Vector3f> vertices = new ArrayList<Vector3f>();
    private final List<Vector3f> texture = new ArrayList<Vector3f>();
    private final List<Vector3f> normals = new ArrayList<Vector3f>();
    private final List<Integer> vertexIndex = new ArrayList<Integer>();
    private final List<Integer> textureIndex = new ArrayList<Integer>();
    private final List<Integer> normalIndex = new ArrayList<Integer>();
    private final Interval x = new Interval(0.0f, 0.0f);
    private final Interval y = new Interval(0.0f, 0.0f);
    private final Interval z = new Interval(0.0f, 0.0f);

    public WavefrontObject build() {
        Object object;
        FloatBuffer floatBuffer = Buffers.allocateFloat(this.vertices.size() * 3);
        float[] fArray = new float[3];
        for (Vector3f object22 : this.vertices) {
            floatBuffer.put(object22.toArray(fArray));
        }
        floatBuffer.rewind();
        Iterator<Object> iterator = this.normalIndex.iterator();
        IntBuffer intBuffer = Buffers.allocateInt(this.vertexIndex.size());
        FloatBuffer floatBuffer2 = Buffers.allocateFloat(this.vertices.size() * 3);
        Object object2 = this.vertexIndex.iterator();
        while (object2.hasNext()) {
            int vector3f = object2.next();
            intBuffer.put((short)vector3f);
            object = this.normals.get((Integer)iterator.next());
            floatBuffer2.put(vector3f * 3 + 0, ((Vector3f)object).x);
            floatBuffer2.put(vector3f * 3 + 1, ((Vector3f)object).y);
            floatBuffer2.put(vector3f * 3 + 2, ((Vector3f)object).z);
        }
        floatBuffer2.rewind();
        intBuffer.rewind();
        object2 = new Vector3f(this.x.from(), this.y.from(), this.z.from());
        Vector3f vector3f = new Vector3f(this.x.from(), this.y.from(), this.z.from());
        object = new Box((Vector3f)object2, vector3f);
        return new WavefrontObject(this.objectName, this.material, floatBuffer, floatBuffer2, intBuffer, (Box)object);
    }

    public void parse(String string) {
        String[] stringArray;
        block16: for (String string2 : stringArray = string.split("\n")) {
            if (string2.length() == 0 || string2.startsWith("#")) continue;
            String[] stringArray2 = this.toWords(string2);
            switch (stringArray2[0]) {
                case "mtllib": {
                    this.setMaterial(stringArray2);
                    continue block16;
                }
                case "o": {
                    this.setObjectName(stringArray2);
                    continue block16;
                }
                case "vt": {
                    this.addTextureCoordinate(stringArray2);
                    continue block16;
                }
                case "vn": {
                    this.addVertexNormal(stringArray2);
                    continue block16;
                }
                case "v": {
                    this.addVertex(stringArray2);
                    continue block16;
                }
                case "f": {
                    this.addFace(stringArray2);
                    continue block16;
                }
            }
        }
    }

    private void addFace(String[] stringArray) {
        String[] stringArray2 = stringArray[1].split("/");
        String[] stringArray3 = stringArray[2].split("/");
        String[] stringArray4 = stringArray[3].split("/");
        this.addFace(stringArray2, stringArray3, stringArray4);
        if (stringArray.length == 5) {
            String[] stringArray5 = stringArray[4].split("/");
            this.addFace(stringArray2, stringArray4, stringArray5);
        }
        if (stringArray.length >= 6) {
            throw new IllegalArgumentException("More than 4 vertices in a face is not supported!");
        }
    }

    private void addFace(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        this.vertexIndex.add(Integer.parseInt(stringArray[0]) - 1);
        this.vertexIndex.add(Integer.parseInt(stringArray2[0]) - 1);
        this.vertexIndex.add(Integer.parseInt(stringArray3[0]) - 1);
        if (stringArray.length > 1 && stringArray[1].length() > 0) {
            this.textureIndex.add(Integer.parseInt(stringArray[1]) - 1);
            this.textureIndex.add(Integer.parseInt(stringArray2[1]) - 1);
            this.textureIndex.add(Integer.parseInt(stringArray3[1]) - 1);
        }
        if (stringArray.length > 2) {
            this.normalIndex.add(Integer.parseInt(stringArray[2]) - 1);
            this.normalIndex.add(Integer.parseInt(stringArray2[2]) - 1);
            this.normalIndex.add(Integer.parseInt(stringArray3[2]) - 1);
        }
    }

    private void addTextureCoordinate(String[] stringArray) {
        this.texture.add(this.parseVector(stringArray, 1));
    }

    private void addVertexNormal(String[] stringArray) {
        this.normals.add(this.parseVector(stringArray, 1).normalizeLocal());
    }

    private void addVertex(String[] stringArray) {
        Vector3f vector3f = this.parseVector(stringArray, 1);
        this.x.extend(vector3f.x);
        this.y.extend(vector3f.y);
        this.z.extend(vector3f.z);
        this.vertices.add(vector3f);
    }

    private void setObjectName(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i < stringArray.length; ++i) {
            if (i > 1) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(stringArray[i]);
        }
        this.objectName = stringBuilder.toString();
    }

    private void setMaterial(String[] stringArray) {
        this.material = stringArray[1];
    }

    private Vector3f parseVector(String[] stringArray, int n) {
        float f = Float.parseFloat(stringArray[n + 0]);
        float f2 = Float.parseFloat(stringArray[n + 1]);
        float f3 = n + 2 < stringArray.length ? Float.parseFloat(stringArray[n + 2]) : 0.0f;
        return new Vector3f(f, f2, f3);
    }

    private String[] toWords(String string) {
        return string.split(" ");
    }
}

