/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.resource;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import tazadum.engine.resource.FileSystemWalker;
import tazadum.engine.resource.JsonSerializer;
import tazadum.engine.resource.ResourceManager;
import tazadum.engine.resource.selector.FilePatternSelector;

public class FileSystemResourceManager
implements ResourceManager {
    private final JsonSerializer jsonSerializer;

    @Inject
    public FileSystemResourceManager(JsonSerializer jsonSerializer) {
        this.jsonSerializer = jsonSerializer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] load(String string) {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));){
            byte[] byArray = new byte[16384];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            while ((n = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.flush();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public <T> T load(String string, Class<T> clazz) {
        return this.jsonSerializer.deserialize(new String(this.load(string)), clazz);
    }

    @Override
    public void save(String string, String string2) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(string);){
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public <T> void save(String string, T t) {
        this.save(string, this.jsonSerializer.serialize(t));
    }

    @Override
    public List<String> find(String string) {
        FilePatternSelector filePatternSelector = new FilePatternSelector(string);
        FileSystemWalker fileSystemWalker = new FileSystemWalker(filePatternSelector.basedir());
        return fileSystemWalker.select(filePatternSelector);
    }
}

