/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.resource;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.inject.Inject;
import tazadum.engine.resource.JsonSerializer;
import tazadum.engine.resource.ResourceManager;

public class ClasspathResourceManager
implements ResourceManager {
    private final JsonSerializer jsonSerializer;

    @Inject
    public ClasspathResourceManager(JsonSerializer jsonSerializer) {
        this.jsonSerializer = jsonSerializer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] load(String string) {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);){
            byte[] byArray = new byte[16384];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            while ((n = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.flush();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public <T> T load(String string, Class<T> clazz) {
        return this.jsonSerializer.deserialize(new String(this.load(string)), clazz);
    }

    @Override
    public void save(String string, String string2) {
        throw new RuntimeException("Not allowed");
    }

    @Override
    public <T> void save(String string, T t) {
        throw new RuntimeException("Not allowed");
    }

    @Override
    public List<String> find(String string) {
        throw new RuntimeException("Not allowed");
    }
}

