/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.rendering.target;

import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import tazadum.engine.memory.Buffers;
import tazadum.engine.rendering.LifeCycle;
import tazadum.engine.rendering.target.RenderTarget;

public class FBORenderTarget
implements RenderTarget,
LifeCycle {
    private final int[] framebuffers = new int[1];
    private final int[] renders = new int[1];
    private final int[] textures = new int[1];
    private IntBuffer buffer;
    private final int width;
    private final int height;

    public FBORenderTarget(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    @Override
    public void onInit(GL gL) {
        gL.glGenFramebuffers(1, this.framebuffers, 0);
        gL.glGenRenderbuffers(1, this.renders, 0);
        gL.glGenTextures(1, this.textures, 0);
        this.buffer = Buffers.allocateInt(this.width * this.height);
        this.buffer.rewind();
        gL.glBindTexture(3553, this.textures[0]);
        gL.glTexParameterf(3553, 10241, 9729.0f);
        gL.glTexParameterf(3553, 10240, 9729.0f);
        gL.glTexParameteri(3553, 10242, 33071);
        gL.glTexParameteri(3553, 10243, 33071);
        gL.glTexImage2D(3553, 0, 6408, this.width, this.height, 0, 6408, 32821, (Buffer)this.buffer);
        gL.glBindRenderbuffer(36161, this.renders[0]);
        gL.glRenderbufferStorage(36161, 33189, this.width, this.height);
        gL.glBindFramebuffer(36160, this.framebuffers[0]);
        gL.glFramebufferTexture2D(36160, 36064, 3553, this.textures[0], 0);
        gL.glFramebufferRenderbuffer(36160, 36096, 36161, this.renders[0]);
        int n = gL.glCheckFramebufferStatus(36160);
        if (n != 36053) {
            throw new IllegalStateException("Couldn't bind framebuffer");
        }
    }

    @Override
    public void onDeinit(GL gL) {
        if (this.renders[0] >= 0) {
            gL.glDeleteRenderbuffers(1, this.renders, 0);
            this.renders[0] = -1;
        }
        if (this.textures[0] >= 0) {
            gL.glDeleteTextures(1, this.textures, 0);
            this.textures[0] = -1;
        }
        if (this.framebuffers[0] >= 0) {
            gL.glDeleteFramebuffers(1, this.framebuffers, 0);
            this.framebuffers[0] = -1;
        }
    }

    public int getTextureId() {
        return this.textures[0];
    }

    @Override
    public void enable(GL gL) {
        gL.glBindFramebuffer(36160, this.framebuffers[0]);
        gL.glViewport(0, 0, this.width, this.height);
    }

    @Override
    public void disable(GL gL) {
        gL.glBindFramebuffer(36160, 0);
    }
}

