/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.rendering.shader;

import com.jogamp.opengl.util.glsl.ShaderUtil;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import javax.inject.Inject;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import tazadum.engine.math.Matrix4f;
import tazadum.engine.rendering.LifeCycle;
import tazadum.engine.rendering.LifeCycleManager;
import tazadum.engine.rendering.material.HasEmittance;
import tazadum.engine.rendering.material.Material;
import tazadum.engine.rendering.mesh.Mesh;
import tazadum.engine.rendering.shader.MaterialShader;
import tazadum.engine.rendering.shader.ShaderHelper;
import tazadum.engine.resource.ResourceManager;
import tazadum.engine.util.Logger;
import tazmania.scenes.building.BuildingMaterial;

public class WindowShader
implements LifeCycle,
MaterialShader,
HasEmittance {
    private static final String VERTEX_PROGRAM = "resources/shaders/textured.vertex.glsl";
    private static final String FRAGMENT_PROGRAM = "resources/shaders/windows.fragment.glsl";
    private final ResourceManager resourceManager;
    private int vertexShader;
    private int fragmentShader;
    private int program;
    private int locProjection;
    private int locView;
    private int locModel;
    private int locTexCoord0;
    private int locVertex;
    private int locSeed;
    private int locRatio;
    private int locBorder;
    private int locColor;
    private int locControl;
    private final float[] temp = new float[16];
    private boolean emittance = true;

    @Inject
    public WindowShader(LifeCycleManager lifeCycleManager, ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        lifeCycleManager.add(this);
    }

    @Override
    public void onInit(GL gL) {
        if (!gL.isGL2()) {
            System.out.println("GL2 not supported");
            return;
        }
        GL2 gL2 = gL.getGL2();
        byte[] byArray = this.resourceManager.load(VERTEX_PROGRAM);
        byte[] byArray2 = this.resourceManager.load(FRAGMENT_PROGRAM);
        this.vertexShader = ShaderHelper.compile(gL2, 35633, new String(byArray));
        this.fragmentShader = ShaderHelper.compile(gL2, 35632, new String(byArray2));
        this.program = gL2.glCreateProgram();
        gL2.glAttachShader(this.program, this.vertexShader);
        gL2.glAttachShader(this.program, this.fragmentShader);
        gL2.glLinkProgram(this.program);
        int[] nArray = new int[1];
        gL2.glGetProgramiv(this.program, 35714, nArray, 0);
        if (nArray[0] != 1) {
            Logger.log("Linking shader failed: %s", ShaderUtil.getProgramInfoLog((GL)gL2, (int)this.program));
            throw new IllegalArgumentException("Could not link program");
        }
        this.locVertex = gL2.glGetAttribLocation(this.program, "a_position");
        this.locTexCoord0 = gL2.glGetAttribLocation(this.program, "a_texCoord0");
        this.locSeed = gL2.glGetUniformLocation(this.program, "u_seed");
        this.locRatio = gL2.glGetUniformLocation(this.program, "u_ratio");
        this.locBorder = gL2.glGetUniformLocation(this.program, "u_border");
        this.locColor = gL2.glGetUniformLocation(this.program, "u_color");
        this.locControl = gL2.glGetUniformLocation(this.program, "u_control");
        this.locProjection = gL2.glGetUniformLocation(this.program, "u_projection");
        this.locView = gL2.glGetUniformLocation(this.program, "u_view");
        this.locModel = gL2.glGetUniformLocation(this.program, "u_model");
    }

    @Override
    public void onDeinit(GL gL) {
    }

    @Override
    public void enable(GL2 gL2) {
        gL2.glUseProgram(this.program);
    }

    @Override
    public void disable(GL2 gL2) {
        gL2.glUseProgram(0);
    }

    public void bindSeed(GL2 gL2, float f, float f2) {
        gL2.glUniform2f(this.locSeed, f, f2);
    }

    public void bindRatio(GL2 gL2, float f, float f2) {
        gL2.glUniform2f(this.locRatio, f, f2);
    }

    public void bindControl(GL2 gL2, float f, float f2) {
        gL2.glUniform2f(this.locControl, f, f2);
    }

    public void bindBorder(GL2 gL2, float f, float f2) {
        gL2.glUniform2f(this.locBorder, f, f2);
    }

    public void bindColor(GL2 gL2, float f, float f2, float f3) {
        gL2.glUniform3f(this.locColor, f, f2, f3);
    }

    @Override
    public void bindProjection(GL2 gL2, Matrix4f matrix4f) {
        matrix4f.fillFloatArray(this.temp, true);
        gL2.glUniformMatrix4fv(this.locProjection, 1, false, this.temp, 0);
    }

    @Override
    public void bindView(GL2 gL2, Matrix4f matrix4f) {
        matrix4f.fillFloatArray(this.temp, true);
        gL2.glUniformMatrix4fv(this.locView, 1, false, this.temp, 0);
    }

    @Override
    public void bindModel(GL2 gL2, Matrix4f matrix4f) {
        matrix4f.fillFloatArray(this.temp, true);
        gL2.glUniformMatrix4fv(this.locModel, 1, false, this.temp, 0);
    }

    public void bindVertices(GL2 gL2, FloatBuffer floatBuffer) {
        gL2.glEnableVertexAttribArray(this.locVertex);
        gL2.glVertexAttribPointer(this.locVertex, 3, 5126, false, 12, (Buffer)floatBuffer);
    }

    public void bindTextureCoords(GL2 gL2, FloatBuffer floatBuffer) {
        gL2.glEnableVertexAttribArray(this.locTexCoord0);
        gL2.glVertexAttribPointer(this.locTexCoord0, 2, 5126, false, 8, (Buffer)floatBuffer);
    }

    @Override
    public void populate(GL2 gL2, Material material, Mesh mesh) {
        BuildingMaterial buildingMaterial = (BuildingMaterial)material;
        float f = this.emittance ? buildingMaterial.getEmittance() : 1.0f;
        this.bindControl(gL2, buildingMaterial.getAlpha() * f, buildingMaterial.getHeight());
        this.bindColor(gL2, buildingMaterial.getAmbient().x, buildingMaterial.getAmbient().y, buildingMaterial.getAmbient().z);
        this.bindRatio(gL2, buildingMaterial.getRatio().x, buildingMaterial.getRatio().y);
        this.bindBorder(gL2, buildingMaterial.getBorder().x, buildingMaterial.getBorder().y);
        this.bindSeed(gL2, buildingMaterial.getSeed().x, buildingMaterial.getSeed().y);
        this.bindVertices(gL2, mesh.getVertices());
        this.bindTextureCoords(gL2, mesh.getTextureChoords());
    }

    @Override
    public void useEmittance(boolean bl) {
        this.emittance = bl;
    }
}

