/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.rendering.shader;

import com.jogamp.opengl.util.glsl.ShaderUtil;
import javax.inject.Inject;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import tazadum.engine.rendering.LifeCycle;
import tazadum.engine.rendering.LifeCycleManager;
import tazadum.engine.rendering.shader.ShaderHelper;
import tazadum.engine.resource.ResourceManager;
import tazadum.engine.util.Logger;

public class ParticleShader
implements LifeCycle {
    private final ResourceManager resourceManager;
    private int program;
    private int vertexShader;
    private int fragmentShader;

    @Inject
    public ParticleShader(LifeCycleManager lifeCycleManager, ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        lifeCycleManager.add(this);
    }

    @Override
    public void onInit(GL gL) {
        if (!gL.isGL2()) {
            System.out.println("GL2 not supported");
            return;
        }
        GL2 gL2 = gL.getGL2();
        byte[] byArray = this.resourceManager.load("shaders/particle.vertex.glsl");
        byte[] byArray2 = this.resourceManager.load("shaders/particle.fragment.glsl");
        this.vertexShader = ShaderHelper.compile(gL2, 35633, new String(byArray));
        this.fragmentShader = ShaderHelper.compile(gL2, 35632, new String(byArray2));
        this.program = gL2.glCreateProgram();
        gL2.glAttachShader(this.program, this.vertexShader);
        gL2.glAttachShader(this.program, this.fragmentShader);
        gL2.glLinkProgram(this.program);
        int[] nArray = new int[1];
        gL2.glGetProgramiv(this.program, 35714, nArray, 0);
        if (nArray[0] != 1) {
            Logger.log("Linking shader failed: %s", ShaderUtil.getProgramInfoLog((GL)gL2, (int)this.program));
            throw new IllegalArgumentException("Could not link program");
        }
    }

    @Override
    public void onDeinit(GL gL) {
    }
}

