/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.rendering.shader;

import com.jogamp.opengl.util.glsl.ShaderUtil;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import javax.inject.Inject;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import tazadum.engine.math.Matrix4f;
import tazadum.engine.rendering.LifeCycle;
import tazadum.engine.rendering.LifeCycleManager;
import tazadum.engine.rendering.material.Material;
import tazadum.engine.rendering.mesh.Mesh;
import tazadum.engine.rendering.shader.MaterialShader;
import tazadum.engine.rendering.shader.ShaderHelper;
import tazadum.engine.resource.ResourceManager;
import tazadum.engine.util.Logger;

public class LightShader
implements LifeCycle,
MaterialShader {
    private static final String VERTEX_PROGRAM = "resources/shaders/light.vertex.glsl";
    private static final String FRAGMENT_PROGRAM = "resources/shaders/light.fragment.glsl";
    private final ResourceManager resourceManager;
    private int vertexShader;
    private int fragmentShader;
    private int program;
    private int projectionLocation;
    private int viewLocation;
    private int modelLocation;
    private int vertexLocation;
    private int normalLocation;
    private final float[] temp = new float[16];

    @Inject
    public LightShader(LifeCycleManager lifeCycleManager, ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        lifeCycleManager.add(this);
    }

    @Override
    public void onInit(GL gL) {
        if (!gL.isGL2()) {
            System.out.println("GL2 not supported");
            return;
        }
        GL2 gL2 = gL.getGL2();
        byte[] byArray = this.resourceManager.load(VERTEX_PROGRAM);
        byte[] byArray2 = this.resourceManager.load(FRAGMENT_PROGRAM);
        this.vertexShader = ShaderHelper.compile(gL2, 35633, new String(byArray));
        this.fragmentShader = ShaderHelper.compile(gL2, 35632, new String(byArray2));
        this.program = gL2.glCreateProgram();
        gL2.glAttachShader(this.program, this.vertexShader);
        gL2.glAttachShader(this.program, this.fragmentShader);
        gL2.glLinkProgram(this.program);
        int[] nArray = new int[1];
        gL2.glGetProgramiv(this.program, 35714, nArray, 0);
        if (nArray[0] != 1) {
            Logger.log("Linking shader failed: %s", ShaderUtil.getProgramInfoLog((GL)gL2, (int)this.program));
            throw new IllegalArgumentException("Could not link program");
        }
        this.projectionLocation = gL2.glGetUniformLocation(this.program, "u_projection");
        this.viewLocation = gL2.glGetUniformLocation(this.program, "u_view");
        this.modelLocation = gL2.glGetUniformLocation(this.program, "u_model");
        this.vertexLocation = gL2.glGetAttribLocation(this.program, "a_position");
        this.normalLocation = gL2.glGetAttribLocation(this.program, "a_normal");
    }

    @Override
    public void onDeinit(GL gL) {
    }

    @Override
    public void enable(GL2 gL2) {
        gL2.glUseProgram(this.program);
    }

    @Override
    public void disable(GL2 gL2) {
        gL2.glUseProgram(0);
    }

    @Override
    public void bindProjection(GL2 gL2, Matrix4f matrix4f) {
        matrix4f.fillFloatArray(this.temp, true);
        gL2.glUniformMatrix4fv(this.projectionLocation, 1, false, this.temp, 0);
    }

    @Override
    public void bindView(GL2 gL2, Matrix4f matrix4f) {
        matrix4f.fillFloatArray(this.temp, true);
        gL2.glUniformMatrix4fv(this.viewLocation, 1, false, this.temp, 0);
    }

    @Override
    public void bindModel(GL2 gL2, Matrix4f matrix4f) {
        matrix4f.fillFloatArray(this.temp, true);
        gL2.glUniformMatrix4fv(this.modelLocation, 1, false, this.temp, 0);
    }

    public void bindVertices(GL2 gL2, FloatBuffer floatBuffer) {
        gL2.glEnableVertexAttribArray(this.vertexLocation);
        gL2.glVertexAttribPointer(this.vertexLocation, 3, 5126, false, 12, (Buffer)floatBuffer);
    }

    public void bindNormals(GL2 gL2, FloatBuffer floatBuffer) {
        gL2.glEnableVertexAttribArray(this.normalLocation);
        gL2.glVertexAttribPointer(this.normalLocation, 3, 5126, false, 12, (Buffer)floatBuffer);
    }

    @Override
    public void populate(GL2 gL2, Material material, Mesh mesh) {
        this.bindVertices(gL2, mesh.getVertices());
        this.bindNormals(gL2, mesh.getNormals());
    }
}

