/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.rendering.scenegraph;

import java.util.ArrayList;
import java.util.List;
import tazadum.engine.math.Matrix4f;

public class Node<T> {
    private final List<Node<T>> children = new ArrayList<Node<T>>();
    private final Matrix4f transform = new Matrix4f();
    private final Matrix4f matrix = new Matrix4f();
    private T data = null;
    private boolean enabled = true;

    public Node(T t) {
        this.data = t;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public boolean hasData() {
        return this.data != null;
    }

    public List<Node<T>> getChildren() {
        return this.children;
    }

    public void addChild(Node<T> node) {
        this.children.add(node);
    }

    public void addChild(T t) {
        this.children.add(new Node<T>(t));
    }

    public void removeChild(Node<T> node) {
        this.children.remove(node);
    }

    public Matrix4f getTransform() {
        return this.transform;
    }

    public Matrix4f getMatrix() {
        return this.matrix;
    }

    public T getData() {
        return this.data;
    }
}

