/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.rendering.mesh;

import com.jogamp.opengl.util.texture.Texture;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL2;
import tazadum.engine.asset.Asset;
import tazadum.engine.math.Box;
import tazadum.engine.rendering.mesh.TexturedMesh;

public class TexturedMeshImpl
implements TexturedMesh {
    private final Box boundingBox;
    private final FloatBuffer vertices;
    private final FloatBuffer normals;
    private final IntBuffer indices;
    private final FloatBuffer textureChoords;
    private final Asset<Texture> texture;

    public TexturedMeshImpl(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, IntBuffer intBuffer, FloatBuffer floatBuffer3, Asset<Texture> asset, Box box) {
        this.vertices = floatBuffer;
        this.normals = floatBuffer2;
        this.indices = intBuffer;
        this.textureChoords = floatBuffer3;
        this.texture = asset;
        this.boundingBox = box;
    }

    @Override
    public Box getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public FloatBuffer getVertices() {
        return this.vertices;
    }

    @Override
    public FloatBuffer getNormals() {
        return this.normals;
    }

    @Override
    public IntBuffer getIndices() {
        return this.indices;
    }

    @Override
    public FloatBuffer getTextureChoords() {
        return this.textureChoords;
    }

    @Override
    public Texture getTexture() {
        return this.texture.get();
    }

    public String toString() {
        return "TexturedMesh [" + this.boundingBox + "]";
    }

    @Override
    public void draw(GL2 gL2) {
        this.indices.rewind();
        gL2.glDrawElements(4, this.indices.capacity(), 5125, (Buffer)this.indices);
    }
}

