/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.rendering.layout;

import javax.inject.Inject;
import tazadum.engine.math.Box;
import tazadum.engine.math.Matrix4f;
import tazadum.engine.math.Vector2f;
import tazadum.engine.rendering.layout.NormalizedLayout;
import tazadum.engine.rendering.mesh.Mesh;

public class MeshLayout {
    private final NormalizedLayout normalizedLayout;

    @Inject
    public MeshLayout(NormalizedLayout normalizedLayout) {
        this.normalizedLayout = normalizedLayout;
    }

    public Matrix4f position(Mesh mesh, Vector2f vector2f, float f, Align align) {
        Box box = mesh.getBoundingBox();
        float f2 = this.normalizedLayout.horizontal(box.getWidth(), f);
        switch (align) {
            case Top: {
                break;
            }
            case Center: {
                vector2f.y += box.getHeight() / 2.0f;
                break;
            }
            case Bottom: {
                vector2f.y += box.getHeight();
            }
        }
        return this.positionAndScale(new Matrix4f(), vector2f, f2);
    }

    public Matrix4f positionAndScale(Matrix4f matrix4f, Vector2f vector2f, float f) {
        this.normalizedLayout.transformLocal(vector2f);
        Matrix4f matrix4f2 = new Matrix4f();
        matrix4f2.setTranslation(vector2f.x, vector2f.y, 0.0f);
        matrix4f.setScale(f, f, f);
        matrix4f.multLocal(matrix4f2);
        return matrix4f;
    }

    public static enum Align {
        Top,
        Center,
        Bottom;

    }
}

