/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.rendering.font;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.logging.Logger;
import javax.inject.Inject;
import tazadum.engine.asset.Asset;
import tazadum.engine.math.Box;
import tazadum.engine.math.Vector3f;
import tazadum.engine.memory.Buffers;
import tazadum.engine.rendering.font.Font;
import tazadum.engine.rendering.font.FontCharacter;
import tazadum.engine.rendering.font.FontSystem;
import tazadum.engine.rendering.mesh.TexturedMesh;
import tazadum.engine.rendering.mesh.TexturedMeshImpl;

public class FontSystemImpl
implements FontSystem {
    private static final Logger logger = Logger.getLogger(FontSystemImpl.class.getName());

    @Inject
    public FontSystemImpl() {
    }

    @Override
    public TexturedMesh createMesh(Asset<Font> asset, String string) {
        if (!asset.isLoaded()) {
            throw new IllegalStateException("Font not loaded for text " + string);
        }
        return this.createMesh(asset.get(), string);
    }

    @Override
    public TexturedMesh createMesh(Font font, String string) {
        Object object;
        int n;
        int n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            object = font.get(c);
            if (object == null) {
                logger.info("No character mapping found for '" + c + "'");
                continue;
            }
            ++n2;
        }
        n = n2 * 4;
        FloatBuffer floatBuffer = Buffers.allocateFloat(3 * n);
        object = Buffers.allocateInt(6 * n2);
        FloatBuffer floatBuffer2 = Buffers.allocateFloat(2 * n);
        float f = 0.0f;
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            FontCharacter fontCharacter = font.get(c);
            if (fontCharacter == null) continue;
            float[] fArray = fontCharacter.getVertices();
            for (int j = 0; j < fArray.length; j += 3) {
                floatBuffer.put(fArray[j] + f);
                floatBuffer.put(fArray, j + 1, 2);
            }
            int[] nArray = fontCharacter.getIndices();
            for (int j = 0; j < nArray.length; ++j) {
                ((IntBuffer)object).put(nArray[j] + n3);
            }
            floatBuffer2.put(fontCharacter.getTextures());
            f += fontCharacter.getAdvance();
            n3 += 4;
        }
        floatBuffer.rewind();
        floatBuffer2.rewind();
        ((IntBuffer)object).rewind();
        Box box = new Box(new Vector3f(), new Vector3f(f, font.getLineHeight(), 0.1f));
        return new TexturedMeshImpl(floatBuffer, null, (IntBuffer)object, floatBuffer2, font.getTexture(), box);
    }
}

