/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.rendering.font;

import com.jogamp.opengl.util.texture.Texture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import tazadum.engine.asset.Asset;
import tazadum.engine.rendering.font.Font;
import tazadum.engine.rendering.font.FontCharacter;

public class FontBuilder {
    private final Map<Character, FontCharacter> characters = new HashMap<Character, FontCharacter>();
    private Asset<Texture> texture;
    private int lineHeight;
    private int baseLine;
    private int textureWidth;
    private int textureHeight;

    public static Font create(Asset<Texture> asset, String string) {
        FontBuilder fontBuilder = new FontBuilder();
        fontBuilder.parse(string);
        fontBuilder.texture(asset);
        return fontBuilder.build();
    }

    public Font build() {
        return new Font(this.lineHeight, this.characters, this.texture);
    }

    public void texture(Asset<Texture> asset) {
        this.texture = asset;
    }

    public void parse(String string) {
        String[] stringArray;
        block10: for (String string2 : stringArray = string.split("[\n\r]+")) {
            List<String> list = this.tokenize(string2);
            if (list.isEmpty()) continue;
            switch (list.get(0)) {
                case "info": {
                    continue block10;
                }
                case "common": {
                    this.parseFontCommons(this.tomap(list));
                    continue block10;
                }
                case "char": {
                    this.parseCharacter(this.tomap(list));
                }
            }
        }
    }

    private void parseCharacter(Map<String, String> map) {
        int n = Integer.parseInt(map.get("id"));
        int n2 = Integer.parseInt(map.get("x"));
        int n3 = Integer.parseInt(map.get("y"));
        int n4 = Integer.parseInt(map.get("width"));
        int n5 = Integer.parseInt(map.get("height"));
        int n6 = Integer.parseInt(map.get("xoffset"));
        int n7 = Integer.parseInt(map.get("yoffset"));
        int n8 = Integer.parseInt(map.get("xadvance"));
        float f = 0 + n6;
        float f2 = f + (float)n4;
        float f3 = this.baseLine - n7;
        float f4 = f3 - (float)n5;
        float[] fArray = new float[]{f, f3, 0.0f, f, f4, 0.0f, f2, f3, 0.0f, f2, f4, 0.0f};
        float f5 = (float)n2 / (float)this.textureWidth;
        float f6 = (float)n3 / (float)this.textureHeight;
        float f7 = f5 + (float)n4 / (float)this.textureWidth;
        float f8 = f6 + (float)n5 / (float)this.textureHeight;
        float[] fArray2 = new float[]{f5, f6, f5, f8, f7, f6, f7, f8};
        int[] nArray = new int[]{0, 1, 2, 1, 3, 2};
        this.characters.put(Character.valueOf((char)n), new FontCharacter(n, n8, fArray, nArray, fArray2));
    }

    private void parseFontCommons(Map<String, String> map) {
        this.lineHeight = Integer.parseInt(map.get("lineheight"));
        this.baseLine = Integer.parseInt(map.get("base"));
        this.textureWidth = Integer.parseInt(map.get("scalew"));
        this.textureHeight = Integer.parseInt(map.get("scaleh"));
    }

    private Map<String, String> tomap(List<String> list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : list) {
            int n = string.indexOf(61);
            if (n <= 0) continue;
            String string2 = string.substring(0, n).toLowerCase();
            String string3 = string.substring(n + 1);
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    private List<String> tokenize(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ((this.countChar(string2, '\"') & 1) == 0) {
                arrayList.add(string2);
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                stringBuilder.append(' ').append(string3);
                if ((this.countChar(string3, '\"') & 1) != 1) continue;
                break;
            }
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    private int countChar(String string, char c) {
        int n = 0;
        int n2 = string.indexOf(c);
        while (n2 >= 0) {
            ++n;
            n2 = string.indexOf(c, n2 + 1);
        }
        return n;
    }
}

