/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.rendering.effect;

import com.google.inject.Inject;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import tazadum.engine.math.Rectangle;
import tazadum.engine.math.Vector4f;
import tazadum.engine.rendering.LifeCycle;
import tazadum.engine.rendering.LifeCycleManager;
import tazadum.engine.rendering.RenderEngine;
import tazadum.engine.rendering.effect.Effect;
import tazadum.engine.rendering.effect.FullscreenQuad;
import tazadum.engine.rendering.material.DefaultMaterial;
import tazadum.engine.rendering.material.Material;
import tazadum.engine.rendering.material.MaterialTransform;
import tazadum.engine.rendering.scenegraph.SceneGraph;
import tazadum.engine.rendering.shader.BlurShader;
import tazadum.engine.rendering.shader.SimpleShader;
import tazadum.engine.rendering.target.FBORenderTarget;

public class BlurEffect
implements Effect,
LifeCycle {
    private final BlurShader shader;
    private final RenderEngine renderEngine;
    private final FullscreenQuad quad;
    private FBORenderTarget verticalFBO;
    private FBORenderTarget horizontalFBO;
    private boolean additive = true;
    private boolean doubleBlur = false;
    private MaterialTransform emittanceMapper;
    private int width;
    private int height;

    @Inject
    public BlurEffect(LifeCycleManager lifeCycleManager, RenderEngine renderEngine, BlurShader blurShader, SimpleShader simpleShader) {
        this.renderEngine = renderEngine;
        this.shader = blurShader;
        this.quad = new FullscreenQuad(1.0f);
        lifeCycleManager.add(this);
        final DefaultMaterial defaultMaterial = new DefaultMaterial(simpleShader);
        defaultMaterial.setAmbient(Vector4f.ZERO);
        defaultMaterial.setDiffuse(Vector4f.ZERO);
        defaultMaterial.setSpecular(Vector4f.ZERO);
        defaultMaterial.setPriority(0);
        this.emittanceMapper = new MaterialTransform(){

            @Override
            public Material map(Material material) {
                if (material.getEmittance() > 0.0f) {
                    return material;
                }
                return defaultMaterial;
            }
        };
    }

    public boolean isDoubleBlur() {
        return this.doubleBlur;
    }

    public void setDoubleBlur(boolean bl) {
        this.doubleBlur = bl;
    }

    public boolean isAdditive() {
        return this.additive;
    }

    public void setAdditive(boolean bl) {
        this.additive = bl;
    }

    @Override
    public void onInit(GL gL) {
        Rectangle rectangle = this.renderEngine.getArea();
        this.width = (int)(rectangle.width / 4.0f);
        this.height = (int)(rectangle.height / 4.0f);
        this.verticalFBO = new FBORenderTarget(this.width, this.height);
        this.horizontalFBO = new FBORenderTarget(this.width, this.height);
        this.verticalFBO.onInit(gL);
        this.horizontalFBO.onInit(gL);
    }

    @Override
    public void onDeinit(GL gL) {
        this.verticalFBO.onDeinit(gL);
        this.horizontalFBO.onDeinit(gL);
    }

    @Override
    public void onPreRender(GL2 gL2, float f, float f2) {
        SceneGraph sceneGraph = this.renderEngine.getSceneGraph();
        this.verticalFBO.enable((GL)gL2);
        gL2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gL2.glClear(16640);
        sceneGraph.render(gL2, this.renderEngine.getCamera(), this.emittanceMapper, true);
        this.horizontalFBO.enable((GL)gL2);
        gL2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gL2.glClear(16640);
        this.shader.enable(gL2);
        this.shader.bindSize(gL2, this.width);
        this.shader.bindDirection(gL2, 1.0f, 0.0f);
        this.shader.bindVertices(gL2, this.quad.getVertexBuffer());
        this.shader.bindTextureCoords(gL2, this.quad.getTextureBuffer());
        this.shader.bindTexture0(gL2, this.verticalFBO.getTextureId());
        this.quad.draw((GL)gL2);
        if (this.doubleBlur) {
            this.verticalFBO.enable((GL)gL2);
            gL2.glClear(256);
            this.shader.bindTexture0(gL2, this.horizontalFBO.getTextureId());
            this.shader.bindSize(gL2, this.height);
            this.quad.draw((GL)gL2);
            this.horizontalFBO.enable((GL)gL2);
            gL2.glClear(256);
            this.shader.bindTexture0(gL2, this.verticalFBO.getTextureId());
            this.shader.bindSize(gL2, this.width);
            this.quad.draw((GL)gL2);
        }
    }

    @Override
    public void onPostRender(GL2 gL2, float f, float f2) {
        gL2.glDisable(2929);
        gL2.glEnable(3042);
        if (this.additive) {
            gL2.glBlendFunc(1, 1);
        } else {
            gL2.glBlendFunc(770, 771);
        }
        this.shader.enable(gL2);
        this.shader.bindSize(gL2, this.height);
        this.shader.bindDirection(gL2, 0.0f, 1.0f);
        this.shader.bindVertices(gL2, this.quad.getVertexBuffer());
        this.shader.bindTextureCoords(gL2, this.quad.getTextureBuffer());
        this.shader.bindTexture0(gL2, this.horizontalFBO.getTextureId());
        this.quad.draw((GL)gL2);
        gL2.glDisable(3042);
        gL2.glEnable(2929);
    }
}

