/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.rendering.camera;

import tazadum.engine.math.Matrix4f;
import tazadum.engine.math.Rectangle;
import tazadum.engine.math.Vector3f;
import tazadum.engine.rendering.camera.Camera;
import tazadum.engine.rendering.camera.OrthographicCamera;

public class DefaultOrthographicCamera
implements OrthographicCamera {
    private final Vector3f position = new Vector3f();
    private final Matrix4f projection = new Matrix4f();
    private final Matrix4f view = new Matrix4f();
    private final Matrix4f transform = new Matrix4f();
    private Rectangle bounds;

    public DefaultOrthographicCamera(float f, float f2, float f3, float f4, float f5, float f6) {
        this.configure(f, f2, f3, f4, f5, f6);
    }

    @Override
    public OrthographicCamera configure(float f, float f2, float f3, float f4, float f5, float f6) {
        this.bounds = new Rectangle(Math.min(f4, f3), Math.min(f5, f6), Math.abs(f3 - f4), Math.abs(f6 - f5));
        this.projection.fromFrustum(f, f2, f4, f3, f5, f6, true);
        this.update();
        return this;
    }

    @Override
    public DefaultOrthographicCamera moveTo(Vector3f vector3f) {
        this.position.set(vector3f);
        return this;
    }

    @Override
    public DefaultOrthographicCamera lookAt(Vector3f vector3f, Vector3f vector3f2) {
        return this;
    }

    @Override
    public Camera lookIn(Vector3f vector3f, Vector3f vector3f2) {
        return this;
    }

    @Override
    public void update() {
        this.view.loadIdentity();
        this.view.m00 = 1.0f;
        this.view.m01 = 0.0f;
        this.view.m02 = 0.0f;
        this.view.m10 = 0.0f;
        this.view.m11 = 1.0f;
        this.view.m12 = 0.0f;
        this.view.m20 = 0.0f;
        this.view.m21 = 0.0f;
        this.view.m22 = -1.0f;
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.m03 = -this.position.x;
        matrix4f.m13 = -this.position.y;
        matrix4f.m23 = -this.position.z;
        this.view.multLocal(matrix4f);
        this.transform.set(this.projection).multLocal(this.view);
    }

    @Override
    public Vector3f getPosition() {
        return this.position;
    }

    @Override
    public Vector3f getDirection() {
        return Vector3f.UNIT_Z;
    }

    @Override
    public Matrix4f getTransform() {
        return this.transform;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public Matrix4f getProjection() {
        return this.projection;
    }

    @Override
    public Matrix4f getView() {
        return this.view;
    }
}

