/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.rendering.camera;

import tazadum.engine.math.Matrix4f;
import tazadum.engine.math.Quaternion;
import tazadum.engine.math.Vector3f;
import tazadum.engine.rendering.camera.Camera;

public class DefaultCamera
implements Camera {
    private final Vector3f position = new Vector3f();
    private final Vector3f direction = new Vector3f();
    private final Vector3f up;
    private final Vector3f left;
    private final Quaternion rotation = new Quaternion();
    private final Matrix4f projection;
    private final Matrix4f view;
    private final Matrix4f transform;

    public DefaultCamera(float f, float f2, float f3, float f4, float f5, float f6) {
        this.up = new Vector3f();
        this.left = new Vector3f();
        this.projection = new Matrix4f();
        this.view = new Matrix4f();
        this.transform = new Matrix4f();
        this.projection.fromFrustum(f, f2, f4, f3, f5, f6, false);
    }

    @Override
    public DefaultCamera moveTo(Vector3f vector3f) {
        this.position.set(vector3f);
        return this;
    }

    @Override
    public DefaultCamera lookAt(Vector3f vector3f, Vector3f vector3f2) {
        vector3f2.subtract(this.position, this.direction).normalizeLocal();
        this.up.set(vector3f).normalizeLocal();
        if (this.up.equals(Vector3f.ZERO)) {
            this.up.set(Vector3f.UNIT_Y);
        }
        return this;
    }

    @Override
    public DefaultCamera lookIn(Vector3f vector3f, Vector3f vector3f2) {
        this.direction.set(vector3f2.normalizeLocal());
        this.up.set(vector3f).normalizeLocal();
        if (this.up.equals(Vector3f.ZERO)) {
            this.up.set(Vector3f.UNIT_Y);
        }
        return this;
    }

    @Override
    public void update() {
        this.left.set(this.up).crossLocal(this.direction).normalizeLocal();
        if (this.left.equals(Vector3f.ZERO)) {
            if (this.direction.x != 0.0f) {
                this.left.set(this.direction.y, -this.direction.x, 0.0f);
            } else {
                this.left.set(0.0f, this.direction.z, -this.direction.y);
            }
        }
        this.up.set(this.direction).crossLocal(this.left).normalizeLocal();
        this.rotation.fromAxes(this.left, this.up, this.direction);
        this.rotation.normalizeLocal();
        this.view.fromFrame(this.position, this.direction, this.up, this.left);
        this.transform.set(this.projection).multLocal(this.view);
    }

    @Override
    public Vector3f getPosition() {
        return this.position;
    }

    @Override
    public Vector3f getDirection() {
        return this.direction;
    }

    @Override
    public Matrix4f getTransform() {
        return this.transform;
    }

    @Override
    public Matrix4f getProjection() {
        return this.projection;
    }

    @Override
    public Matrix4f getView() {
        return this.view;
    }
}

