/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.rendering;

import java.util.EnumMap;
import java.util.Map;
import javax.media.opengl.GL;
import tazadum.engine.rendering.State;

public class RenderState {
    private final Map<State, Integer> enabled = new EnumMap<State, Integer>(State.class);

    public void enable(State state) {
        this.enabled.put(state, 1);
    }

    public void disable(State state) {
        this.enabled.remove((Object)state);
    }

    public void set(State state, int n) {
        this.enabled.put(state, n);
    }

    public int get(State state) {
        if (!this.enabled.containsKey((Object)state)) {
            return 0;
        }
        return this.enabled.get((Object)state);
    }

    public int calculateDiff(RenderState renderState) {
        int n = 0;
        for (State state : State.values()) {
            n += this.get(state) != renderState.get(state) ? 1 : 0;
        }
        return n;
    }

    public void applyDiff(GL gL, RenderState renderState) {
        for (State state : State.values()) {
            int n = renderState.get(state);
            if (this.get(state) == n) continue;
            if (n == 0) {
                gL.glDisable(state.getGLConst());
                continue;
            }
            gL.glEnable(state.getGLConst());
        }
    }
}

