/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.parameter;

import tazadum.engine.math.Vector3f;
import tazadum.engine.math.easein.EaseIn;
import tazadum.engine.parameter.Parameter;

public class TweenVector3Parameter
implements Parameter<Vector3f> {
    private EaseIn easeIn = EaseIn.LINEAR;
    private EaseIn.Mode mode = EaseIn.Mode.IN;
    private Vector3f from = new Vector3f();
    private Vector3f to = new Vector3f();
    private float start;
    private float duration;

    public float getStart() {
        return this.start;
    }

    public void setStart(float f) {
        this.start = f;
    }

    public float getDuration() {
        return this.duration;
    }

    public void setDuration(float f) {
        this.duration = f;
    }

    public Vector3f getFrom() {
        return this.from;
    }

    public void setFrom(Vector3f vector3f) {
        this.from = vector3f;
    }

    public Vector3f getTo() {
        return this.to;
    }

    public void setTo(Vector3f vector3f) {
        this.to = vector3f;
    }

    public EaseIn.Mode getMode() {
        return this.mode;
    }

    public void setMode(EaseIn.Mode mode) {
        this.mode = mode;
    }

    public EaseIn getEaseIn() {
        return this.easeIn;
    }

    public void setEaseIn(EaseIn easeIn) {
        this.easeIn = easeIn;
    }

    @Override
    public Vector3f get(float f) {
        if (f <= this.start) {
            return this.from;
        }
        if (f >= this.start + this.duration) {
            return this.to;
        }
        float f2 = this.mode.get(this.easeIn, f - this.start, this.from.x, this.to.x - this.from.x, this.duration);
        float f3 = this.mode.get(this.easeIn, f - this.start, this.from.y, this.to.y - this.from.y, this.duration);
        float f4 = this.mode.get(this.easeIn, f - this.start, this.from.z, this.to.z - this.from.z, this.duration);
        return new Vector3f(f2, f3, f4);
    }

    @Override
    public void initialize() {
    }
}

