/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.math;

import java.nio.FloatBuffer;
import java.util.logging.Logger;
import tazadum.engine.math.BufferUtils;
import tazadum.engine.math.FastMath;
import tazadum.engine.math.Matrix3f;
import tazadum.engine.math.Quaternion;
import tazadum.engine.math.TempVars;
import tazadum.engine.math.Vector3f;
import tazadum.engine.math.Vector4f;

public final class Matrix4f {
    private static final Logger logger = Logger.getLogger(Matrix4f.class.getName());
    public float m00;
    public float m01;
    public float m02;
    public float m03;
    public float m10;
    public float m11;
    public float m12;
    public float m13;
    public float m20;
    public float m21;
    public float m22;
    public float m23;
    public float m30;
    public float m31;
    public float m32;
    public float m33;
    public static final Matrix4f ZERO = new Matrix4f(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    public static final Matrix4f IDENTITY = new Matrix4f();

    public Matrix4f() {
        this.loadIdentity();
    }

    public Matrix4f(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.m00 = f;
        this.m01 = f2;
        this.m02 = f3;
        this.m03 = f4;
        this.m10 = f5;
        this.m11 = f6;
        this.m12 = f7;
        this.m13 = f8;
        this.m20 = f9;
        this.m21 = f10;
        this.m22 = f11;
        this.m23 = f12;
        this.m30 = f13;
        this.m31 = f14;
        this.m32 = f15;
        this.m33 = f16;
    }

    public Matrix4f(float[] fArray) {
        this.set(fArray, false);
    }

    public Matrix4f(Matrix4f matrix4f) {
        this.copy(matrix4f);
    }

    public void copy(Matrix4f matrix4f) {
        if (null == matrix4f) {
            this.loadIdentity();
        } else {
            this.m00 = matrix4f.m00;
            this.m01 = matrix4f.m01;
            this.m02 = matrix4f.m02;
            this.m03 = matrix4f.m03;
            this.m10 = matrix4f.m10;
            this.m11 = matrix4f.m11;
            this.m12 = matrix4f.m12;
            this.m13 = matrix4f.m13;
            this.m20 = matrix4f.m20;
            this.m21 = matrix4f.m21;
            this.m22 = matrix4f.m22;
            this.m23 = matrix4f.m23;
            this.m30 = matrix4f.m30;
            this.m31 = matrix4f.m31;
            this.m32 = matrix4f.m32;
            this.m33 = matrix4f.m33;
        }
    }

    public void fromFrame(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
        this.loadIdentity();
        TempVars tempVars = TempVars.get();
        Vector3f vector3f5 = tempVars.vect1.set(vector3f2);
        Vector3f vector3f6 = tempVars.vect2.set(vector3f5).crossLocal(vector3f3);
        Vector3f vector3f7 = tempVars.vect3.set(vector3f6).crossLocal(vector3f5);
        this.m00 = vector3f6.x;
        this.m01 = vector3f6.y;
        this.m02 = vector3f6.z;
        this.m10 = vector3f7.x;
        this.m11 = vector3f7.y;
        this.m12 = vector3f7.z;
        this.m20 = -vector3f5.x;
        this.m21 = -vector3f5.y;
        this.m22 = -vector3f5.z;
        Matrix4f matrix4f = tempVars.tempMat4;
        matrix4f.loadIdentity();
        matrix4f.m03 = -vector3f.x;
        matrix4f.m13 = -vector3f.y;
        matrix4f.m23 = -vector3f.z;
        this.multLocal(matrix4f);
        tempVars.release();
    }

    public void get(float[] fArray) {
        this.get(fArray, true);
    }

    public void get(float[] fArray, boolean bl) {
        if (fArray.length != 16) {
            throw new IllegalArgumentException("Array must be of size 16.");
        }
        if (bl) {
            fArray[0] = this.m00;
            fArray[1] = this.m01;
            fArray[2] = this.m02;
            fArray[3] = this.m03;
            fArray[4] = this.m10;
            fArray[5] = this.m11;
            fArray[6] = this.m12;
            fArray[7] = this.m13;
            fArray[8] = this.m20;
            fArray[9] = this.m21;
            fArray[10] = this.m22;
            fArray[11] = this.m23;
            fArray[12] = this.m30;
            fArray[13] = this.m31;
            fArray[14] = this.m32;
            fArray[15] = this.m33;
        } else {
            fArray[0] = this.m00;
            fArray[4] = this.m01;
            fArray[8] = this.m02;
            fArray[12] = this.m03;
            fArray[1] = this.m10;
            fArray[5] = this.m11;
            fArray[9] = this.m12;
            fArray[13] = this.m13;
            fArray[2] = this.m20;
            fArray[6] = this.m21;
            fArray[10] = this.m22;
            fArray[14] = this.m23;
            fArray[3] = this.m30;
            fArray[7] = this.m31;
            fArray[11] = this.m32;
            fArray[15] = this.m33;
        }
    }

    public float get(int n, int n2) {
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                    case 2: {
                        return this.m02;
                    }
                    case 3: {
                        return this.m03;
                    }
                }
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m12;
                    }
                    case 3: {
                        return this.m13;
                    }
                }
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        return this.m20;
                    }
                    case 1: {
                        return this.m21;
                    }
                    case 2: {
                        return this.m22;
                    }
                    case 3: {
                        return this.m23;
                    }
                }
            }
            case 3: {
                switch (n2) {
                    case 0: {
                        return this.m30;
                    }
                    case 1: {
                        return this.m31;
                    }
                    case 2: {
                        return this.m32;
                    }
                    case 3: {
                        return this.m33;
                    }
                }
            }
        }
        logger.warning("Invalid matrix index.");
        throw new IllegalArgumentException("Invalid indices into matrix.");
    }

    public float[] getColumn(int n) {
        return this.getColumn(n, null);
    }

    public float[] getColumn(int n, float[] fArray) {
        if (fArray == null) {
            fArray = new float[4];
        }
        switch (n) {
            case 0: {
                fArray[0] = this.m00;
                fArray[1] = this.m10;
                fArray[2] = this.m20;
                fArray[3] = this.m30;
                break;
            }
            case 1: {
                fArray[0] = this.m01;
                fArray[1] = this.m11;
                fArray[2] = this.m21;
                fArray[3] = this.m31;
                break;
            }
            case 2: {
                fArray[0] = this.m02;
                fArray[1] = this.m12;
                fArray[2] = this.m22;
                fArray[3] = this.m32;
                break;
            }
            case 3: {
                fArray[0] = this.m03;
                fArray[1] = this.m13;
                fArray[2] = this.m23;
                fArray[3] = this.m33;
                break;
            }
            default: {
                logger.warning("Invalid column index.");
                throw new IllegalArgumentException("Invalid column index. " + n);
            }
        }
        return fArray;
    }

    public void setColumn(int n, float[] fArray) {
        if (fArray == null) {
            logger.warning("Column is null. Ignoring.");
            return;
        }
        switch (n) {
            case 0: {
                this.m00 = fArray[0];
                this.m10 = fArray[1];
                this.m20 = fArray[2];
                this.m30 = fArray[3];
                break;
            }
            case 1: {
                this.m01 = fArray[0];
                this.m11 = fArray[1];
                this.m21 = fArray[2];
                this.m31 = fArray[3];
                break;
            }
            case 2: {
                this.m02 = fArray[0];
                this.m12 = fArray[1];
                this.m22 = fArray[2];
                this.m32 = fArray[3];
                break;
            }
            case 3: {
                this.m03 = fArray[0];
                this.m13 = fArray[1];
                this.m23 = fArray[2];
                this.m33 = fArray[3];
                break;
            }
            default: {
                logger.warning("Invalid column index.");
                throw new IllegalArgumentException("Invalid column index. " + n);
            }
        }
    }

    public void set(int n, int n2, float f) {
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        this.m00 = f;
                        return;
                    }
                    case 1: {
                        this.m01 = f;
                        return;
                    }
                    case 2: {
                        this.m02 = f;
                        return;
                    }
                    case 3: {
                        this.m03 = f;
                        return;
                    }
                }
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        this.m10 = f;
                        return;
                    }
                    case 1: {
                        this.m11 = f;
                        return;
                    }
                    case 2: {
                        this.m12 = f;
                        return;
                    }
                    case 3: {
                        this.m13 = f;
                        return;
                    }
                }
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        this.m20 = f;
                        return;
                    }
                    case 1: {
                        this.m21 = f;
                        return;
                    }
                    case 2: {
                        this.m22 = f;
                        return;
                    }
                    case 3: {
                        this.m23 = f;
                        return;
                    }
                }
            }
            case 3: {
                switch (n2) {
                    case 0: {
                        this.m30 = f;
                        return;
                    }
                    case 1: {
                        this.m31 = f;
                        return;
                    }
                    case 2: {
                        this.m32 = f;
                        return;
                    }
                    case 3: {
                        this.m33 = f;
                        return;
                    }
                }
            }
        }
        logger.warning("Invalid matrix index.");
        throw new IllegalArgumentException("Invalid indices into matrix.");
    }

    public void set(float[][] fArray) {
        if (fArray.length != 4 || fArray[0].length != 4) {
            throw new IllegalArgumentException("Array must be of size 16.");
        }
        this.m00 = fArray[0][0];
        this.m01 = fArray[0][1];
        this.m02 = fArray[0][2];
        this.m03 = fArray[0][3];
        this.m10 = fArray[1][0];
        this.m11 = fArray[1][1];
        this.m12 = fArray[1][2];
        this.m13 = fArray[1][3];
        this.m20 = fArray[2][0];
        this.m21 = fArray[2][1];
        this.m22 = fArray[2][2];
        this.m23 = fArray[2][3];
        this.m30 = fArray[3][0];
        this.m31 = fArray[3][1];
        this.m32 = fArray[3][2];
        this.m33 = fArray[3][3];
    }

    public Matrix4f set(Matrix4f matrix4f) {
        this.m00 = matrix4f.m00;
        this.m01 = matrix4f.m01;
        this.m02 = matrix4f.m02;
        this.m03 = matrix4f.m03;
        this.m10 = matrix4f.m10;
        this.m11 = matrix4f.m11;
        this.m12 = matrix4f.m12;
        this.m13 = matrix4f.m13;
        this.m20 = matrix4f.m20;
        this.m21 = matrix4f.m21;
        this.m22 = matrix4f.m22;
        this.m23 = matrix4f.m23;
        this.m30 = matrix4f.m30;
        this.m31 = matrix4f.m31;
        this.m32 = matrix4f.m32;
        this.m33 = matrix4f.m33;
        return this;
    }

    public void set(float[] fArray) {
        this.set(fArray, true);
    }

    public void set(float[] fArray, boolean bl) {
        if (fArray.length != 16) {
            throw new IllegalArgumentException("Array must be of size 16.");
        }
        if (bl) {
            this.m00 = fArray[0];
            this.m01 = fArray[1];
            this.m02 = fArray[2];
            this.m03 = fArray[3];
            this.m10 = fArray[4];
            this.m11 = fArray[5];
            this.m12 = fArray[6];
            this.m13 = fArray[7];
            this.m20 = fArray[8];
            this.m21 = fArray[9];
            this.m22 = fArray[10];
            this.m23 = fArray[11];
            this.m30 = fArray[12];
            this.m31 = fArray[13];
            this.m32 = fArray[14];
            this.m33 = fArray[15];
        } else {
            this.m00 = fArray[0];
            this.m01 = fArray[4];
            this.m02 = fArray[8];
            this.m03 = fArray[12];
            this.m10 = fArray[1];
            this.m11 = fArray[5];
            this.m12 = fArray[9];
            this.m13 = fArray[13];
            this.m20 = fArray[2];
            this.m21 = fArray[6];
            this.m22 = fArray[10];
            this.m23 = fArray[14];
            this.m30 = fArray[3];
            this.m31 = fArray[7];
            this.m32 = fArray[11];
            this.m33 = fArray[15];
        }
    }

    public Matrix4f transpose() {
        float[] fArray = new float[16];
        this.get(fArray, true);
        Matrix4f matrix4f = new Matrix4f(fArray);
        return matrix4f;
    }

    public Matrix4f transposeLocal() {
        float f = this.m01;
        this.m01 = this.m10;
        this.m10 = f;
        f = this.m02;
        this.m02 = this.m20;
        this.m20 = f;
        f = this.m03;
        this.m03 = this.m30;
        this.m30 = f;
        f = this.m12;
        this.m12 = this.m21;
        this.m21 = f;
        f = this.m13;
        this.m13 = this.m31;
        this.m31 = f;
        f = this.m23;
        this.m23 = this.m32;
        this.m32 = f;
        return this;
    }

    public FloatBuffer toFloatBuffer() {
        return this.toFloatBuffer(false);
    }

    public FloatBuffer toFloatBuffer(boolean bl) {
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(16);
        this.fillFloatBuffer(floatBuffer, bl);
        floatBuffer.rewind();
        return floatBuffer;
    }

    public FloatBuffer fillFloatBuffer(FloatBuffer floatBuffer) {
        return this.fillFloatBuffer(floatBuffer, false);
    }

    public FloatBuffer fillFloatBuffer(FloatBuffer floatBuffer, boolean bl) {
        if (bl) {
            floatBuffer.put(this.m00).put(this.m10).put(this.m20).put(this.m30);
            floatBuffer.put(this.m01).put(this.m11).put(this.m21).put(this.m31);
            floatBuffer.put(this.m02).put(this.m12).put(this.m22).put(this.m32);
            floatBuffer.put(this.m03).put(this.m13).put(this.m23).put(this.m33);
        } else {
            floatBuffer.put(this.m00).put(this.m01).put(this.m02).put(this.m03);
            floatBuffer.put(this.m10).put(this.m11).put(this.m12).put(this.m13);
            floatBuffer.put(this.m20).put(this.m21).put(this.m22).put(this.m23);
            floatBuffer.put(this.m30).put(this.m31).put(this.m32).put(this.m33);
        }
        return floatBuffer;
    }

    public void fillFloatArray(float[] fArray, boolean bl) {
        if (bl) {
            fArray[0] = this.m00;
            fArray[1] = this.m10;
            fArray[2] = this.m20;
            fArray[3] = this.m30;
            fArray[4] = this.m01;
            fArray[5] = this.m11;
            fArray[6] = this.m21;
            fArray[7] = this.m31;
            fArray[8] = this.m02;
            fArray[9] = this.m12;
            fArray[10] = this.m22;
            fArray[11] = this.m32;
            fArray[12] = this.m03;
            fArray[13] = this.m13;
            fArray[14] = this.m23;
            fArray[15] = this.m33;
        } else {
            fArray[0] = this.m00;
            fArray[1] = this.m01;
            fArray[2] = this.m02;
            fArray[3] = this.m03;
            fArray[4] = this.m10;
            fArray[5] = this.m11;
            fArray[6] = this.m12;
            fArray[7] = this.m13;
            fArray[8] = this.m20;
            fArray[9] = this.m21;
            fArray[10] = this.m22;
            fArray[11] = this.m23;
            fArray[12] = this.m30;
            fArray[13] = this.m31;
            fArray[14] = this.m32;
            fArray[15] = this.m33;
        }
    }

    public Matrix4f readFloatBuffer(FloatBuffer floatBuffer) {
        return this.readFloatBuffer(floatBuffer, false);
    }

    public Matrix4f readFloatBuffer(FloatBuffer floatBuffer, boolean bl) {
        if (bl) {
            this.m00 = floatBuffer.get();
            this.m10 = floatBuffer.get();
            this.m20 = floatBuffer.get();
            this.m30 = floatBuffer.get();
            this.m01 = floatBuffer.get();
            this.m11 = floatBuffer.get();
            this.m21 = floatBuffer.get();
            this.m31 = floatBuffer.get();
            this.m02 = floatBuffer.get();
            this.m12 = floatBuffer.get();
            this.m22 = floatBuffer.get();
            this.m32 = floatBuffer.get();
            this.m03 = floatBuffer.get();
            this.m13 = floatBuffer.get();
            this.m23 = floatBuffer.get();
            this.m33 = floatBuffer.get();
        } else {
            this.m00 = floatBuffer.get();
            this.m01 = floatBuffer.get();
            this.m02 = floatBuffer.get();
            this.m03 = floatBuffer.get();
            this.m10 = floatBuffer.get();
            this.m11 = floatBuffer.get();
            this.m12 = floatBuffer.get();
            this.m13 = floatBuffer.get();
            this.m20 = floatBuffer.get();
            this.m21 = floatBuffer.get();
            this.m22 = floatBuffer.get();
            this.m23 = floatBuffer.get();
            this.m30 = floatBuffer.get();
            this.m31 = floatBuffer.get();
            this.m32 = floatBuffer.get();
            this.m33 = floatBuffer.get();
        }
        return this;
    }

    public void loadIdentity() {
        this.m03 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        this.m13 = 0.0f;
        this.m12 = 0.0f;
        this.m10 = 0.0f;
        this.m23 = 0.0f;
        this.m21 = 0.0f;
        this.m20 = 0.0f;
        this.m32 = 0.0f;
        this.m31 = 0.0f;
        this.m30 = 0.0f;
        this.m33 = 1.0f;
        this.m22 = 1.0f;
        this.m11 = 1.0f;
        this.m00 = 1.0f;
    }

    public void fromFrustum(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        this.loadIdentity();
        if (bl) {
            this.m00 = 2.0f / (f4 - f3);
            this.m11 = 2.0f / (f5 - f6);
            this.m22 = -2.0f / (f2 - f);
            this.m33 = 1.0f;
            this.m03 = -(f4 + f3) / (f4 - f3);
            this.m13 = -(f5 + f6) / (f5 - f6);
            this.m23 = -(f2 + f) / (f2 - f);
        } else {
            this.m00 = 2.0f * f / (f4 - f3);
            this.m11 = 2.0f * f / (f5 - f6);
            this.m32 = -1.0f;
            this.m33 = -0.0f;
            this.m02 = (f4 + f3) / (f4 - f3);
            this.m12 = (f5 + f6) / (f5 - f6);
            this.m22 = -(f2 + f) / (f2 - f);
            this.m23 = -(2.0f * f2 * f) / (f2 - f);
        }
    }

    public void fromAngleAxis(float f, Vector3f vector3f) {
        Vector3f vector3f2 = vector3f.normalize();
        this.fromAngleNormalAxis(f, vector3f2);
    }

    public void fromAngleNormalAxis(float f, Vector3f vector3f) {
        this.zero();
        this.m33 = 1.0f;
        float f2 = FastMath.cos(f);
        float f3 = FastMath.sin(f);
        float f4 = 1.0f - f2;
        float f5 = vector3f.x * vector3f.x;
        float f6 = vector3f.y * vector3f.y;
        float f7 = vector3f.z * vector3f.z;
        float f8 = vector3f.x * vector3f.y * f4;
        float f9 = vector3f.x * vector3f.z * f4;
        float f10 = vector3f.y * vector3f.z * f4;
        float f11 = vector3f.x * f3;
        float f12 = vector3f.y * f3;
        float f13 = vector3f.z * f3;
        this.m00 = f5 * f4 + f2;
        this.m01 = f8 - f13;
        this.m02 = f9 + f12;
        this.m10 = f8 + f13;
        this.m11 = f6 * f4 + f2;
        this.m12 = f10 - f11;
        this.m20 = f9 - f12;
        this.m21 = f10 + f11;
        this.m22 = f7 * f4 + f2;
    }

    public void multLocal(float f) {
        this.m00 *= f;
        this.m01 *= f;
        this.m02 *= f;
        this.m03 *= f;
        this.m10 *= f;
        this.m11 *= f;
        this.m12 *= f;
        this.m13 *= f;
        this.m20 *= f;
        this.m21 *= f;
        this.m22 *= f;
        this.m23 *= f;
        this.m30 *= f;
        this.m31 *= f;
        this.m32 *= f;
        this.m33 *= f;
    }

    public Matrix4f mult(float f) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.set(this);
        matrix4f.multLocal(f);
        return matrix4f;
    }

    public Matrix4f mult(float f, Matrix4f matrix4f) {
        matrix4f.set(this);
        matrix4f.multLocal(f);
        return matrix4f;
    }

    public Matrix4f mult(Matrix4f matrix4f) {
        return this.mult(matrix4f, null);
    }

    public Matrix4f mult(Matrix4f matrix4f, Matrix4f matrix4f2) {
        if (matrix4f2 == null) {
            matrix4f2 = new Matrix4f();
        }
        float f = this.m00 * matrix4f.m00 + this.m01 * matrix4f.m10 + this.m02 * matrix4f.m20 + this.m03 * matrix4f.m30;
        float f2 = this.m00 * matrix4f.m01 + this.m01 * matrix4f.m11 + this.m02 * matrix4f.m21 + this.m03 * matrix4f.m31;
        float f3 = this.m00 * matrix4f.m02 + this.m01 * matrix4f.m12 + this.m02 * matrix4f.m22 + this.m03 * matrix4f.m32;
        float f4 = this.m00 * matrix4f.m03 + this.m01 * matrix4f.m13 + this.m02 * matrix4f.m23 + this.m03 * matrix4f.m33;
        float f5 = this.m10 * matrix4f.m00 + this.m11 * matrix4f.m10 + this.m12 * matrix4f.m20 + this.m13 * matrix4f.m30;
        float f6 = this.m10 * matrix4f.m01 + this.m11 * matrix4f.m11 + this.m12 * matrix4f.m21 + this.m13 * matrix4f.m31;
        float f7 = this.m10 * matrix4f.m02 + this.m11 * matrix4f.m12 + this.m12 * matrix4f.m22 + this.m13 * matrix4f.m32;
        float f8 = this.m10 * matrix4f.m03 + this.m11 * matrix4f.m13 + this.m12 * matrix4f.m23 + this.m13 * matrix4f.m33;
        float f9 = this.m20 * matrix4f.m00 + this.m21 * matrix4f.m10 + this.m22 * matrix4f.m20 + this.m23 * matrix4f.m30;
        float f10 = this.m20 * matrix4f.m01 + this.m21 * matrix4f.m11 + this.m22 * matrix4f.m21 + this.m23 * matrix4f.m31;
        float f11 = this.m20 * matrix4f.m02 + this.m21 * matrix4f.m12 + this.m22 * matrix4f.m22 + this.m23 * matrix4f.m32;
        float f12 = this.m20 * matrix4f.m03 + this.m21 * matrix4f.m13 + this.m22 * matrix4f.m23 + this.m23 * matrix4f.m33;
        float f13 = this.m30 * matrix4f.m00 + this.m31 * matrix4f.m10 + this.m32 * matrix4f.m20 + this.m33 * matrix4f.m30;
        float f14 = this.m30 * matrix4f.m01 + this.m31 * matrix4f.m11 + this.m32 * matrix4f.m21 + this.m33 * matrix4f.m31;
        float f15 = this.m30 * matrix4f.m02 + this.m31 * matrix4f.m12 + this.m32 * matrix4f.m22 + this.m33 * matrix4f.m32;
        float f16 = this.m30 * matrix4f.m03 + this.m31 * matrix4f.m13 + this.m32 * matrix4f.m23 + this.m33 * matrix4f.m33;
        matrix4f2.m00 = f;
        matrix4f2.m01 = f2;
        matrix4f2.m02 = f3;
        matrix4f2.m03 = f4;
        matrix4f2.m10 = f5;
        matrix4f2.m11 = f6;
        matrix4f2.m12 = f7;
        matrix4f2.m13 = f8;
        matrix4f2.m20 = f9;
        matrix4f2.m21 = f10;
        matrix4f2.m22 = f11;
        matrix4f2.m23 = f12;
        matrix4f2.m30 = f13;
        matrix4f2.m31 = f14;
        matrix4f2.m32 = f15;
        matrix4f2.m33 = f16;
        return matrix4f2;
    }

    public Matrix4f multLocal(Matrix4f matrix4f) {
        return this.mult(matrix4f, this);
    }

    public Vector3f mult(Vector3f vector3f) {
        return this.mult(vector3f, null);
    }

    public Vector3f mult(Vector3f vector3f, Vector3f vector3f2) {
        if (vector3f2 == null) {
            vector3f2 = new Vector3f();
        }
        float f = vector3f.x;
        float f2 = vector3f.y;
        float f3 = vector3f.z;
        vector3f2.x = this.m00 * f + this.m01 * f2 + this.m02 * f3 + this.m03;
        vector3f2.y = this.m10 * f + this.m11 * f2 + this.m12 * f3 + this.m13;
        vector3f2.z = this.m20 * f + this.m21 * f2 + this.m22 * f3 + this.m23;
        return vector3f2;
    }

    public Vector4f mult(Vector4f vector4f) {
        return this.mult(vector4f, null);
    }

    public Vector4f mult(Vector4f vector4f, Vector4f vector4f2) {
        if (null == vector4f) {
            logger.info("Source vector is null, null result returned.");
            return null;
        }
        if (vector4f2 == null) {
            vector4f2 = new Vector4f();
        }
        float f = vector4f.x;
        float f2 = vector4f.y;
        float f3 = vector4f.z;
        float f4 = vector4f.w;
        vector4f2.x = this.m00 * f + this.m01 * f2 + this.m02 * f3 + this.m03 * f4;
        vector4f2.y = this.m10 * f + this.m11 * f2 + this.m12 * f3 + this.m13 * f4;
        vector4f2.z = this.m20 * f + this.m21 * f2 + this.m22 * f3 + this.m23 * f4;
        vector4f2.w = this.m30 * f + this.m31 * f2 + this.m32 * f3 + this.m33 * f4;
        return vector4f2;
    }

    public Vector4f multAcross(Vector4f vector4f) {
        return this.multAcross(vector4f, null);
    }

    public Vector4f multAcross(Vector4f vector4f, Vector4f vector4f2) {
        if (null == vector4f) {
            logger.info("Source vector is null, null result returned.");
            return null;
        }
        if (vector4f2 == null) {
            vector4f2 = new Vector4f();
        }
        float f = vector4f.x;
        float f2 = vector4f.y;
        float f3 = vector4f.z;
        float f4 = vector4f.w;
        vector4f2.x = this.m00 * f + this.m10 * f2 + this.m20 * f3 + this.m30 * f4;
        vector4f2.y = this.m01 * f + this.m11 * f2 + this.m21 * f3 + this.m31 * f4;
        vector4f2.z = this.m02 * f + this.m12 * f2 + this.m22 * f3 + this.m32 * f4;
        vector4f2.z = this.m03 * f + this.m13 * f2 + this.m23 * f3 + this.m33 * f4;
        return vector4f2;
    }

    public Vector3f multNormal(Vector3f vector3f, Vector3f vector3f2) {
        if (vector3f2 == null) {
            vector3f2 = new Vector3f();
        }
        float f = vector3f.x;
        float f2 = vector3f.y;
        float f3 = vector3f.z;
        vector3f2.x = this.m00 * f + this.m01 * f2 + this.m02 * f3;
        vector3f2.y = this.m10 * f + this.m11 * f2 + this.m12 * f3;
        vector3f2.z = this.m20 * f + this.m21 * f2 + this.m22 * f3;
        return vector3f2;
    }

    public Vector3f multNormalAcross(Vector3f vector3f, Vector3f vector3f2) {
        if (vector3f2 == null) {
            vector3f2 = new Vector3f();
        }
        float f = vector3f.x;
        float f2 = vector3f.y;
        float f3 = vector3f.z;
        vector3f2.x = this.m00 * f + this.m10 * f2 + this.m20 * f3;
        vector3f2.y = this.m01 * f + this.m11 * f2 + this.m21 * f3;
        vector3f2.z = this.m02 * f + this.m12 * f2 + this.m22 * f3;
        return vector3f2;
    }

    public float multProj(Vector3f vector3f, Vector3f vector3f2) {
        float f = vector3f.x;
        float f2 = vector3f.y;
        float f3 = vector3f.z;
        vector3f2.x = this.m00 * f + this.m01 * f2 + this.m02 * f3 + this.m03;
        vector3f2.y = this.m10 * f + this.m11 * f2 + this.m12 * f3 + this.m13;
        vector3f2.z = this.m20 * f + this.m21 * f2 + this.m22 * f3 + this.m23;
        return this.m30 * f + this.m31 * f2 + this.m32 * f3 + this.m33;
    }

    public Vector3f multAcross(Vector3f vector3f, Vector3f vector3f2) {
        if (null == vector3f) {
            logger.info("Source vector is null, null result returned.");
            return null;
        }
        if (vector3f2 == null) {
            vector3f2 = new Vector3f();
        }
        float f = vector3f.x;
        float f2 = vector3f.y;
        float f3 = vector3f.z;
        vector3f2.x = this.m00 * f + this.m10 * f2 + this.m20 * f3 + this.m30 * 1.0f;
        vector3f2.y = this.m01 * f + this.m11 * f2 + this.m21 * f3 + this.m31 * 1.0f;
        vector3f2.z = this.m02 * f + this.m12 * f2 + this.m22 * f3 + this.m32 * 1.0f;
        return vector3f2;
    }

    public Quaternion mult(Quaternion quaternion, Quaternion quaternion2) {
        if (null == quaternion) {
            logger.warning("Source vector is null, null result returned.");
            return null;
        }
        if (quaternion2 == null) {
            quaternion2 = new Quaternion();
        }
        float f = this.m00 * quaternion.x + this.m10 * quaternion.y + this.m20 * quaternion.z + this.m30 * quaternion.w;
        float f2 = this.m01 * quaternion.x + this.m11 * quaternion.y + this.m21 * quaternion.z + this.m31 * quaternion.w;
        float f3 = this.m02 * quaternion.x + this.m12 * quaternion.y + this.m22 * quaternion.z + this.m32 * quaternion.w;
        float f4 = this.m03 * quaternion.x + this.m13 * quaternion.y + this.m23 * quaternion.z + this.m33 * quaternion.w;
        quaternion2.x = f;
        quaternion2.y = f2;
        quaternion2.z = f3;
        quaternion2.w = f4;
        return quaternion2;
    }

    public float[] mult(float[] fArray) {
        if (null == fArray || fArray.length != 4) {
            logger.warning("invalid array given, must be nonnull and length 4");
            return null;
        }
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        float f4 = fArray[3];
        fArray[0] = this.m00 * f + this.m01 * f2 + this.m02 * f3 + this.m03 * f4;
        fArray[1] = this.m10 * f + this.m11 * f2 + this.m12 * f3 + this.m13 * f4;
        fArray[2] = this.m20 * f + this.m21 * f2 + this.m22 * f3 + this.m23 * f4;
        fArray[3] = this.m30 * f + this.m31 * f2 + this.m32 * f3 + this.m33 * f4;
        return fArray;
    }

    public float[] multAcross(float[] fArray) {
        if (null == fArray || fArray.length != 4) {
            logger.warning("invalid array given, must be nonnull and length 4");
            return null;
        }
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        float f4 = fArray[3];
        fArray[0] = this.m00 * f + this.m10 * f2 + this.m20 * f3 + this.m30 * f4;
        fArray[1] = this.m01 * f + this.m11 * f2 + this.m21 * f3 + this.m31 * f4;
        fArray[2] = this.m02 * f + this.m12 * f2 + this.m22 * f3 + this.m32 * f4;
        fArray[3] = this.m03 * f + this.m13 * f2 + this.m23 * f3 + this.m33 * f4;
        return fArray;
    }

    public Matrix4f invert() {
        return this.invert(null);
    }

    public Matrix4f invert(Matrix4f matrix4f) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        if (matrix4f == null) {
            matrix4f = new Matrix4f();
        }
        if (FastMath.abs(f13 = (f12 = this.m00 * this.m11 - this.m01 * this.m10) * (f11 = this.m22 * this.m33 - this.m23 * this.m32) - (f10 = this.m00 * this.m12 - this.m02 * this.m10) * (f9 = this.m21 * this.m33 - this.m23 * this.m31) + (f8 = this.m00 * this.m13 - this.m03 * this.m10) * (f7 = this.m21 * this.m32 - this.m22 * this.m31) + (f6 = this.m01 * this.m12 - this.m02 * this.m11) * (f5 = this.m20 * this.m33 - this.m23 * this.m30) - (f4 = this.m01 * this.m13 - this.m03 * this.m11) * (f3 = this.m20 * this.m32 - this.m22 * this.m30) + (f2 = this.m02 * this.m13 - this.m03 * this.m12) * (f = this.m20 * this.m31 - this.m21 * this.m30)) <= 0.0f) {
            throw new ArithmeticException("This matrix cannot be inverted");
        }
        matrix4f.m00 = this.m11 * f11 - this.m12 * f9 + this.m13 * f7;
        matrix4f.m10 = -this.m10 * f11 + this.m12 * f5 - this.m13 * f3;
        matrix4f.m20 = this.m10 * f9 - this.m11 * f5 + this.m13 * f;
        matrix4f.m30 = -this.m10 * f7 + this.m11 * f3 - this.m12 * f;
        matrix4f.m01 = -this.m01 * f11 + this.m02 * f9 - this.m03 * f7;
        matrix4f.m11 = this.m00 * f11 - this.m02 * f5 + this.m03 * f3;
        matrix4f.m21 = -this.m00 * f9 + this.m01 * f5 - this.m03 * f;
        matrix4f.m31 = this.m00 * f7 - this.m01 * f3 + this.m02 * f;
        matrix4f.m02 = this.m31 * f2 - this.m32 * f4 + this.m33 * f6;
        matrix4f.m12 = -this.m30 * f2 + this.m32 * f8 - this.m33 * f10;
        matrix4f.m22 = this.m30 * f4 - this.m31 * f8 + this.m33 * f12;
        matrix4f.m32 = -this.m30 * f6 + this.m31 * f10 - this.m32 * f12;
        matrix4f.m03 = -this.m21 * f2 + this.m22 * f4 - this.m23 * f6;
        matrix4f.m13 = this.m20 * f2 - this.m22 * f8 + this.m23 * f10;
        matrix4f.m23 = -this.m20 * f4 + this.m21 * f8 - this.m23 * f12;
        matrix4f.m33 = this.m20 * f6 - this.m21 * f10 + this.m22 * f12;
        float f14 = 1.0f / f13;
        matrix4f.multLocal(f14);
        return matrix4f;
    }

    public Matrix4f invertLocal() {
        float f = this.m00 * this.m11 - this.m01 * this.m10;
        float f2 = this.m22 * this.m33 - this.m23 * this.m32;
        float f3 = this.m00 * this.m12 - this.m02 * this.m10;
        float f4 = this.m21 * this.m33 - this.m23 * this.m31;
        float f5 = this.m00 * this.m13 - this.m03 * this.m10;
        float f6 = this.m21 * this.m32 - this.m22 * this.m31;
        float f7 = this.m01 * this.m12 - this.m02 * this.m11;
        float f8 = this.m20 * this.m33 - this.m23 * this.m30;
        float f9 = this.m01 * this.m13 - this.m03 * this.m11;
        float f10 = this.m20 * this.m32 - this.m22 * this.m30;
        float f11 = this.m02 * this.m13 - this.m03 * this.m12;
        float f12 = this.m20 * this.m31 - this.m21 * this.m30;
        float f13 = f * f2 - f3 * f4 + f5 * f6 + f7 * f8 - f9 * f10 + f11 * f12;
        if (FastMath.abs(f13) <= 0.0f) {
            return this.zero();
        }
        float f14 = this.m11 * f2 - this.m12 * f4 + this.m13 * f6;
        float f15 = -this.m10 * f2 + this.m12 * f8 - this.m13 * f10;
        float f16 = this.m10 * f4 - this.m11 * f8 + this.m13 * f12;
        float f17 = -this.m10 * f6 + this.m11 * f10 - this.m12 * f12;
        float f18 = -this.m01 * f2 + this.m02 * f4 - this.m03 * f6;
        float f19 = this.m00 * f2 - this.m02 * f8 + this.m03 * f10;
        float f20 = -this.m00 * f4 + this.m01 * f8 - this.m03 * f12;
        float f21 = this.m00 * f6 - this.m01 * f10 + this.m02 * f12;
        float f22 = this.m31 * f11 - this.m32 * f9 + this.m33 * f7;
        float f23 = -this.m30 * f11 + this.m32 * f5 - this.m33 * f3;
        float f24 = this.m30 * f9 - this.m31 * f5 + this.m33 * f;
        float f25 = -this.m30 * f7 + this.m31 * f3 - this.m32 * f;
        float f26 = -this.m21 * f11 + this.m22 * f9 - this.m23 * f7;
        float f27 = this.m20 * f11 - this.m22 * f5 + this.m23 * f3;
        float f28 = -this.m20 * f9 + this.m21 * f5 - this.m23 * f;
        float f29 = this.m20 * f7 - this.m21 * f3 + this.m22 * f;
        this.m00 = f14;
        this.m01 = f18;
        this.m02 = f22;
        this.m03 = f26;
        this.m10 = f15;
        this.m11 = f19;
        this.m12 = f23;
        this.m13 = f27;
        this.m20 = f16;
        this.m21 = f20;
        this.m22 = f24;
        this.m23 = f28;
        this.m30 = f17;
        this.m31 = f21;
        this.m32 = f25;
        this.m33 = f29;
        float f30 = 1.0f / f13;
        this.multLocal(f30);
        return this;
    }

    public Matrix4f adjoint() {
        return this.adjoint(null);
    }

    public Matrix4f adjoint(Matrix4f matrix4f) {
        if (matrix4f == null) {
            matrix4f = new Matrix4f();
        }
        float f = this.m00 * this.m11 - this.m01 * this.m10;
        float f2 = this.m00 * this.m12 - this.m02 * this.m10;
        float f3 = this.m00 * this.m13 - this.m03 * this.m10;
        float f4 = this.m01 * this.m12 - this.m02 * this.m11;
        float f5 = this.m01 * this.m13 - this.m03 * this.m11;
        float f6 = this.m02 * this.m13 - this.m03 * this.m12;
        float f7 = this.m20 * this.m31 - this.m21 * this.m30;
        float f8 = this.m20 * this.m32 - this.m22 * this.m30;
        float f9 = this.m20 * this.m33 - this.m23 * this.m30;
        float f10 = this.m21 * this.m32 - this.m22 * this.m31;
        float f11 = this.m21 * this.m33 - this.m23 * this.m31;
        float f12 = this.m22 * this.m33 - this.m23 * this.m32;
        matrix4f.m00 = this.m11 * f12 - this.m12 * f11 + this.m13 * f10;
        matrix4f.m10 = -this.m10 * f12 + this.m12 * f9 - this.m13 * f8;
        matrix4f.m20 = this.m10 * f11 - this.m11 * f9 + this.m13 * f7;
        matrix4f.m30 = -this.m10 * f10 + this.m11 * f8 - this.m12 * f7;
        matrix4f.m01 = -this.m01 * f12 + this.m02 * f11 - this.m03 * f10;
        matrix4f.m11 = this.m00 * f12 - this.m02 * f9 + this.m03 * f8;
        matrix4f.m21 = -this.m00 * f11 + this.m01 * f9 - this.m03 * f7;
        matrix4f.m31 = this.m00 * f10 - this.m01 * f8 + this.m02 * f7;
        matrix4f.m02 = this.m31 * f6 - this.m32 * f5 + this.m33 * f4;
        matrix4f.m12 = -this.m30 * f6 + this.m32 * f3 - this.m33 * f2;
        matrix4f.m22 = this.m30 * f5 - this.m31 * f3 + this.m33 * f;
        matrix4f.m32 = -this.m30 * f4 + this.m31 * f2 - this.m32 * f;
        matrix4f.m03 = -this.m21 * f6 + this.m22 * f5 - this.m23 * f4;
        matrix4f.m13 = this.m20 * f6 - this.m22 * f3 + this.m23 * f2;
        matrix4f.m23 = -this.m20 * f5 + this.m21 * f3 - this.m23 * f;
        matrix4f.m33 = this.m20 * f4 - this.m21 * f2 + this.m22 * f;
        return matrix4f;
    }

    public float determinant() {
        float f = this.m00 * this.m11 - this.m01 * this.m10;
        float f2 = this.m00 * this.m12 - this.m02 * this.m10;
        float f3 = this.m00 * this.m13 - this.m03 * this.m10;
        float f4 = this.m01 * this.m12 - this.m02 * this.m11;
        float f5 = this.m01 * this.m13 - this.m03 * this.m11;
        float f6 = this.m02 * this.m13 - this.m03 * this.m12;
        float f7 = this.m20 * this.m31 - this.m21 * this.m30;
        float f8 = this.m20 * this.m32 - this.m22 * this.m30;
        float f9 = this.m20 * this.m33 - this.m23 * this.m30;
        float f10 = this.m21 * this.m32 - this.m22 * this.m31;
        float f11 = this.m21 * this.m33 - this.m23 * this.m31;
        float f12 = this.m22 * this.m33 - this.m23 * this.m32;
        float f13 = f * f12 - f2 * f11 + f3 * f10 + f4 * f9 - f5 * f8 + f6 * f7;
        return f13;
    }

    public Matrix4f zero() {
        this.m03 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        this.m00 = 0.0f;
        this.m13 = 0.0f;
        this.m12 = 0.0f;
        this.m11 = 0.0f;
        this.m10 = 0.0f;
        this.m23 = 0.0f;
        this.m22 = 0.0f;
        this.m21 = 0.0f;
        this.m20 = 0.0f;
        this.m33 = 0.0f;
        this.m32 = 0.0f;
        this.m31 = 0.0f;
        this.m30 = 0.0f;
        return this;
    }

    public Matrix4f add(Matrix4f matrix4f) {
        Matrix4f matrix4f2 = new Matrix4f();
        matrix4f2.m00 = this.m00 + matrix4f.m00;
        matrix4f2.m01 = this.m01 + matrix4f.m01;
        matrix4f2.m02 = this.m02 + matrix4f.m02;
        matrix4f2.m03 = this.m03 + matrix4f.m03;
        matrix4f2.m10 = this.m10 + matrix4f.m10;
        matrix4f2.m11 = this.m11 + matrix4f.m11;
        matrix4f2.m12 = this.m12 + matrix4f.m12;
        matrix4f2.m13 = this.m13 + matrix4f.m13;
        matrix4f2.m20 = this.m20 + matrix4f.m20;
        matrix4f2.m21 = this.m21 + matrix4f.m21;
        matrix4f2.m22 = this.m22 + matrix4f.m22;
        matrix4f2.m23 = this.m23 + matrix4f.m23;
        matrix4f2.m30 = this.m30 + matrix4f.m30;
        matrix4f2.m31 = this.m31 + matrix4f.m31;
        matrix4f2.m32 = this.m32 + matrix4f.m32;
        matrix4f2.m33 = this.m33 + matrix4f.m33;
        return matrix4f2;
    }

    public void addLocal(Matrix4f matrix4f) {
        this.m00 += matrix4f.m00;
        this.m01 += matrix4f.m01;
        this.m02 += matrix4f.m02;
        this.m03 += matrix4f.m03;
        this.m10 += matrix4f.m10;
        this.m11 += matrix4f.m11;
        this.m12 += matrix4f.m12;
        this.m13 += matrix4f.m13;
        this.m20 += matrix4f.m20;
        this.m21 += matrix4f.m21;
        this.m22 += matrix4f.m22;
        this.m23 += matrix4f.m23;
        this.m30 += matrix4f.m30;
        this.m31 += matrix4f.m31;
        this.m32 += matrix4f.m32;
        this.m33 += matrix4f.m33;
    }

    public Vector3f toTranslationVector() {
        return new Vector3f(this.m03, this.m13, this.m23);
    }

    public void toTranslationVector(Vector3f vector3f) {
        vector3f.set(this.m03, this.m13, this.m23);
    }

    public Quaternion toRotationQuat() {
        Quaternion quaternion = new Quaternion();
        quaternion.fromRotationMatrix(this.toRotationMatrix());
        return quaternion;
    }

    public void toRotationQuat(Quaternion quaternion) {
        quaternion.fromRotationMatrix(this.toRotationMatrix());
    }

    public Matrix3f toRotationMatrix() {
        return new Matrix3f(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
    }

    public void toRotationMatrix(Matrix3f matrix3f) {
        matrix3f.m00 = this.m00;
        matrix3f.m01 = this.m01;
        matrix3f.m02 = this.m02;
        matrix3f.m10 = this.m10;
        matrix3f.m11 = this.m11;
        matrix3f.m12 = this.m12;
        matrix3f.m20 = this.m20;
        matrix3f.m21 = this.m21;
        matrix3f.m22 = this.m22;
    }

    public void setScale(float f, float f2, float f3) {
        this.m00 *= f;
        this.m11 *= f2;
        this.m22 *= f3;
    }

    public void setScale(Vector3f vector3f) {
        this.m00 *= vector3f.x;
        this.m11 *= vector3f.y;
        this.m22 *= vector3f.z;
    }

    public void setTranslation(float[] fArray) {
        if (fArray.length != 3) {
            throw new IllegalArgumentException("Translation size must be 3.");
        }
        this.m03 = fArray[0];
        this.m13 = fArray[1];
        this.m23 = fArray[2];
    }

    public void setTranslation(float f, float f2, float f3) {
        this.m03 = f;
        this.m13 = f2;
        this.m23 = f3;
    }

    public void setTranslation(Vector3f vector3f) {
        this.m03 = vector3f.x;
        this.m13 = vector3f.y;
        this.m23 = vector3f.z;
    }

    public void setInverseTranslation(float[] fArray) {
        if (fArray.length != 3) {
            throw new IllegalArgumentException("Translation size must be 3.");
        }
        this.m03 = -fArray[0];
        this.m13 = -fArray[1];
        this.m23 = -fArray[2];
    }

    public void angleRotation(Vector3f vector3f) {
        float f = vector3f.z * ((float)Math.PI / 180);
        float f2 = FastMath.sin(f);
        float f3 = FastMath.cos(f);
        f = vector3f.y * ((float)Math.PI / 180);
        float f4 = FastMath.sin(f);
        float f5 = FastMath.cos(f);
        f = vector3f.x * ((float)Math.PI / 180);
        float f6 = FastMath.sin(f);
        float f7 = FastMath.cos(f);
        this.m00 = f5 * f3;
        this.m10 = f5 * f2;
        this.m20 = -f4;
        this.m01 = f6 * f4 * f3 + f7 * -f2;
        this.m11 = f6 * f4 * f2 + f7 * f3;
        this.m21 = f6 * f5;
        this.m02 = f7 * f4 * f3 + -f6 * -f2;
        this.m12 = f7 * f4 * f2 + -f6 * f3;
        this.m22 = f7 * f5;
        this.m03 = 0.0f;
        this.m13 = 0.0f;
        this.m23 = 0.0f;
    }

    public void setRotationQuaternion(Quaternion quaternion) {
        quaternion.toRotationMatrix(this);
    }

    public void setInverseRotationRadians(float[] fArray) {
        if (fArray.length != 3) {
            throw new IllegalArgumentException("Angles must be of size 3.");
        }
        double d = FastMath.cos(fArray[0]);
        double d2 = FastMath.sin(fArray[0]);
        double d3 = FastMath.cos(fArray[1]);
        double d4 = FastMath.sin(fArray[1]);
        double d5 = FastMath.cos(fArray[2]);
        double d6 = FastMath.sin(fArray[2]);
        this.m00 = (float)(d3 * d5);
        this.m10 = (float)(d3 * d6);
        this.m20 = (float)(-d4);
        double d7 = d2 * d4;
        double d8 = d * d4;
        this.m01 = (float)(d7 * d5 - d * d6);
        this.m11 = (float)(d7 * d6 + d * d5);
        this.m21 = (float)(d2 * d3);
        this.m02 = (float)(d8 * d5 + d2 * d6);
        this.m12 = (float)(d8 * d6 - d2 * d5);
        this.m22 = (float)(d * d3);
    }

    public void setInverseRotationDegrees(float[] fArray) {
        if (fArray.length != 3) {
            throw new IllegalArgumentException("Angles must be of size 3.");
        }
        float[] fArray2 = new float[]{fArray[0] * 57.295776f, fArray[1] * 57.295776f, fArray[2] * 57.295776f};
        this.setInverseRotationRadians(fArray2);
    }

    public void inverseTranslateVect(float[] fArray) {
        if (fArray.length != 3) {
            throw new IllegalArgumentException("vec must be of size 3.");
        }
        fArray[0] = fArray[0] - this.m03;
        fArray[1] = fArray[1] - this.m13;
        fArray[2] = fArray[2] - this.m23;
    }

    public void inverseTranslateVect(Vector3f vector3f) {
        vector3f.x -= this.m03;
        vector3f.y -= this.m13;
        vector3f.z -= this.m23;
    }

    public void translateVect(Vector3f vector3f) {
        vector3f.x += this.m03;
        vector3f.y += this.m13;
        vector3f.z += this.m23;
    }

    public void inverseRotateVect(Vector3f vector3f) {
        float f = vector3f.x;
        float f2 = vector3f.y;
        float f3 = vector3f.z;
        vector3f.x = f * this.m00 + f2 * this.m10 + f3 * this.m20;
        vector3f.y = f * this.m01 + f2 * this.m11 + f3 * this.m21;
        vector3f.z = f * this.m02 + f2 * this.m12 + f3 * this.m22;
    }

    public void rotateVect(Vector3f vector3f) {
        float f = vector3f.x;
        float f2 = vector3f.y;
        float f3 = vector3f.z;
        vector3f.x = f * this.m00 + f2 * this.m01 + f3 * this.m02;
        vector3f.y = f * this.m10 + f2 * this.m11 + f3 * this.m12;
        vector3f.z = f * this.m20 + f2 * this.m21 + f3 * this.m22;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Matrix4f\n[\n");
        stringBuilder.append(" ");
        stringBuilder.append(this.m00);
        stringBuilder.append("  ");
        stringBuilder.append(this.m01);
        stringBuilder.append("  ");
        stringBuilder.append(this.m02);
        stringBuilder.append("  ");
        stringBuilder.append(this.m03);
        stringBuilder.append(" \n");
        stringBuilder.append(" ");
        stringBuilder.append(this.m10);
        stringBuilder.append("  ");
        stringBuilder.append(this.m11);
        stringBuilder.append("  ");
        stringBuilder.append(this.m12);
        stringBuilder.append("  ");
        stringBuilder.append(this.m13);
        stringBuilder.append(" \n");
        stringBuilder.append(" ");
        stringBuilder.append(this.m20);
        stringBuilder.append("  ");
        stringBuilder.append(this.m21);
        stringBuilder.append("  ");
        stringBuilder.append(this.m22);
        stringBuilder.append("  ");
        stringBuilder.append(this.m23);
        stringBuilder.append(" \n");
        stringBuilder.append(" ");
        stringBuilder.append(this.m30);
        stringBuilder.append("  ");
        stringBuilder.append(this.m31);
        stringBuilder.append("  ");
        stringBuilder.append(this.m32);
        stringBuilder.append("  ");
        stringBuilder.append(this.m33);
        stringBuilder.append(" \n]");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 37;
        n = 37 * n + Float.floatToIntBits(this.m00);
        n = 37 * n + Float.floatToIntBits(this.m01);
        n = 37 * n + Float.floatToIntBits(this.m02);
        n = 37 * n + Float.floatToIntBits(this.m03);
        n = 37 * n + Float.floatToIntBits(this.m10);
        n = 37 * n + Float.floatToIntBits(this.m11);
        n = 37 * n + Float.floatToIntBits(this.m12);
        n = 37 * n + Float.floatToIntBits(this.m13);
        n = 37 * n + Float.floatToIntBits(this.m20);
        n = 37 * n + Float.floatToIntBits(this.m21);
        n = 37 * n + Float.floatToIntBits(this.m22);
        n = 37 * n + Float.floatToIntBits(this.m23);
        n = 37 * n + Float.floatToIntBits(this.m30);
        n = 37 * n + Float.floatToIntBits(this.m31);
        n = 37 * n + Float.floatToIntBits(this.m32);
        n = 37 * n + Float.floatToIntBits(this.m33);
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Matrix4f) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Matrix4f matrix4f = (Matrix4f)object;
        if (Float.compare(this.m00, matrix4f.m00) != 0) {
            return false;
        }
        if (Float.compare(this.m01, matrix4f.m01) != 0) {
            return false;
        }
        if (Float.compare(this.m02, matrix4f.m02) != 0) {
            return false;
        }
        if (Float.compare(this.m03, matrix4f.m03) != 0) {
            return false;
        }
        if (Float.compare(this.m10, matrix4f.m10) != 0) {
            return false;
        }
        if (Float.compare(this.m11, matrix4f.m11) != 0) {
            return false;
        }
        if (Float.compare(this.m12, matrix4f.m12) != 0) {
            return false;
        }
        if (Float.compare(this.m13, matrix4f.m13) != 0) {
            return false;
        }
        if (Float.compare(this.m20, matrix4f.m20) != 0) {
            return false;
        }
        if (Float.compare(this.m21, matrix4f.m21) != 0) {
            return false;
        }
        if (Float.compare(this.m22, matrix4f.m22) != 0) {
            return false;
        }
        if (Float.compare(this.m23, matrix4f.m23) != 0) {
            return false;
        }
        if (Float.compare(this.m30, matrix4f.m30) != 0) {
            return false;
        }
        if (Float.compare(this.m31, matrix4f.m31) != 0) {
            return false;
        }
        if (Float.compare(this.m32, matrix4f.m32) != 0) {
            return false;
        }
        return Float.compare(this.m33, matrix4f.m33) == 0;
    }

    public boolean isIdentity() {
        return this.m00 == 1.0f && this.m01 == 0.0f && this.m02 == 0.0f && this.m03 == 0.0f && this.m10 == 0.0f && this.m11 == 1.0f && this.m12 == 0.0f && this.m13 == 0.0f && this.m20 == 0.0f && this.m21 == 0.0f && this.m22 == 1.0f && this.m23 == 0.0f && this.m30 == 0.0f && this.m31 == 0.0f && this.m32 == 0.0f && this.m33 == 1.0f;
    }

    public void scale(Vector3f vector3f) {
        this.m00 *= vector3f.getX();
        this.m10 *= vector3f.getX();
        this.m20 *= vector3f.getX();
        this.m30 *= vector3f.getX();
        this.m01 *= vector3f.getY();
        this.m11 *= vector3f.getY();
        this.m21 *= vector3f.getY();
        this.m31 *= vector3f.getY();
        this.m02 *= vector3f.getZ();
        this.m12 *= vector3f.getZ();
        this.m22 *= vector3f.getZ();
        this.m32 *= vector3f.getZ();
    }

    static boolean equalIdentity(Matrix4f matrix4f) {
        if ((double)Math.abs(matrix4f.m00 - 1.0f) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m11 - 1.0f) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m22 - 1.0f) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m33 - 1.0f) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m01) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m02) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m03) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m10) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m12) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m13) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m20) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m21) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m23) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m30) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m31) > 1.0E-4) {
            return false;
        }
        return !((double)Math.abs(matrix4f.m32) > 1.0E-4);
    }

    public void multLocal(Quaternion quaternion) {
        Vector3f vector3f = new Vector3f();
        float f = quaternion.toAngleAxis(vector3f);
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.fromAngleAxis(f, vector3f);
        this.multLocal(matrix4f);
    }

    public Matrix4f clone() {
        try {
            return (Matrix4f)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }
}

