/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.math;

import java.util.Comparator;

public class Interval
implements Comparable<Interval> {
    private float from;
    private float to;
    public static final Comparator<Interval> COMPARE_BY_FROM = new Comparator<Interval>(){

        @Override
        public int compare(Interval interval, Interval interval2) {
            int n = Float.compare(interval.from, interval2.from);
            if (n != 0) {
                return n;
            }
            return Float.compare(interval.to, interval2.to);
        }
    };
    public static final Comparator<Interval> COMPARE_BY_TO = new Comparator<Interval>(){

        @Override
        public int compare(Interval interval, Interval interval2) {
            int n = Float.compare(interval.to, interval2.to);
            if (n != 0) {
                return n;
            }
            return Float.compare(interval.from, interval2.from);
        }
    };

    public Interval(float f, float f2) {
        if (f > f2) {
            this.to = f;
            this.from = f2;
        } else {
            this.from = f;
            this.to = f2;
        }
    }

    public float from() {
        return this.from;
    }

    public float to() {
        return this.to;
    }

    public float length() {
        return this.to - this.from;
    }

    public boolean isBefore(float f) {
        return f < this.from;
    }

    public boolean isAfter(float f) {
        return this.to < f;
    }

    public float clamp(float f) {
        return Math.max(this.from, Math.min(this.to, f));
    }

    public boolean contains(float f) {
        return this.from <= f && f <= this.to;
    }

    public float alpha(float f) {
        if (this.isBefore(f)) {
            return 0.0f;
        }
        if (this.isAfter(f)) {
            return 1.0f;
        }
        return (f - this.from) / (this.to - this.from);
    }

    public void union(Interval interval) {
        this.from = Math.min(this.from, interval.from);
        this.to = Math.max(this.to, interval.to);
    }

    public void extend(float f) {
        this.from = Math.min(this.from, f);
        this.to = Math.max(this.to, f);
    }

    @Override
    public int compareTo(Interval interval) {
        return COMPARE_BY_FROM.compare(this, interval);
    }

    public void limitBy(Interval interval) {
        if (this.from < interval.from) {
            this.from = interval.from;
        }
        if (this.to > interval.to) {
            this.to = interval.to;
        }
    }

    public String toString() {
        return "{from: " + this.from + ", to: " + this.to + "}";
    }

    public boolean intersects(Interval interval) {
        return this.contains(interval.from) || this.contains(interval.to) || interval.contains(this.from) || interval.contains(this.to);
    }
}

