/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.math;

import java.util.Random;
import tazadum.engine.math.Vector2f;
import tazadum.engine.math.Vector3f;

public final class FastMath {
    public static final double DBL_EPSILON = 2.220446049250313E-16;
    public static final float FLT_EPSILON = 1.1920929E-7f;
    public static final float ZERO_TOLERANCE = 1.0E-4f;
    public static final float ONE_THIRD = 0.33333334f;
    public static final float PI = (float)Math.PI;
    public static final float TWO_PI = (float)Math.PI * 2;
    public static final float HALF_PI = 1.5707964f;
    public static final float QUARTER_PI = 0.7853982f;
    public static final float INV_PI = 0.31830987f;
    public static final float INV_TWO_PI = 0.15915494f;
    public static final float DEG_TO_RAD = (float)Math.PI / 180;
    public static final float RAD_TO_DEG = 57.295776f;
    public static final Random rand = new Random(System.currentTimeMillis());

    private FastMath() {
    }

    public static boolean isPowerOfTwo(int n) {
        return n > 0 && (n & n - 1) == 0;
    }

    public static int nearestPowerOfTwo(int n) {
        return (int)Math.pow(2.0, Math.ceil(Math.log(n) / Math.log(2.0)));
    }

    public static float interpolateLinear(float f, float f2, float f3) {
        if (f2 == f3) {
            return f2;
        }
        if (f <= 0.0f) {
            return f2;
        }
        if (f >= 1.0f) {
            return f3;
        }
        return (1.0f - f) * f2 + f * f3;
    }

    public static Vector3f interpolateLinear(float f, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        if (vector3f3 == null) {
            vector3f3 = new Vector3f();
        }
        vector3f3.x = FastMath.interpolateLinear(f, vector3f.x, vector3f2.x);
        vector3f3.y = FastMath.interpolateLinear(f, vector3f.y, vector3f2.y);
        vector3f3.z = FastMath.interpolateLinear(f, vector3f.z, vector3f2.z);
        return vector3f3;
    }

    public static Vector3f interpolateLinear(float f, Vector3f vector3f, Vector3f vector3f2) {
        return FastMath.interpolateLinear(f, vector3f, vector3f2, null);
    }

    public static float interpolateCatmullRom(float f, float f2, float f3, float f4, float f5, float f6) {
        double d = f4;
        double d2 = -1.0 * (double)f2 * (double)f3 + (double)(f2 * f5);
        double d3 = 2.0f * f2 * f3 + (f2 - 3.0f) * f4 + (3.0f - 2.0f * f2) * f5 + -f2 * f6;
        double d4 = -f2 * f3 + (2.0f - f2) * f4 + (f2 - 2.0f) * f5 + f2 * f6;
        return (float)(((d4 * (double)f + d3) * (double)f + d2) * (double)f + d);
    }

    public static Vector3f interpolateCatmullRom(float f, float f2, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, Vector3f vector3f5) {
        if (vector3f5 == null) {
            vector3f5 = new Vector3f();
        }
        vector3f5.x = FastMath.interpolateCatmullRom(f, f2, vector3f.x, vector3f2.x, vector3f3.x, vector3f4.x);
        vector3f5.y = FastMath.interpolateCatmullRom(f, f2, vector3f.y, vector3f2.y, vector3f3.y, vector3f4.y);
        vector3f5.z = FastMath.interpolateCatmullRom(f, f2, vector3f.z, vector3f2.z, vector3f3.z, vector3f4.z);
        return vector3f5;
    }

    public static Vector3f interpolateCatmullRom(float f, float f2, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
        return FastMath.interpolateCatmullRom(f, f2, vector3f, vector3f2, vector3f3, vector3f4, null);
    }

    public static float interpolateBezier(float f, float f2, float f3, float f4, float f5) {
        float f6 = 1.0f - f;
        float f7 = f6 * f6;
        float f8 = f * f;
        return f2 * f7 * f6 + 3.0f * f3 * f * f7 + 3.0f * f4 * f8 * f6 + f5 * f8 * f;
    }

    public static Vector3f interpolateBezier(float f, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, Vector3f vector3f5) {
        if (vector3f5 == null) {
            vector3f5 = new Vector3f();
        }
        vector3f5.x = FastMath.interpolateBezier(f, vector3f.x, vector3f2.x, vector3f3.x, vector3f4.x);
        vector3f5.y = FastMath.interpolateBezier(f, vector3f.y, vector3f2.y, vector3f3.y, vector3f4.y);
        vector3f5.z = FastMath.interpolateBezier(f, vector3f.z, vector3f2.z, vector3f3.z, vector3f4.z);
        return vector3f5;
    }

    public static Vector3f interpolateBezier(float f, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
        return FastMath.interpolateBezier(f, vector3f, vector3f2, vector3f3, vector3f4, null);
    }

    public static float getCatmullRomP1toP2Length(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, float f, float f2, float f3) {
        float f4;
        float f5;
        float f6;
        float f7 = 0.001f;
        float f8 = (f + f2) * 0.5f;
        Vector3f vector3f5 = vector3f2.clone();
        if (f != 0.0f) {
            FastMath.interpolateCatmullRom(f, f3, vector3f, vector3f2, vector3f3, vector3f4, vector3f5);
        }
        Vector3f vector3f6 = vector3f3.clone();
        if (f2 != 1.0f) {
            FastMath.interpolateCatmullRom(f2, f3, vector3f, vector3f2, vector3f3, vector3f4, vector3f6);
        }
        Vector3f vector3f7 = FastMath.interpolateCatmullRom(f8, f3, vector3f, vector3f2, vector3f3, vector3f4);
        float f9 = vector3f6.subtract(vector3f5).length();
        if (f9 + f7 < (f6 = (f5 = vector3f7.subtract(vector3f5).length()) + (f4 = vector3f6.subtract(vector3f7).length()))) {
            f5 = FastMath.getCatmullRomP1toP2Length(vector3f, vector3f2, vector3f3, vector3f4, f, f8, f3);
            f4 = FastMath.getCatmullRomP1toP2Length(vector3f, vector3f2, vector3f3, vector3f4, f8, f2, f3);
        }
        f9 = f5 + f4;
        return f9;
    }

    public static float acos(float f) {
        if (-1.0f < f) {
            if (f < 1.0f) {
                return (float)Math.acos(f);
            }
            return 0.0f;
        }
        return (float)Math.PI;
    }

    public static float asin(float f) {
        if (-1.0f < f) {
            if (f < 1.0f) {
                return (float)Math.asin(f);
            }
            return 1.5707964f;
        }
        return -1.5707964f;
    }

    public static float atan(float f) {
        return (float)Math.atan(f);
    }

    public static float atan2(float f, float f2) {
        return (float)Math.atan2(f, f2);
    }

    public static float ceil(float f) {
        return (float)Math.ceil(f);
    }

    public static float reduceSinAngle(float f) {
        if (Math.abs(f %= (float)Math.PI * 2) > (float)Math.PI) {
            f -= (float)Math.PI * 2;
        }
        if (Math.abs(f) > 1.5707964f) {
            f = (float)Math.PI - f;
        }
        return f;
    }

    public static float sin2(float f) {
        if ((double)Math.abs(f = FastMath.reduceSinAngle(f)) <= 0.7853981633974483) {
            return (float)Math.sin(f);
        }
        return (float)Math.cos(1.5707963267948966 - (double)f);
    }

    public static float cos2(float f) {
        return FastMath.sin2(f + 1.5707964f);
    }

    public static float cos(float f) {
        return (float)Math.cos(f);
    }

    public static float sin(float f) {
        return (float)Math.sin(f);
    }

    public static float exp(float f) {
        return (float)Math.exp(f);
    }

    public static float abs(float f) {
        if (f < 0.0f) {
            return -f;
        }
        return f;
    }

    public static float floor(float f) {
        return (float)Math.floor(f);
    }

    public static float invSqrt(float f) {
        return (float)(1.0 / Math.sqrt(f));
    }

    public static float fastInvSqrt(float f) {
        float f2 = 0.5f * f;
        int n = Float.floatToIntBits(f);
        n = 1597463174 - (n >> 1);
        f = Float.intBitsToFloat(n);
        f *= 1.5f - f2 * f * f;
        return f;
    }

    public static float log(float f) {
        return (float)Math.log(f);
    }

    public static float log(float f, float f2) {
        return (float)(Math.log(f) / Math.log(f2));
    }

    public static float pow(float f, float f2) {
        return (float)Math.pow(f, f2);
    }

    public static float sqr(float f) {
        return f * f;
    }

    public static float sqrt(float f) {
        return (float)Math.sqrt(f);
    }

    public static float tan(float f) {
        return (float)Math.tan(f);
    }

    public static int sign(int n) {
        if (n > 0) {
            return 1;
        }
        if (n < 0) {
            return -1;
        }
        return 0;
    }

    public static float sign(float f) {
        return Math.signum(f);
    }

    public static int counterClockwise(Vector2f vector2f, Vector2f vector2f2, Vector2f vector2f3) {
        float f = vector2f2.x - vector2f.x;
        float f2 = vector2f3.y - vector2f.y;
        float f3 = vector2f2.y - vector2f.y;
        float f4 = vector2f3.x - vector2f.x;
        if (f * f2 > f3 * f4) {
            return 1;
        }
        if (f * f2 < f3 * f4) {
            return -1;
        }
        if (f * f4 < 0.0f || f3 * f2 < 0.0f) {
            return -1;
        }
        if (f * f + f3 * f3 < f4 * f4 + f2 * f2) {
            return 1;
        }
        return 0;
    }

    public static int pointInsideTriangle(Vector2f vector2f, Vector2f vector2f2, Vector2f vector2f3, Vector2f vector2f4) {
        int n = FastMath.counterClockwise(vector2f, vector2f2, vector2f4);
        if (n == 0) {
            return 1;
        }
        int n2 = FastMath.counterClockwise(vector2f2, vector2f3, vector2f4);
        if (n2 == 0) {
            return 1;
        }
        if (n2 != n) {
            return 0;
        }
        int n3 = FastMath.counterClockwise(vector2f3, vector2f, vector2f4);
        if (n3 == 0) {
            return 1;
        }
        if (n3 != n) {
            return 0;
        }
        return n3;
    }

    public static float determinant(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16) {
        double d17 = d9 * d14 - d10 * d13;
        double d18 = d9 * d15 - d11 * d13;
        double d19 = d9 * d16 - d12 * d13;
        double d20 = d10 * d15 - d11 * d14;
        double d21 = d10 * d16 - d12 * d14;
        double d22 = d11 * d16 - d12 * d15;
        return (float)(d * (d6 * d22 - d7 * d21 + d8 * d20) - d2 * (d5 * d22 - d7 * d19 + d8 * d18) + d3 * (d5 * d21 - d6 * d19 + d8 * d17) - d4 * (d5 * d20 - d6 * d18 + d7 * d17));
    }

    public static float nextRandomFloat() {
        return rand.nextFloat();
    }

    public static int nextRandomInt(int n, int n2) {
        return (int)(FastMath.nextRandomFloat() * (float)(n2 - n + 1)) + n;
    }

    public static int nextRandomInt() {
        return rand.nextInt();
    }

    public static Vector3f sphericalToCartesian(Vector3f vector3f, Vector3f vector3f2) {
        vector3f2.y = vector3f.x * FastMath.sin(vector3f.z);
        float f = vector3f.x * FastMath.cos(vector3f.z);
        vector3f2.x = f * FastMath.cos(vector3f.y);
        vector3f2.z = f * FastMath.sin(vector3f.y);
        return vector3f2;
    }

    public static Vector3f cartesianToSpherical(Vector3f vector3f, Vector3f vector3f2) {
        float f = vector3f.x;
        if (f == 0.0f) {
            f = 1.1920929E-7f;
        }
        vector3f2.x = FastMath.sqrt(f * f + vector3f.y * vector3f.y + vector3f.z * vector3f.z);
        vector3f2.y = FastMath.atan(vector3f.z / f);
        if (f < 0.0f) {
            vector3f2.y += (float)Math.PI;
        }
        vector3f2.z = FastMath.asin(vector3f.y / vector3f2.x);
        return vector3f2;
    }

    public static Vector3f sphericalToCartesianZ(Vector3f vector3f, Vector3f vector3f2) {
        vector3f2.z = vector3f.x * FastMath.sin(vector3f.z);
        float f = vector3f.x * FastMath.cos(vector3f.z);
        vector3f2.x = f * FastMath.cos(vector3f.y);
        vector3f2.y = f * FastMath.sin(vector3f.y);
        return vector3f2;
    }

    public static Vector3f cartesianZToSpherical(Vector3f vector3f, Vector3f vector3f2) {
        float f = vector3f.x;
        if (f == 0.0f) {
            f = 1.1920929E-7f;
        }
        vector3f2.x = FastMath.sqrt(f * f + vector3f.y * vector3f.y + vector3f.z * vector3f.z);
        vector3f2.z = FastMath.atan(vector3f.z / f);
        if (f < 0.0f) {
            vector3f2.z += (float)Math.PI;
        }
        vector3f2.y = FastMath.asin(vector3f.y / vector3f2.x);
        return vector3f2;
    }

    public static float normalize(float f, float f2, float f3) {
        if (Float.isInfinite(f) || Float.isNaN(f)) {
            return 0.0f;
        }
        float f4 = f3 - f2;
        while (f > f3) {
            f -= f4;
        }
        while (f < f2) {
            f += f4;
        }
        return f;
    }

    public static float copysign(float f, float f2) {
        if (f2 >= 0.0f && f <= 0.0f) {
            return -f;
        }
        if (f2 < 0.0f && f >= 0.0f) {
            return -f;
        }
        return f;
    }

    public static float clamp(float f, float f2, float f3) {
        return f < f2 ? f2 : (f > f3 ? f3 : f);
    }

    public static float saturate(float f) {
        return FastMath.clamp(f, 0.0f, 1.0f);
    }

    public static float convertHalfToFloat(short s) {
        switch (s) {
            case 0: {
                return 0.0f;
            }
            case 32768: {
                return -0.0f;
            }
            case 31744: {
                return Float.POSITIVE_INFINITY;
            }
            case 64512: {
                return Float.NEGATIVE_INFINITY;
            }
        }
        return Float.intBitsToFloat((s & 0x8000) << 16 | (s & 0x7C00) + 114688 << 13 | (s & 0x3FF) << 13);
    }

    public static short convertFloatToHalf(float f) {
        if (Float.isNaN(f)) {
            throw new UnsupportedOperationException("NaN to half conversion not supported!");
        }
        if (f == Float.POSITIVE_INFINITY) {
            return 31744;
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return -1024;
        }
        if (f == 0.0f) {
            return 0;
        }
        if (f == -0.0f) {
            return Short.MIN_VALUE;
        }
        if (f > 65504.0f) {
            return 31743;
        }
        if (f < -65504.0f) {
            return -1025;
        }
        if (f > 0.0f && f < 5.96046E-8f) {
            return 1;
        }
        if (f < 0.0f && f > -5.96046E-8f) {
            return -32767;
        }
        int n = Float.floatToIntBits(f);
        return (short)(n >> 16 & 0x8000 | (n & 0x7F800000) - 0x38000000 >> 13 & 0x7C00 | n >> 13 & 0x3FF);
    }
}

