/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.math;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import tazadum.engine.math.ColorRGBA;
import tazadum.engine.math.Quaternion;
import tazadum.engine.math.TempVars;
import tazadum.engine.math.Vector2f;
import tazadum.engine.math.Vector3f;
import tazadum.engine.math.Vector4f;

public final class BufferUtils {
    private static boolean trackDirectMemory = false;
    private static ReferenceQueue<Buffer> removeCollected = new ReferenceQueue();
    private static ConcurrentHashMap<BufferInfo, BufferInfo> trackedBuffers = new ConcurrentHashMap();
    static ClearReferences cleanupthread;
    private static final AtomicBoolean loadedMethods;
    private static Method cleanerMethod;
    private static Method cleanMethod;
    private static Method viewedBufferMethod;
    private static Method freeMethod;

    public static void setTrackDirectMemoryEnabled(boolean bl) {
        trackDirectMemory = bl;
    }

    public static Buffer clone(Buffer buffer) {
        if (buffer instanceof FloatBuffer) {
            return BufferUtils.clone((FloatBuffer)buffer);
        }
        if (buffer instanceof ShortBuffer) {
            return BufferUtils.clone((ShortBuffer)buffer);
        }
        if (buffer instanceof ByteBuffer) {
            return BufferUtils.clone((ByteBuffer)buffer);
        }
        if (buffer instanceof IntBuffer) {
            return BufferUtils.clone((IntBuffer)buffer);
        }
        if (buffer instanceof DoubleBuffer) {
            return BufferUtils.clone((DoubleBuffer)buffer);
        }
        throw new UnsupportedOperationException();
    }

    private static void onBufferAllocated(Buffer buffer) {
        if (trackDirectMemory) {
            if (cleanupthread == null) {
                cleanupthread = new ClearReferences();
                cleanupthread.start();
            }
            if (buffer instanceof ByteBuffer) {
                BufferInfo bufferInfo = new BufferInfo(ByteBuffer.class, buffer.capacity(), buffer, removeCollected);
                trackedBuffers.put(bufferInfo, bufferInfo);
            } else if (buffer instanceof FloatBuffer) {
                BufferInfo bufferInfo = new BufferInfo(FloatBuffer.class, buffer.capacity() * 4, buffer, removeCollected);
                trackedBuffers.put(bufferInfo, bufferInfo);
            } else if (buffer instanceof IntBuffer) {
                BufferInfo bufferInfo = new BufferInfo(IntBuffer.class, buffer.capacity() * 4, buffer, removeCollected);
                trackedBuffers.put(bufferInfo, bufferInfo);
            } else if (buffer instanceof ShortBuffer) {
                BufferInfo bufferInfo = new BufferInfo(ShortBuffer.class, buffer.capacity() * 2, buffer, removeCollected);
                trackedBuffers.put(bufferInfo, bufferInfo);
            } else if (buffer instanceof DoubleBuffer) {
                BufferInfo bufferInfo = new BufferInfo(DoubleBuffer.class, buffer.capacity() * 8, buffer, removeCollected);
                trackedBuffers.put(bufferInfo, bufferInfo);
            }
        }
    }

    public static FloatBuffer createFloatBuffer(Vector3f ... vector3fArray) {
        if (vector3fArray == null) {
            return null;
        }
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(3 * vector3fArray.length);
        for (Vector3f vector3f : vector3fArray) {
            if (vector3f != null) {
                floatBuffer.put(vector3f.x).put(vector3f.y).put(vector3f.z);
                continue;
            }
            floatBuffer.put(0.0f).put(0.0f).put(0.0f);
        }
        floatBuffer.flip();
        return floatBuffer;
    }

    public static FloatBuffer createFloatBuffer(Quaternion ... quaternionArray) {
        if (quaternionArray == null) {
            return null;
        }
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(4 * quaternionArray.length);
        for (Quaternion quaternion : quaternionArray) {
            if (quaternion != null) {
                floatBuffer.put(quaternion.getX()).put(quaternion.getY()).put(quaternion.getZ()).put(quaternion.getW());
                continue;
            }
            floatBuffer.put(0.0f).put(0.0f).put(0.0f);
        }
        floatBuffer.flip();
        return floatBuffer;
    }

    public static FloatBuffer createFloatBuffer(Vector4f ... vector4fArray) {
        if (vector4fArray == null) {
            return null;
        }
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(4 * vector4fArray.length);
        for (int i = 0; i < vector4fArray.length; ++i) {
            if (vector4fArray[i] != null) {
                floatBuffer.put(vector4fArray[i].getX()).put(vector4fArray[i].getY()).put(vector4fArray[i].getZ()).put(vector4fArray[i].getW());
                continue;
            }
            floatBuffer.put(0.0f).put(0.0f).put(0.0f);
        }
        floatBuffer.flip();
        return floatBuffer;
    }

    public static FloatBuffer createFloatBuffer(float ... fArray) {
        if (fArray == null) {
            return null;
        }
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(fArray.length);
        floatBuffer.clear();
        floatBuffer.put(fArray);
        floatBuffer.flip();
        return floatBuffer;
    }

    public static FloatBuffer createVector3Buffer(int n) {
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(3 * n);
        return floatBuffer;
    }

    public static FloatBuffer createVector3Buffer(FloatBuffer floatBuffer, int n) {
        if (floatBuffer != null && floatBuffer.limit() == 3 * n) {
            floatBuffer.rewind();
            return floatBuffer;
        }
        return BufferUtils.createFloatBuffer(3 * n);
    }

    public static void setInBuffer(ColorRGBA colorRGBA, FloatBuffer floatBuffer, int n) {
        floatBuffer.position(n * 4);
        floatBuffer.put(colorRGBA.r);
        floatBuffer.put(colorRGBA.g);
        floatBuffer.put(colorRGBA.b);
        floatBuffer.put(colorRGBA.a);
    }

    public static void setInBuffer(Quaternion quaternion, FloatBuffer floatBuffer, int n) {
        floatBuffer.position(n * 4);
        floatBuffer.put(quaternion.getX());
        floatBuffer.put(quaternion.getY());
        floatBuffer.put(quaternion.getZ());
        floatBuffer.put(quaternion.getW());
    }

    public static void setInBuffer(Vector4f vector4f, FloatBuffer floatBuffer, int n) {
        floatBuffer.position(n * 4);
        floatBuffer.put(vector4f.getX());
        floatBuffer.put(vector4f.getY());
        floatBuffer.put(vector4f.getZ());
        floatBuffer.put(vector4f.getW());
    }

    public static void setInBuffer(Vector3f vector3f, FloatBuffer floatBuffer, int n) {
        if (floatBuffer == null) {
            return;
        }
        if (vector3f == null) {
            floatBuffer.put(n * 3, 0.0f);
            floatBuffer.put(n * 3 + 1, 0.0f);
            floatBuffer.put(n * 3 + 2, 0.0f);
        } else {
            floatBuffer.put(n * 3, vector3f.x);
            floatBuffer.put(n * 3 + 1, vector3f.y);
            floatBuffer.put(n * 3 + 2, vector3f.z);
        }
    }

    public static void populateFromBuffer(Vector3f vector3f, FloatBuffer floatBuffer, int n) {
        vector3f.x = floatBuffer.get(n * 3);
        vector3f.y = floatBuffer.get(n * 3 + 1);
        vector3f.z = floatBuffer.get(n * 3 + 2);
    }

    public static Vector3f[] getVector3Array(FloatBuffer floatBuffer) {
        floatBuffer.clear();
        Vector3f[] vector3fArray = new Vector3f[floatBuffer.limit() / 3];
        for (int i = 0; i < vector3fArray.length; ++i) {
            Vector3f vector3f;
            vector3fArray[i] = vector3f = new Vector3f(floatBuffer.get(), floatBuffer.get(), floatBuffer.get());
        }
        return vector3fArray;
    }

    public static void copyInternalVector3(FloatBuffer floatBuffer, int n, int n2) {
        BufferUtils.copyInternal(floatBuffer, n * 3, n2 * 3, 3);
    }

    public static void normalizeVector3(FloatBuffer floatBuffer, int n) {
        TempVars tempVars = TempVars.get();
        Vector3f vector3f = tempVars.vect1;
        BufferUtils.populateFromBuffer(vector3f, floatBuffer, n);
        vector3f.normalizeLocal();
        BufferUtils.setInBuffer(vector3f, floatBuffer, n);
        tempVars.release();
    }

    public static void addInBuffer(Vector3f vector3f, FloatBuffer floatBuffer, int n) {
        TempVars tempVars = TempVars.get();
        Vector3f vector3f2 = tempVars.vect1;
        BufferUtils.populateFromBuffer(vector3f2, floatBuffer, n);
        vector3f2.addLocal(vector3f);
        BufferUtils.setInBuffer(vector3f2, floatBuffer, n);
        tempVars.release();
    }

    public static void multInBuffer(Vector3f vector3f, FloatBuffer floatBuffer, int n) {
        TempVars tempVars = TempVars.get();
        Vector3f vector3f2 = tempVars.vect1;
        BufferUtils.populateFromBuffer(vector3f2, floatBuffer, n);
        vector3f2.multLocal(vector3f);
        BufferUtils.setInBuffer(vector3f2, floatBuffer, n);
        tempVars.release();
    }

    public static boolean equals(Vector3f vector3f, FloatBuffer floatBuffer, int n) {
        TempVars tempVars = TempVars.get();
        Vector3f vector3f2 = tempVars.vect1;
        BufferUtils.populateFromBuffer(vector3f2, floatBuffer, n);
        boolean bl = vector3f2.equals(vector3f);
        tempVars.release();
        return bl;
    }

    public static FloatBuffer createFloatBuffer(Vector2f ... vector2fArray) {
        if (vector2fArray == null) {
            return null;
        }
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(2 * vector2fArray.length);
        for (Vector2f vector2f : vector2fArray) {
            if (vector2f != null) {
                floatBuffer.put(vector2f.x).put(vector2f.y);
                continue;
            }
            floatBuffer.put(0.0f).put(0.0f);
        }
        floatBuffer.flip();
        return floatBuffer;
    }

    public static FloatBuffer createVector2Buffer(int n) {
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(2 * n);
        return floatBuffer;
    }

    public static FloatBuffer createVector2Buffer(FloatBuffer floatBuffer, int n) {
        if (floatBuffer != null && floatBuffer.limit() == 2 * n) {
            floatBuffer.rewind();
            return floatBuffer;
        }
        return BufferUtils.createFloatBuffer(2 * n);
    }

    public static void setInBuffer(Vector2f vector2f, FloatBuffer floatBuffer, int n) {
        floatBuffer.put(n * 2, vector2f.x);
        floatBuffer.put(n * 2 + 1, vector2f.y);
    }

    public static void populateFromBuffer(Vector2f vector2f, FloatBuffer floatBuffer, int n) {
        vector2f.x = floatBuffer.get(n * 2);
        vector2f.y = floatBuffer.get(n * 2 + 1);
    }

    public static Vector2f[] getVector2Array(FloatBuffer floatBuffer) {
        floatBuffer.clear();
        Vector2f[] vector2fArray = new Vector2f[floatBuffer.limit() / 2];
        for (int i = 0; i < vector2fArray.length; ++i) {
            Vector2f vector2f;
            vector2fArray[i] = vector2f = new Vector2f(floatBuffer.get(), floatBuffer.get());
        }
        return vector2fArray;
    }

    public static void copyInternalVector2(FloatBuffer floatBuffer, int n, int n2) {
        BufferUtils.copyInternal(floatBuffer, n * 2, n2 * 2, 2);
    }

    public static void normalizeVector2(FloatBuffer floatBuffer, int n) {
        TempVars tempVars = TempVars.get();
        Vector2f vector2f = tempVars.vect2d;
        BufferUtils.populateFromBuffer(vector2f, floatBuffer, n);
        vector2f.normalizeLocal();
        BufferUtils.setInBuffer(vector2f, floatBuffer, n);
        tempVars.release();
    }

    public static void addInBuffer(Vector2f vector2f, FloatBuffer floatBuffer, int n) {
        TempVars tempVars = TempVars.get();
        Vector2f vector2f2 = tempVars.vect2d;
        BufferUtils.populateFromBuffer(vector2f2, floatBuffer, n);
        vector2f2.addLocal(vector2f);
        BufferUtils.setInBuffer(vector2f2, floatBuffer, n);
        tempVars.release();
    }

    public static void multInBuffer(Vector2f vector2f, FloatBuffer floatBuffer, int n) {
        TempVars tempVars = TempVars.get();
        Vector2f vector2f2 = tempVars.vect2d;
        BufferUtils.populateFromBuffer(vector2f2, floatBuffer, n);
        vector2f2.multLocal(vector2f);
        BufferUtils.setInBuffer(vector2f2, floatBuffer, n);
        tempVars.release();
    }

    public static boolean equals(Vector2f vector2f, FloatBuffer floatBuffer, int n) {
        TempVars tempVars = TempVars.get();
        Vector2f vector2f2 = tempVars.vect2d;
        BufferUtils.populateFromBuffer(vector2f2, floatBuffer, n);
        boolean bl = vector2f2.equals(vector2f);
        tempVars.release();
        return bl;
    }

    public static IntBuffer createIntBuffer(int ... nArray) {
        if (nArray == null) {
            return null;
        }
        IntBuffer intBuffer = BufferUtils.createIntBuffer(nArray.length);
        intBuffer.clear();
        intBuffer.put(nArray);
        intBuffer.flip();
        return intBuffer;
    }

    public static int[] getIntArray(IntBuffer intBuffer) {
        if (intBuffer == null) {
            return null;
        }
        intBuffer.clear();
        int[] nArray = new int[intBuffer.limit()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = intBuffer.get();
        }
        return nArray;
    }

    public static float[] getFloatArray(FloatBuffer floatBuffer) {
        if (floatBuffer == null) {
            return null;
        }
        floatBuffer.clear();
        float[] fArray = new float[floatBuffer.limit()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = floatBuffer.get();
        }
        return fArray;
    }

    public static DoubleBuffer createDoubleBuffer(int n) {
        DoubleBuffer doubleBuffer = ByteBuffer.allocateDirect(8 * n).order(ByteOrder.nativeOrder()).asDoubleBuffer();
        doubleBuffer.clear();
        BufferUtils.onBufferAllocated(doubleBuffer);
        return doubleBuffer;
    }

    public static DoubleBuffer createDoubleBuffer(DoubleBuffer doubleBuffer, int n) {
        if (doubleBuffer != null && doubleBuffer.limit() == n) {
            doubleBuffer.rewind();
            return doubleBuffer;
        }
        doubleBuffer = BufferUtils.createDoubleBuffer(n);
        return doubleBuffer;
    }

    public static DoubleBuffer clone(DoubleBuffer doubleBuffer) {
        if (doubleBuffer == null) {
            return null;
        }
        doubleBuffer.rewind();
        DoubleBuffer doubleBuffer2 = BufferUtils.isDirect(doubleBuffer) ? BufferUtils.createDoubleBuffer(doubleBuffer.limit()) : DoubleBuffer.allocate(doubleBuffer.limit());
        doubleBuffer2.put(doubleBuffer);
        return doubleBuffer2;
    }

    public static FloatBuffer createFloatBuffer(int n) {
        FloatBuffer floatBuffer = ByteBuffer.allocateDirect(4 * n).order(ByteOrder.nativeOrder()).asFloatBuffer();
        floatBuffer.clear();
        BufferUtils.onBufferAllocated(floatBuffer);
        return floatBuffer;
    }

    public static void copyInternal(FloatBuffer floatBuffer, int n, int n2, int n3) {
        float[] fArray = new float[n3];
        floatBuffer.position(n);
        floatBuffer.get(fArray);
        floatBuffer.position(n2);
        floatBuffer.put(fArray);
    }

    public static FloatBuffer clone(FloatBuffer floatBuffer) {
        if (floatBuffer == null) {
            return null;
        }
        floatBuffer.rewind();
        FloatBuffer floatBuffer2 = BufferUtils.isDirect(floatBuffer) ? BufferUtils.createFloatBuffer(floatBuffer.limit()) : FloatBuffer.allocate(floatBuffer.limit());
        floatBuffer2.put(floatBuffer);
        return floatBuffer2;
    }

    public static IntBuffer createIntBuffer(int n) {
        IntBuffer intBuffer = ByteBuffer.allocateDirect(4 * n).order(ByteOrder.nativeOrder()).asIntBuffer();
        intBuffer.clear();
        BufferUtils.onBufferAllocated(intBuffer);
        return intBuffer;
    }

    public static IntBuffer createIntBuffer(IntBuffer intBuffer, int n) {
        if (intBuffer != null && intBuffer.limit() == n) {
            intBuffer.rewind();
            return intBuffer;
        }
        intBuffer = BufferUtils.createIntBuffer(n);
        return intBuffer;
    }

    public static IntBuffer clone(IntBuffer intBuffer) {
        if (intBuffer == null) {
            return null;
        }
        intBuffer.rewind();
        IntBuffer intBuffer2 = BufferUtils.isDirect(intBuffer) ? BufferUtils.createIntBuffer(intBuffer.limit()) : IntBuffer.allocate(intBuffer.limit());
        intBuffer2.put(intBuffer);
        return intBuffer2;
    }

    public static ByteBuffer createByteBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n).order(ByteOrder.nativeOrder());
        byteBuffer.clear();
        BufferUtils.onBufferAllocated(byteBuffer);
        return byteBuffer;
    }

    public static ByteBuffer createByteBuffer(ByteBuffer byteBuffer, int n) {
        if (byteBuffer != null && byteBuffer.limit() == n) {
            byteBuffer.rewind();
            return byteBuffer;
        }
        byteBuffer = BufferUtils.createByteBuffer(n);
        return byteBuffer;
    }

    public static ByteBuffer createByteBuffer(byte ... byArray) {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(byArray.length);
        byteBuffer.put(byArray);
        byteBuffer.flip();
        return byteBuffer;
    }

    public static ByteBuffer createByteBuffer(String string) {
        byte[] byArray = string.getBytes();
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(byArray.length);
        byteBuffer.put(byArray);
        byteBuffer.flip();
        return byteBuffer;
    }

    public static ByteBuffer clone(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        byteBuffer.rewind();
        ByteBuffer byteBuffer2 = BufferUtils.isDirect(byteBuffer) ? BufferUtils.createByteBuffer(byteBuffer.limit()) : ByteBuffer.allocate(byteBuffer.limit());
        byteBuffer2.put(byteBuffer);
        return byteBuffer2;
    }

    public static ShortBuffer createShortBuffer(int n) {
        ShortBuffer shortBuffer = ByteBuffer.allocateDirect(2 * n).order(ByteOrder.nativeOrder()).asShortBuffer();
        shortBuffer.clear();
        BufferUtils.onBufferAllocated(shortBuffer);
        return shortBuffer;
    }

    public static ShortBuffer createShortBuffer(ShortBuffer shortBuffer, int n) {
        if (shortBuffer != null && shortBuffer.limit() == n) {
            shortBuffer.rewind();
            return shortBuffer;
        }
        shortBuffer = BufferUtils.createShortBuffer(n);
        return shortBuffer;
    }

    public static ShortBuffer createShortBuffer(short ... sArray) {
        if (sArray == null) {
            return null;
        }
        ShortBuffer shortBuffer = BufferUtils.createShortBuffer(sArray.length);
        shortBuffer.clear();
        shortBuffer.put(sArray);
        shortBuffer.flip();
        return shortBuffer;
    }

    public static ShortBuffer clone(ShortBuffer shortBuffer) {
        if (shortBuffer == null) {
            return null;
        }
        shortBuffer.rewind();
        ShortBuffer shortBuffer2 = BufferUtils.isDirect(shortBuffer) ? BufferUtils.createShortBuffer(shortBuffer.limit()) : ShortBuffer.allocate(shortBuffer.limit());
        shortBuffer2.put(shortBuffer);
        return shortBuffer2;
    }

    public static FloatBuffer ensureLargeEnough(FloatBuffer floatBuffer, int n) {
        if (floatBuffer != null) {
            floatBuffer.limit(floatBuffer.capacity());
        }
        if (floatBuffer == null || floatBuffer.remaining() < n) {
            int n2 = floatBuffer != null ? floatBuffer.position() : 0;
            FloatBuffer floatBuffer2 = BufferUtils.createFloatBuffer(n2 + n);
            if (floatBuffer != null) {
                floatBuffer.flip();
                floatBuffer2.put(floatBuffer);
                floatBuffer2.position(n2);
            }
            floatBuffer = floatBuffer2;
        }
        return floatBuffer;
    }

    public static ShortBuffer ensureLargeEnough(ShortBuffer shortBuffer, int n) {
        if (shortBuffer != null) {
            shortBuffer.limit(shortBuffer.capacity());
        }
        if (shortBuffer == null || shortBuffer.remaining() < n) {
            int n2 = shortBuffer != null ? shortBuffer.position() : 0;
            ShortBuffer shortBuffer2 = BufferUtils.createShortBuffer(n2 + n);
            if (shortBuffer != null) {
                shortBuffer.flip();
                shortBuffer2.put(shortBuffer);
                shortBuffer2.position(n2);
            }
            shortBuffer = shortBuffer2;
        }
        return shortBuffer;
    }

    public static ByteBuffer ensureLargeEnough(ByteBuffer byteBuffer, int n) {
        if (byteBuffer != null) {
            byteBuffer.limit(byteBuffer.capacity());
        }
        if (byteBuffer == null || byteBuffer.remaining() < n) {
            int n2 = byteBuffer != null ? byteBuffer.position() : 0;
            ByteBuffer byteBuffer2 = BufferUtils.createByteBuffer(n2 + n);
            if (byteBuffer != null) {
                byteBuffer.flip();
                byteBuffer2.put(byteBuffer);
                byteBuffer2.position(n2);
            }
            byteBuffer = byteBuffer2;
        }
        return byteBuffer;
    }

    public static void printCurrentDirectMemory(StringBuilder stringBuilder) {
        boolean bl;
        long l = 0L;
        long l2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        boolean bl2 = bl = stringBuilder == null;
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        if (trackDirectMemory) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            for (BufferInfo bufferInfo : trackedBuffers.values()) {
                if (bufferInfo.type == ByteBuffer.class) {
                    l += (long)bufferInfo.size;
                    n7 += bufferInfo.size;
                    ++n2;
                    continue;
                }
                if (bufferInfo.type == FloatBuffer.class) {
                    l += (long)bufferInfo.size;
                    n6 += bufferInfo.size;
                    ++n;
                    continue;
                }
                if (bufferInfo.type == IntBuffer.class) {
                    l += (long)bufferInfo.size;
                    n8 += bufferInfo.size;
                    ++n3;
                    continue;
                }
                if (bufferInfo.type == ShortBuffer.class) {
                    l += (long)bufferInfo.size;
                    n9 += bufferInfo.size;
                    ++n4;
                    continue;
                }
                if (bufferInfo.type != DoubleBuffer.class) continue;
                l += (long)bufferInfo.size;
                n10 += bufferInfo.size;
                ++n5;
            }
            stringBuilder.append("Existing buffers: ").append(trackedBuffers.size()).append("\n");
            stringBuilder.append("(b: ").append(n2).append("  f: ").append(n).append("  i: ").append(n3).append("  s: ").append(n4).append("  d: ").append(n5).append(")").append("\n");
            stringBuilder.append("Total   heap memory held: ").append(l2 / 1024L).append("kb\n");
            stringBuilder.append("Total direct memory held: ").append(l / 1024L).append("kb\n");
            stringBuilder.append("(b: ").append(n7 / 1024).append("kb  f: ").append(n6 / 1024).append("kb  i: ").append(n8 / 1024).append("kb  s: ").append(n9 / 1024).append("kb  d: ").append(n10 / 1024).append("kb)").append("\n");
        } else {
            stringBuilder.append("Total   heap memory held: ").append(l2 / 1024L).append("kb\n");
            stringBuilder.append("Only heap memory available, if you want to monitor direct memory use BufferUtils.setTrackDirectMemoryEnabled(true) during initialization.").append("\n");
        }
        if (bl) {
            System.out.println(stringBuilder.toString());
        }
    }

    private static Method loadMethod(String string, String string2) {
        try {
            Method method = Class.forName(string).getMethod(string2, new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadCleanerMethods() {
        if (loadedMethods.getAndSet(true)) {
            return;
        }
        AtomicBoolean atomicBoolean = loadedMethods;
        synchronized (atomicBoolean) {
            cleanerMethod = BufferUtils.loadMethod("sun.nio.ch.DirectBuffer", "cleaner");
            cleanMethod = BufferUtils.loadMethod("sun.misc.Cleaner", "clean");
            viewedBufferMethod = BufferUtils.loadMethod("sun.nio.ch.DirectBuffer", "viewedBuffer");
            if (viewedBufferMethod == null) {
                viewedBufferMethod = BufferUtils.loadMethod("sun.nio.ch.DirectBuffer", "attachment");
            }
            ByteBuffer byteBuffer = BufferUtils.createByteBuffer(1);
            Class<?> clazz = byteBuffer.getClass();
            try {
                freeMethod = clazz.getMethod("free", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public static void destroyDirectBuffer(Buffer buffer) {
        if (!BufferUtils.isDirect(buffer)) {
            return;
        }
        BufferUtils.loadCleanerMethods();
        try {
            if (freeMethod != null) {
                freeMethod.invoke((Object)buffer, new Object[0]);
            } else {
                Object object = cleanerMethod.invoke((Object)buffer, new Object[0]);
                if (object != null) {
                    cleanMethod.invoke(object, new Object[0]);
                } else {
                    Object object2 = viewedBufferMethod.invoke((Object)buffer, new Object[0]);
                    if (object2 != null) {
                        BufferUtils.destroyDirectBuffer((Buffer)object2);
                    } else {
                        Logger.getLogger(BufferUtils.class.getName()).log(Level.SEVERE, "Buffer cannot be destroyed: {0}", buffer);
                    }
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(BufferUtils.class.getName()).log(Level.SEVERE, "{0}", illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger(BufferUtils.class.getName()).log(Level.SEVERE, "{0}", illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.getLogger(BufferUtils.class.getName()).log(Level.SEVERE, "{0}", invocationTargetException);
        }
        catch (SecurityException securityException) {
            Logger.getLogger(BufferUtils.class.getName()).log(Level.SEVERE, "{0}", securityException);
        }
    }

    private static boolean isDirect(Buffer buffer) {
        if (buffer instanceof FloatBuffer) {
            return ((FloatBuffer)buffer).isDirect();
        }
        if (buffer instanceof IntBuffer) {
            return ((IntBuffer)buffer).isDirect();
        }
        if (buffer instanceof ShortBuffer) {
            return ((ShortBuffer)buffer).isDirect();
        }
        if (buffer instanceof ByteBuffer) {
            return ((ByteBuffer)buffer).isDirect();
        }
        if (buffer instanceof DoubleBuffer) {
            return ((DoubleBuffer)buffer).isDirect();
        }
        if (buffer instanceof LongBuffer) {
            return ((LongBuffer)buffer).isDirect();
        }
        throw new UnsupportedOperationException(" BufferUtils.isDirect was called on " + buffer.getClass().getName());
    }

    static {
        loadedMethods = new AtomicBoolean(false);
        cleanerMethod = null;
        cleanMethod = null;
        viewedBufferMethod = null;
        freeMethod = null;
    }

    private static class ClearReferences
    extends Thread {
        ClearReferences() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Reference reference = removeCollected.remove();
                    trackedBuffers.remove(reference);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                return;
            }
        }
    }

    private static class BufferInfo
    extends PhantomReference<Buffer> {
        private final Class<?> type;
        private final int size;

        public BufferInfo(Class<?> clazz, int n, Buffer buffer, ReferenceQueue<? super Buffer> referenceQueue) {
            super(buffer, referenceQueue);
            this.type = clazz;
            this.size = n;
        }
    }
}

